/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.configuralize.Language;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.DebugReportedEvent;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.ArrayUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.RandomStringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import github.scarsz.discordsrv.dependencies.google.common.util.concurrent.ThreadFactoryBuilder;
import github.scarsz.discordsrv.dependencies.google.gson.Gson;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Category;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.dependencies.jda.api.requests.CloseCode;
import github.scarsz.discordsrv.dependencies.kevinsawicki.http.HttpRequest;
import github.scarsz.discordsrv.hooks.PluginHook;
import github.scarsz.discordsrv.hooks.SkriptHook;
import github.scarsz.discordsrv.hooks.VaultHook;
import github.scarsz.discordsrv.hooks.chat.TownyChatHook;
import github.scarsz.discordsrv.listeners.DiscordDisconnectListener;
import github.scarsz.discordsrv.modules.voice.VoiceModule;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.ManifestUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.PrettyUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;

public class DebugUtil {
    public static final List<String> SENSITIVE_OPTIONS = Arrays.asList("BotToken", "Experiment_JdbcAccountLinkBackend", "Experiment_JdbcUsername", "Experiment_JdbcPassword", "ProxyHost", "ProxyPort", "ProxyUser", "ProxyPassword");
    public static int initializationCount = 0;
    private static final Gson GSON = new Gson();
    private static final SecureRandom RANDOM = new SecureRandom();

    public static String run(String requester) {
        return DebugUtil.run(requester, 256);
    }

    public static String run(String requester, int aesBits) {
        LinkedList<Map<String, String>> files = new LinkedList<Map<String, String>>();
        try {
            String debugInformation = DebugUtil.getDebugInformation();
            boolean noIssues = debugInformation.contains("No issues detected automatically");
            Runnable addDebugInfo = () -> files.add(DebugUtil.fileMap("debug-info.txt", "Potential issues in the installation", debugInformation));
            if (!noIssues) {
                addDebugInfo.run();
            }
            files.add(DebugUtil.fileMap("discordsrv-info.txt", "general information about the plugin", String.join((CharSequence)"\n", "Version information:", "   plugin version: " + (Object)((Object)DiscordSRV.getPlugin()), "   config version: " + DiscordSRV.config().getString("ConfigVersion"), "   build date: " + ManifestUtil.getManifestValue("Build-Date"), "   build git revision: " + ManifestUtil.getManifestValue("Git-Revision"), "   build number: " + ManifestUtil.getManifestValue("Build-Number"), "   build origin: " + ManifestUtil.getManifestValue("Build-Origin"), "Plugin status:", "   jda status: " + (DiscordUtil.getJda() != null && DiscordUtil.getJda().getGatewayPing() != -1L ? DiscordUtil.getJda().getStatus().name() + " / " + DiscordUtil.getJda().getGatewayPing() + "ms" : "build not finished"), "   channels: " + DiscordSRV.getPlugin().getChannels(), "   console channel: " + DiscordSRV.getPlugin().getConsoleChannel(), "   main chat channel: " + DiscordSRV.getPlugin().getMainChatChannel() + " -> " + DiscordSRV.getPlugin().getMainTextChannel(), "   main guild: " + DiscordSRV.getPlugin().getMainGuild(), "Environmental variables:", "   discord main guild roles: " + (DiscordSRV.getPlugin().getMainGuild() == null ? "invalid main guild" : DiscordSRV.getPlugin().getMainGuild().getRoles().stream().map((Function<Role, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lgithub/scarsz/discordsrv/dependencies/jda/api/entities/Role;)Ljava/lang/String;)()).collect(Collectors.toList())), "   discord server owner: " + (DiscordSRV.getPlugin().getMainGuild() == null ? "invalid main guild" : DiscordSRV.getPlugin().getMainGuild().getOwner()), "   vault groups: " + Arrays.toString(VaultHook.getGroups()), "   PlaceholderAPI expansions: " + DebugUtil.getInstalledPlaceholderApiExpansions(), "   Skripts: " + String.join((CharSequence)", ", SkriptHook.getSkripts()), "   /discord command executor: " + (Bukkit.getServer().getPluginCommand("discord") != null ? Bukkit.getServer().getPluginCommand("discord").getPlugin() : ""), "   hooked plugins: " + DiscordSRV.getPlugin().getPluginHooks().stream().map(PluginHook::getPlugin).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", ")), "Threads:", "   channel topic updater -> alive: " + (DiscordSRV.getPlugin().getChannelTopicUpdater() != null && DiscordSRV.getPlugin().getChannelTopicUpdater().isAlive()), "   server watchdog -> alive: " + (DiscordSRV.getPlugin().getServerWatchdog() != null && DiscordSRV.getPlugin().getServerWatchdog().isAlive()), "   nickname updater -> alive: " + (DiscordSRV.getPlugin().getNicknameUpdater() != null && DiscordSRV.getPlugin().getNicknameUpdater().isAlive()), "   presence updater -> alive: " + (DiscordSRV.getPlugin().getPresenceUpdater() != null && DiscordSRV.getPlugin().getPresenceUpdater().isAlive()), "Guilds:" + DebugUtil.listGuilds())));
            files.add(DebugUtil.fileMap("relevant-lines-from-server.log", "lines from the server console containing \"discordsrv\"", DebugUtil.getRelevantLinesFromServerLog()));
            files.add(DebugUtil.fileMap("config.yml", "raw plugins/DiscordSRV/config.yml", FileUtils.readFileToString(DiscordSRV.getPlugin().getConfigFile(), StandardCharsets.UTF_8)));
            files.add(DebugUtil.fileMap("config-active.yml", "active plugins/DiscordSRV/config.yml", DebugUtil.getActiveConfig()));
            files.add(DebugUtil.fileMap("messages.yml", "raw plugins/DiscordSRV/messages.yml", FileUtils.readFileToString(DiscordSRV.getPlugin().getMessagesFile(), StandardCharsets.UTF_8)));
            files.add(DebugUtil.fileMap("voice.yml", "raw plugins/DiscordSRV/voice.yml", FileUtils.readFileToString(DiscordSRV.getPlugin().getVoiceFile(), StandardCharsets.UTF_8)));
            files.add(DebugUtil.fileMap("linking.yml", "raw plugins/DiscordSRV/linking.yml", FileUtils.readFileToString(DiscordSRV.getPlugin().getLinkingFile(), StandardCharsets.UTF_8)));
            files.add(DebugUtil.fileMap("synchronization.yml", "raw plugins/DiscordSRV/synchronization.yml", FileUtils.readFileToString(DiscordSRV.getPlugin().getSynchronizationFile(), StandardCharsets.UTF_8)));
            files.add(DebugUtil.fileMap("alerts.yml", "raw plugins/DiscordSRV/alerts.yml", FileUtils.readFileToString(DiscordSRV.getPlugin().getAlertsFile(), StandardCharsets.UTF_8)));
            files.add(DebugUtil.fileMap("server-info.txt", null, DebugUtil.getServerInfo()));
            files.add(DebugUtil.fileMap("logger-details.txt", null, DebugUtil.getLoggerInfo()));
            files.add(DebugUtil.fileMap("registered-listeners.txt", "list of registered listeners for Bukkit events DiscordSRV uses", DebugUtil.getRegisteredListeners()));
            files.add(DebugUtil.fileMap("permissions.txt", null, DebugUtil.getPermissions()));
            files.add(DebugUtil.fileMap("threads.txt", "Threads with DiscordSRV in the name or that have trace elements with DiscordSRV's classes", DebugUtil.getThreads()));
            files.add(DebugUtil.fileMap("system-info.txt", null, DebugUtil.getSystemInfo()));
            if (noIssues) {
                addDebugInfo.run();
            }
        }
        catch (Exception e) {
            DiscordSRV.error(e);
            return "Failed to collect debug information: " + e.getMessage() + ". Check the console for further details.";
        }
        return DebugUtil.uploadReport(files, aesBits, requester);
    }

    private static String listGuilds() {
        if (DiscordUtil.getJda() == null) {
            return "\n   null JDA";
        }
        String list = "";
        for (Guild server : DiscordUtil.getJda().getGuilds()) {
            list = list + "\n   " + server + ":  [";
            for (TextChannel channel : server.getTextChannels()) {
                list = list + channel + ", ";
            }
            list = list + "]";
        }
        return list;
    }

    private static Map<String, String> fileMap(String name, String description, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("description", description);
        map.put("content", content);
        map.put("type", "text/plain");
        return map;
    }

    private static String getActiveConfig() {
        try {
            Dynamic activeConfig = DiscordSRV.config().getProvider("config").getValues();
            StringBuilder stringBuilder = new StringBuilder(500);
            Iterator iterator = activeConfig.allChildren().iterator();
            while (iterator.hasNext()) {
                Dynamic child = (Dynamic)iterator.next();
                if (child.allChildren().count() == 0L) {
                    stringBuilder.append(child.key().asObject()).append(": ").append(child.asObject());
                } else {
                    StringJoiner childJoiner = new StringJoiner(", ");
                    Iterator childIterator = child.allChildren().iterator();
                    while (childIterator.hasNext()) {
                        Dynamic grandchild = (Dynamic)childIterator.next();
                        childJoiner.add("- " + grandchild.asObject());
                    }
                    stringBuilder.append(child.key().asObject()).append(": ").append(childJoiner);
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            return "Failed to get parsed config: " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace(e);
        }
    }

    private static String getInstalledPlaceholderApiExpansions() {
        if (!PluginUtil.pluginHookIsEnabled("placeholderapi")) {
            return "PlaceholderAPI not hooked/no expansions installed";
        }
        File[] extensionFiles = new File(DiscordSRV.getPlugin().getDataFolder().getParentFile(), "PlaceholderAPI/expansions").listFiles();
        if (extensionFiles == null) {
            return "PlaceholderAPI/expansions is not directory/IO error";
        }
        return Arrays.stream(extensionFiles).map(File::getName).collect(Collectors.joining(", "));
    }

    private static String getRelevantLinesFromServerLog() {
        LinkedList<String> output = new LinkedList<String>();
        try {
            FileReader fr = new FileReader(new File("logs/latest.log"));
            BufferedReader br = new BufferedReader(fr);
            boolean done = false;
            while (!done) {
                String line = br.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                if ((!line.toLowerCase().contains("discordsrv") || line.toLowerCase().contains("[discordsrv] chat:")) && !line.toLowerCase().contains(" /discord")) continue;
                output.add(DiscordUtil.aggressiveStrip(line));
            }
        }
        catch (IOException e) {
            DiscordSRV.error(e);
        }
        return String.join((CharSequence)"\n", output);
    }

    private static String getServerInfo() {
        LinkedList<String> output = new LinkedList<String>();
        List plugins = Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(Object::toString).sorted().collect(Collectors.toList());
        output.add("server players: " + PlayerUtil.getOnlinePlayers().size() + "/" + Bukkit.getMaxPlayers());
        output.add("server plugins: " + plugins);
        output.add("");
        output.add("Minecraft version: " + Bukkit.getVersion());
        output.add("Bukkit API version: " + Bukkit.getBukkitVersion());
        output.add("Server online mode: " + Bukkit.getOnlineMode());
        return String.join((CharSequence)"\n", output);
    }

    private static String getLoggerInfo() {
        LinkedList<String> output = new LinkedList<String>();
        try {
            LoggerContext config = (LoggerContext)LogManager.getContext((boolean)false);
            output.add("Log level: " + config.getConfiguration().getLoggerConfig("").getLevel());
            Logger rootLogger = (Logger)LogManager.getRootLogger();
            ArrayList<String> filters = new ArrayList<String>();
            Iterator filterIterator = rootLogger.getFilters();
            while (filterIterator.hasNext()) {
                Object next = filterIterator.next();
                filters.add(next.getClass().getName() + ": " + next);
            }
            output.add("Filters: " + String.join((CharSequence)", ", filters));
            ArrayList<String> appenders = new ArrayList<String>();
            for (Map.Entry entry : rootLogger.getAppenders().entrySet()) {
                appenders.add((String)entry.getKey() + ": " + ((Appender)entry.getValue()).getName() + " (" + ((Appender)entry.getValue()).getClass().getName() + ")");
            }
            output.add("Appenders: " + String.join((CharSequence)", ", appenders));
        }
        catch (Throwable t) {
            output.add("Failed to log debug message for logging");
            output.add(ExceptionUtils.getMessage(t));
        }
        return String.join((CharSequence)"\n", output);
    }

    private static String getDebugInformation() {
        String consoleChannelId;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (initializationCount > 1) {
            messages.add(new Message(Message.Type.PLUGIN_RELOADED, new String[0]));
        }
        if (DiscordUtil.getJda() == null) {
            if (DiscordSRV.invalidBotToken || DiscordDisconnectListener.mostRecentCloseCode == CloseCode.AUTHENTICATION_FAILED) {
                messages.add(new Message(Message.Type.INVALID_BOT_TOKEN, new String[0]));
            } else if (DiscordDisconnectListener.mostRecentCloseCode == CloseCode.DISALLOWED_INTENTS) {
                messages.add(new Message(Message.Type.DISALLOWED_INTENTS, new String[0]));
            } else {
                messages.add(new Message(Message.Type.NOT_CONNECTED, new String[0]));
            }
        } else if (DiscordUtil.getJda().getGuilds().isEmpty()) {
            messages.add(new Message(Message.Type.NOT_IN_ANY_SERVERS, new String[0]));
        }
        if (DiscordUtil.getJda() != null) {
            if (DiscordSRV.getPlugin().getMainTextChannel() == null) {
                if (DiscordSRV.getPlugin().getConsoleChannel() == null) {
                    messages.add(new Message(Message.Type.NO_CHANNELS_LINKED, new String[0]));
                } else {
                    messages.add(new Message(Message.Type.NO_CHAT_CHANNELS_LINKED, new String[0]));
                }
            }
            for (Map.Entry<String, String> entry : DiscordSRV.getPlugin().getChannels().entrySet()) {
                String discordName;
                TextChannel textChannel = DiscordUtil.getTextChannelById(entry.getValue());
                if (textChannel == null || !textChannel.getId().equals(entry.getValue())) {
                    messages.add(new Message(Message.Type.INVALID_CHANNEL, "{" + entry.getKey() + ":" + entry.getValue() + "}"));
                    continue;
                }
                String configName = entry.getKey();
                if (!configName.equals(discordName = textChannel.getName()) || configName.replaceAll("[\\w\\d\\s]", "").isEmpty() && !configName.contains("mc") && !configName.contains("minecraft") && !configName.contains("chat") || configName.equals("global")) continue;
                messages.add(new Message(Message.Type.SAME_CHANNEL_NAME, entry.getKey()));
            }
        }
        if ((consoleChannelId = DiscordSRV.config().getString("DiscordConsoleChannelId")) != null && !consoleChannelId.matches("^0*$") && DiscordSRV.getPlugin().getChannels().values().stream().filter(Objects::nonNull).anyMatch(channelId -> channelId.equals(consoleChannelId))) {
            messages.add(new Message(Message.Type.CONSOLE_AND_CHAT_SAME_CHANNEL, new String[0]));
        }
        String roleName = DiscordSRV.config().getStringElse("MinecraftDiscordAccountLinkedRoleNameToAddUserTo", null);
        if (DiscordUtil.getJda() != null && roleName != null) {
            try {
                Role role = DiscordUtil.resolveRole(roleName);
                if (role != null && DiscordSRV.getPlugin().getGroupSynchronizables().values().stream().anyMatch(roleId -> roleId.equals(role.getId()))) {
                    messages.add(new Message(Message.Type.LINKED_ROLE_GROUP_SYNC, new String[0]));
                }
            }
            catch (Throwable role) {
                // empty catch block
            }
        }
        if (PluginUtil.pluginHookIsEnabled("TownyChat")) {
            try {
                String mainChannelName = TownyChatHook.getMainChannelName();
                if (mainChannelName != null && !DiscordSRV.getPlugin().getChannels().containsKey(mainChannelName)) {
                    messages.add(new Message(Message.Type.NO_TOWNY_MAIN_CHANNEL, mainChannelName));
                }
            }
            catch (Throwable mainChannelName) {
                // empty catch block
            }
        }
        if (!DiscordSRV.config().getBooleanElse("RespectChatPlugins", true)) {
            messages.add(new Message(Message.Type.RESPECT_CHAT_PLUGINS, new String[0]));
        }
        if (!Debug.anyEnabled()) {
            messages.add(new Message(Message.Type.DEBUG_MODE_NOT_ENABLED, new String[0]));
        }
        if (DiscordSRV.updateIsAvailable) {
            messages.add(new Message(Message.Type.UPDATE_AVAILABLE, new String[0]));
        } else if (!DiscordSRV.updateChecked || DiscordSRV.isUpdateCheckDisabled()) {
            messages.add(new Message(Message.Type.UPDATE_CHECK_DISABLED, new String[0]));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (messages.isEmpty()) {
            stringBuilder.append("No issues detected automatically\n");
        } else {
            messages.stream().sorted((one, two) -> Boolean.compare(((Message)one).isWarning(), ((Message)two).isWarning())).forEach(message -> stringBuilder.append(((Message)message).isWarning() ? "[Warn] " : "[Error] ").append(message.getMessage()).append("\n"));
        }
        stringBuilder.append("\nFailedTests: [").append(messages.stream().map(Message::getTypeName).collect(Collectors.joining(", "))).append(']');
        stringBuilder.append("\nDebuggerCategories: [").append(String.join((CharSequence)", ", DiscordSRV.getPlugin().getDebuggerCategories())).append(']');
        return stringBuilder.toString();
    }

    private static String getRegisteredListeners() {
        LinkedList<String> output = new LinkedList<String>();
        ArrayList listenedClasses = new ArrayList();
        try {
            listenedClasses.add(Class.forName("io.papermc.paper.event.player.AsyncChatEvent"));
            listenedClasses.add(Class.forName("io.papermc.paper.event.player.ChatEvent"));
        }
        catch (ClassNotFoundException ignored) {
            output.add("(Async)ChatEvent not available.");
        }
        listenedClasses.addAll(Arrays.asList(AsyncPlayerChatEvent.class, PlayerChatEvent.class, PlayerJoinEvent.class, PlayerQuitEvent.class, PlayerDeathEvent.class, AsyncPlayerPreLoginEvent.class, PlayerLoginEvent.class));
        try {
            listenedClasses.add(Class.forName("org.bukkit.event.player.PlayerAdvancementDoneEvent"));
        }
        catch (ClassNotFoundException ignored) {
            try {
                listenedClasses.add(Class.forName("org.bukkit.event.player.PlayerAchievementAwardedEvent"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                output.add("PlayerAdvancementDoneEvent and PlayerAchievementAwardedEvent both unavailable??");
            }
        }
        for (Class clazz : listenedClasses) {
            try {
                Method getHandlerList;
                Class effectiveClass = null;
                try {
                    getHandlerList = clazz.getDeclaredMethod("getHandlerList", new Class[0]);
                }
                catch (NoSuchMethodException ignored) {
                    Class superClass = clazz.getSuperclass();
                    getHandlerList = superClass.getDeclaredMethod("getHandlerList", new Class[0]);
                    effectiveClass = superClass;
                }
                HandlerList handlerList = (HandlerList)getHandlerList.invoke(null, new Object[0]);
                List registeredListeners = Arrays.stream(handlerList.getRegisteredListeners()).filter(registeredListener -> !registeredListener.getPlugin().getName().equalsIgnoreCase("DiscordSRV")).sorted(Comparator.comparing(RegisteredListener::getPriority)).collect(Collectors.toList());
                if (registeredListeners.isEmpty()) {
                    output.add("No " + clazz + " listeners registered.");
                } else {
                    output.add("Registered " + (clazz.isAnnotationPresent(Deprecated.class) ? "(DEPRECATED) " : "") + clazz.getSimpleName() + (effectiveClass != null ? " (" + effectiveClass.getSimpleName() + ")" : "") + " listeners (" + registeredListeners.size() + "): " + registeredListeners.stream().map(listener -> listener.getPlugin().getName()).distinct().sorted().collect(Collectors.joining(", ")));
                    for (RegisteredListener registeredListener2 : registeredListeners) {
                        output.add(" - " + registeredListener2.getPlugin().getName() + ": " + registeredListener2.getListener().getClass().getName() + " at " + registeredListener2.getPriority());
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                output.add("Error with " + clazz.getSimpleName() + ": " + e.getClass().getName() + ": " + e.getMessage());
            }
            output.add("");
        }
        return String.join((CharSequence)"\n", output);
    }

    private static String getPermissions() {
        LinkedList<String> output = new LinkedList<String>();
        if (DiscordUtil.getJda() == null) {
            return "JDA == null";
        }
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            output.add("main guild -> null");
        } else {
            ArrayList<String> guildPermissions = new ArrayList<String>();
            if (DiscordUtil.checkPermission(mainGuild, Permission.ADMINISTRATOR)) {
                guildPermissions.add("administrator");
            }
            if (DiscordUtil.checkPermission(mainGuild, Permission.MANAGE_ROLES)) {
                guildPermissions.add("manage-roles");
            }
            if (DiscordUtil.checkPermission(mainGuild, Permission.NICKNAME_MANAGE)) {
                guildPermissions.add("nickname-manage");
            }
            if (DiscordUtil.checkPermission(mainGuild, Permission.MANAGE_WEBHOOKS)) {
                guildPermissions.add("manage-webhooks");
            }
            output.add("main guild -> " + mainGuild + " [" + String.join((CharSequence)", ", guildPermissions) + "]");
        }
        VoiceChannel lobbyChannel = VoiceModule.getLobbyChannel();
        if (lobbyChannel == null) {
            output.add("voice lobby -> null");
        } else {
            ArrayList<String> channelPermissions = new ArrayList<String>();
            if (DiscordUtil.checkPermission(lobbyChannel, Permission.VOICE_MOVE_OTHERS)) {
                channelPermissions.add("move-members");
            }
            output.add("voice lobby -> " + lobbyChannel + " [" + String.join((CharSequence)", ", channelPermissions) + "]");
            Category category = lobbyChannel.getParent();
            if (category == null) {
                output.add("voice category -> null");
            } else {
                ArrayList<String> categoryPermissions = new ArrayList<String>();
                if (DiscordUtil.checkPermission(category, Permission.VOICE_MOVE_OTHERS)) {
                    categoryPermissions.add("move-members");
                }
                if (DiscordUtil.checkPermission(category, Permission.MANAGE_CHANNEL)) {
                    categoryPermissions.add("manage-channel");
                }
                if (DiscordUtil.checkPermission(category, Permission.MANAGE_PERMISSIONS)) {
                    categoryPermissions.add("manage-permissions");
                }
                output.add("voice category -> " + category + " [" + String.join((CharSequence)", ", categoryPermissions) + "]");
            }
        }
        TextChannel consoleChannel = DiscordSRV.getPlugin().getConsoleChannel();
        if (consoleChannel == null) {
            output.add("console channel -> null");
        } else {
            ArrayList<String> consolePermissions = new ArrayList<String>();
            if (DiscordUtil.checkPermission(consoleChannel, Permission.MESSAGE_READ)) {
                consolePermissions.add("read");
            }
            if (DiscordUtil.checkPermission(consoleChannel, Permission.MESSAGE_WRITE)) {
                consolePermissions.add("write");
            }
            if (DiscordUtil.checkPermission(consoleChannel, Permission.MANAGE_CHANNEL)) {
                consolePermissions.add("channel-manage");
            }
            output.add("console channel -> " + consoleChannel + " [" + String.join((CharSequence)", ", consolePermissions) + "]");
        }
        DiscordSRV.getPlugin().getChannels().forEach((channel, textChannelId) -> {
            TextChannel textChannel;
            TextChannel textChannel2 = textChannel = StringUtils.isNotBlank(textChannelId) ? DiscordSRV.getPlugin().getJda().getTextChannelById((String)textChannelId) : null;
            if (textChannel != null) {
                LinkedList<String> outputForChannel = new LinkedList<String>();
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_READ)) {
                    outputForChannel.add("read");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_WRITE)) {
                    outputForChannel.add("write");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MANAGE_CHANNEL)) {
                    outputForChannel.add("channel-manage");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_MANAGE)) {
                    outputForChannel.add("message-manage");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MANAGE_WEBHOOKS)) {
                    outputForChannel.add("manage-webhooks");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_ADD_REACTION)) {
                    outputForChannel.add("add-reactions");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_HISTORY)) {
                    outputForChannel.add("history");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_ATTACH_FILES)) {
                    outputForChannel.add("attach-files");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_MENTION_EVERYONE)) {
                    outputForChannel.add("mention-everyone");
                }
                if (DiscordUtil.checkPermission(textChannel, Permission.MESSAGE_EXT_EMOJI)) {
                    outputForChannel.add("external-emotes");
                }
                output.add(channel + " -> " + textChannel + " [" + String.join((CharSequence)", ", outputForChannel) + "]");
            } else {
                output.add(channel + " -> null");
            }
        });
        return String.join((CharSequence)"\n", output);
    }

    private static String getThreads() {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        HashSet<Thread> alreadyLoggedThreads = new HashSet<Thread>();
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread2 = entry.getKey();
            String threadName = thread2.getName();
            StackTraceElement[] traceElements = entry.getValue();
            if (!threadName.contains("DiscordSRV") && !Arrays.stream(traceElements).anyMatch(trace -> trace.getClassName().startsWith("github.scarsz.discordsrv")) || !alreadyLoggedThreads.add(thread2)) continue;
            stringBuilder.append(threadName).append(":\n").append(PrettyUtil.beautify(traceElements)).append("\n");
        }
        Thread serverThread = stackTraces.keySet().stream().filter(thread -> thread.getName().equals("Server thread")).findAny().orElse(null);
        if (serverThread != null && alreadyLoggedThreads.add(serverThread)) {
            stringBuilder.append("Server Thread:\n").append(PrettyUtil.beautify(serverThread.getStackTrace()));
        }
        stringBuilder.append("\nOther threads:\n");
        for (Thread thread2 : stackTraces.keySet()) {
            if (!alreadyLoggedThreads.add(thread2)) continue;
            Plugin plugin = null;
            try {
                plugin = SchedulerUtil.isFolia() != false ? null : (Plugin)Bukkit.getScheduler().getActiveWorkers().stream().filter(work -> work.getThread() == thread2).map(BukkitWorker::getOwner).findAny().orElse(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stringBuilder.append("- ").append(thread2.getName()).append(plugin != null ? " (Owned by " + plugin.getName() + ")" : "").append('\n');
        }
        if (SchedulerUtil.isFolia().booleanValue()) {
            stringBuilder.append("\nScheduler info is not available on Folia.");
            return stringBuilder.toString();
        }
        try {
            BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
            HashMap<Plugin, AtomicInteger> scheduledTaskCounts = new HashMap<Plugin, AtomicInteger>();
            HashMap<Plugin, AtomicInteger> runningTaskCounts = new HashMap<Plugin, AtomicInteger>();
            for (BukkitTask task : bukkitScheduler.getPendingTasks()) {
                scheduledTaskCounts.computeIfAbsent(task.getOwner(), key -> new AtomicInteger()).incrementAndGet();
            }
            for (BukkitWorker activeWorker : bukkitScheduler.getActiveWorkers()) {
                runningTaskCounts.computeIfAbsent(activeWorker.getOwner(), key -> new AtomicInteger()).incrementAndGet();
            }
            stringBuilder.append("\nScheduled tasks:\n");
            scheduledTaskCounts.forEach((pl, in) -> stringBuilder.append(pl.getName()).append(": ").append(in.get()).append('\n'));
            stringBuilder.append("\nActive workers:\n");
            runningTaskCounts.forEach((pl, in) -> stringBuilder.append(pl.getName()).append(": ").append(in.get()).append('\n'));
        }
        catch (Throwable throwable) {
            stringBuilder.append("\nFailed to get scheduler information: ").append(throwable);
        }
        return stringBuilder.toString();
    }

    private static String getSystemInfo() {
        LinkedList<String> output = new LinkedList<String>();
        output.add("Available processors (cores): " + Runtime.getRuntime().availableProcessors());
        output.add("");
        output.add("Free memory for JVM (MB): " + Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        output.add("Maximum memory for JVM (MB): " + (Runtime.getRuntime().maxMemory() == Long.MAX_VALUE ? "no limit" : Long.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L)));
        output.add("Total memory available for JVM (MB): " + Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        output.add("");
        File serverRoot = DiscordSRV.getPlugin().getDataFolder().getAbsoluteFile().getParentFile().getParentFile();
        output.add("Server storage:");
        output.add("- total space (MB): " + serverRoot.getTotalSpace() / 1024L / 1024L);
        output.add("- free space (MB): " + serverRoot.getFreeSpace() / 1024L / 1024L);
        output.add("- usable space (MB): " + serverRoot.getUsableSpace() / 1024L / 1024L);
        output.add("");
        Map<String, String> systemProperties = ManagementFactory.getRuntimeMXBean().getSystemProperties();
        output.add("Java version: " + systemProperties.get("java.version"));
        output.add("Java vendor: " + systemProperties.get("java.vendor") + " " + systemProperties.get("java.vendor.url"));
        output.add("Java home: " + systemProperties.get("java.home"));
        output.add("Command line: " + systemProperties.get("sun.java.command"));
        output.add("Time zone: " + systemProperties.get("user.timezone"));
        return String.join((CharSequence)"\n", output);
    }

    private static String uploadReport(List<Map<String, String>> files, int aesBits, String requester) {
        if (files.size() == 0) {
            return "ERROR/Failed to collect debug information: files list == 0... How???";
        }
        files.forEach(map -> {
            String content = (String)map.get("content");
            if (StringUtils.isNotBlank(content)) {
                for (String option : SENSITIVE_OPTIONS) {
                    String value = DiscordSRV.config().getString(option);
                    if (!StringUtils.isNotBlank(value) || value.equalsIgnoreCase("username")) continue;
                    content = content.replace(value, "REDACTED");
                }
                content = content.replaceAll("[A-Za-z\\d]{24}\\.[\\w-]{6}\\.[\\w-]{27}", "TOKEN REDACTED");
            } else {
                content = "blank";
            }
            map.put("content", content);
        });
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("DiscordSRV - Debug Report Upload").build();
        ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
        try {
            return executor.invokeAny(Collections.singletonList(() -> {
                String url = DebugUtil.uploadToBin("https://bin.scarsz.me", aesBits, files, "Requested by " + requester);
                DiscordSRV.api.callEvent(new DebugReportedEvent(requester, url));
                return url;
            }), 20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            DiscordSRV.error("Interrupted while uploading a debug report");
            return "ERROR/Interrupted while uploading the debug report";
        }
        catch (ExecutionException | TimeoutException e) {
            if (e instanceof ExecutionException && e.getCause().getMessage().toLowerCase().contains("illegal key size")) {
                return "ERROR/" + e.getCause().getMessage() + ". Try using /discordsrv debug 128";
            }
            File debugFolder = DiscordSRV.getPlugin().getDebugFolder();
            if (!debugFolder.exists()) {
                debugFolder.mkdir();
            }
            String debugName = "debug-" + System.currentTimeMillis() + ".zip";
            File zipFile = new File(debugFolder, debugName);
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
                for (Map<String, String> file : files) {
                    zipOutputStream.putNextEntry(new ZipEntry(file.get("name")));
                    byte[] data = file.get("content").getBytes();
                    zipOutputStream.write(data, 0, data.length);
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.close();
            }
            catch (IOException ex) {
                DiscordSRV.error(ex);
                return "ERROR/Failed to upload to bin, and write to disk. (Unable to store debug report). Caused by " + e.getCause().getMessage() + " and " + ex.getClass().getName() + ": " + ex.getMessage();
            }
            return "GENERATED TO FILE/Failed to upload to bin.scarsz.me, placed into plugins/DiscordSRV/debug/" + debugName + ". Caused by " + (e instanceof ExecutionException ? e.getCause().getMessage() : e.getMessage());
        }
    }

    private static String uploadToBin(String binHost, int aesBits, List<Map<String, String>> files, String description) {
        String key = RandomStringUtils.randomAlphanumeric(aesBits == 256 ? 32 : 16);
        byte[] keyBytes = key.getBytes();
        ArrayList<HashMap<String, String>> encryptedFiles = new ArrayList<HashMap<String, String>>();
        for (Map<String, String> file : files) {
            HashMap<String, String> encryptedFile = new HashMap<String, String>(file);
            encryptedFile.entrySet().removeIf(entry -> StringUtils.isBlank((CharSequence)entry.getValue()));
            encryptedFile.replaceAll((k, v) -> DebugUtil.b64(DebugUtil.encrypt(keyBytes, (String)file.get(k))));
            encryptedFiles.add(encryptedFile);
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("description", DebugUtil.b64(DebugUtil.encrypt(keyBytes, description)));
        payload.put("expiration", TimeUnit.DAYS.toMinutes(21L));
        payload.put("files", encryptedFiles);
        HttpRequest request = HttpRequest.post(binHost + "/v1/post").userAgent("DiscordSRV " + DiscordSRV.version).send(GSON.toJson(payload));
        if (request.code() == 200) {
            Map json = GSON.fromJson(request.body(), Map.class);
            if (json.get("status").equals("ok")) {
                return binHost + "/" + json.get("bin") + "#" + key;
            }
            String reason = "";
            if (json.containsKey("error")) {
                Map error = (Map)json.get("error");
                reason = ": " + error.get("type") + " " + error.get("message");
            }
            throw new RuntimeException("Bin upload status wasn't ok" + reason);
        }
        throw new RuntimeException("Got bad HTTP status from Bin: " + request.code());
    }

    public static String getStackTrace() {
        LinkedList<String> stackTrace = new LinkedList<String>();
        stackTrace.add("Stack trace @ debug call (THIS IS NOT AN ERROR)");
        Arrays.stream(ExceptionUtils.getStackTrace(new Throwable()).split("\n")).filter(s -> s.toLowerCase().contains("discordsrv")).filter(s -> !s.contains("DebugUtil.getStackTrace")).forEach(stackTrace::add);
        return String.join((CharSequence)"\n", stackTrace);
    }

    public static String b64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] encrypt(byte[] key, String data) {
        return DebugUtil.encrypt(key, data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] encrypt(byte[] key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            byte[] iv = new byte[cipher.getBlockSize()];
            RANDOM.nextBytes(iv);
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            byte[] encrypted = cipher.doFinal(data);
            return ArrayUtils.addAll(iv, encrypted);
        }
        catch (InvalidKeyException e) {
            if (e.getMessage().toLowerCase().contains("illegal key size")) {
                throw new RuntimeException(e.getMessage(), e);
            }
            DiscordSRV.error(e);
            return null;
        }
        catch (Exception ex) {
            DiscordSRV.error(ex);
            return null;
        }
    }

    public static class Message {
        private final Type type;
        private final String[] args;

        public Message(Type type, String ... args) {
            this.type = type;
            this.args = args;
        }

        private boolean isWarning() {
            return this.type.warning;
        }

        public String getMessage() {
            return String.format(this.type.message, this.args);
        }

        public String getTypeName() {
            return this.type.name();
        }

        public static enum Type {
            NO_CHAT_CHANNELS_LINKED(true, "No chat channels linked"),
            NO_CHANNELS_LINKED(true, "No channels linked (chat & console)"),
            SAME_CHANNEL_NAME(true, "Channel %s has the same in-game and Discord channel name"),
            UPDATE_CHECK_DISABLED(true, "Update checking is disabled"),
            RESPECT_CHAT_PLUGINS(false, "You have RespectChatPlugins set to false. This means DiscordSRV will completely ignore any other plugin's attempts to cancel a chat message from being broadcasted to the server. Disabling this is NOT a valid solution to your chat messages not being sent to Discord."),
            PLUGIN_RELOADED(false, "Plugin has been initialized more than once (aka \"reloading\"). You will not receive support in this state."),
            INVALID_CHANNEL(false, "Invalid Channel %s (not found)"),
            NO_TOWNY_MAIN_CHANNEL(false, "No channel hooked to Towny's default channel: %s"),
            CONSOLE_AND_CHAT_SAME_CHANNEL(false, LangUtil.InternalMessage.CONSOLE_CHANNEL_ASSIGNED_TO_LINKED_CHANNEL.getDefinitions().get((Object)((Object)Language.EN))),
            NOT_IN_ANY_SERVERS(false, LangUtil.InternalMessage.BOT_NOT_IN_ANY_SERVERS.getDefinitions().get((Object)((Object)Language.EN))),
            NOT_CONNECTED(false, "Not connected to Discord!"),
            INVALID_BOT_TOKEN(false, "Invalid bot token, not connected to Discord."),
            DISALLOWED_INTENTS(false, "Disallowed intents (Make sure you followed all installation instructions), not connected to Discord."),
            DEBUG_MODE_NOT_ENABLED(false, "You do not have debug mode on. Run /discordsrv debugger, try to reproduce your problem and then run /discordsrv debugger upload to generate another report."),
            UPDATE_AVAILABLE(false, "Update available. Download: https://get.discordsrv.com / https://snapshot.discordsrv.com"),
            LINKED_ROLE_GROUP_SYNC(false, "Cannot have the role in MinecraftDiscordAccountLinkedRoleNameToAddUserTo as a role in GroupRoleSynchronizationGroupsAndRolesToSync");

            private final boolean warning;
            private final String message;

            private Type(boolean warning, String message) {
                this.warning = warning;
                this.message = message;
            }
        }
    }
}

