/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.StringJoiner;
import org.bukkit.plugin.Plugin;

public class DiscordChatChannelCommandFeedbackForwarder {
    private final GuildMessageReceivedEvent event;
    private StringJoiner messageBuffer = new StringJoiner("\n");
    private boolean bufferCollecting = false;

    public DiscordChatChannelCommandFeedbackForwarder(GuildMessageReceivedEvent event) {
        this.event = event;
        if (DiscordSRV.config().getInt("DiscordChatChannelConsoleCommandExpiration") > 0 && DiscordSRV.config().getBoolean("DiscordChatChannelConsoleCommandExpirationDeleteRequest")) {
            SchedulerUtil.runTaskLaterAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> event.getMessage().delete().queue(), (long)DiscordSRV.config().getInt("DiscordChatChannelConsoleCommandExpiration") * 20L);
        }
    }

    public void send(String message) {
        if (this.bufferCollecting) {
            if (DiscordUtil.escapeMarkdown(this.messageBuffer + "\n" + message).length() > 1998) {
                DiscordUtil.sendMessage(this.event.getChannel(), DiscordUtil.escapeMarkdown(this.messageBuffer.toString()), DiscordSRV.config().getInt("DiscordChatChannelConsoleCommandExpiration") * 1000);
                this.messageBuffer = new StringJoiner("\n");
                this.messageBuffer.add(message);
            } else {
                this.messageBuffer.add(message);
            }
        } else {
            this.bufferCollecting = true;
            this.messageBuffer.add(message);
            SchedulerUtil.runTaskLater((Plugin)DiscordSRV.getPlugin(), () -> {
                this.bufferCollecting = false;
                if (this.messageBuffer.length() == 0) {
                    return;
                }
                DiscordUtil.sendMessage(this.event.getChannel(), DiscordUtil.escapeMarkdown(this.messageBuffer.toString()), DiscordSRV.config().getInt("DiscordChatChannelConsoleCommandExpiration") * 1000);
                this.messageBuffer = new StringJoiner("\n");
            }, 3L);
        }
    }
}

