/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.DiscordGuildMessageSentEvent;
import github.scarsz.discordsrv.api.events.DiscordPrivateMessageSentEvent;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.MessageBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Activity;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ChannelType;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Emote;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Icon;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.update.GuildMemberUpdateNicknameEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.role.update.RoleUpdateNameEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.user.update.UserUpdateNameEvent;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.PermissionException;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.MessageAction;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.format.TextColor;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import java.awt.Color;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.jetbrains.annotations.ApiStatus;

public class DiscordUtil {
    private static final Pattern USER_MENTION_PATTERN = Pattern.compile("(<@!?([0-9]{16,20})>)");
    private static final Pattern CHANNEL_MENTION_PATTERN = Pattern.compile("(<#([0-9]{16,20})>)");
    private static final Pattern ROLE_MENTION_PATTERN = Pattern.compile("(<@&([0-9]{16,20})>)");
    private static final Pattern EMOTE_MENTION_PATTERN = Pattern.compile("(<a?:([a-zA-Z]{2,32}):[0-9]{16,20}>)");
    private static Map<String, Pattern> mentionPatternCache = new HashMap<String, Pattern>();
    private static final Pattern aggressiveStripPattern;
    @Deprecated
    public static final Color DISCORD_DEFAULT_COLOR;
    public static final int DISCORD_DEFAULT_COLOR_RGB = 10070709;

    public static JDA getJda() {
        return DiscordSRV.getPlugin().getJda();
    }

    public static String getRoleName(Role role) {
        return role == null ? "" : role.getName();
    }

    public static Role getTopRole(Member member) {
        return member.getRoles().size() != 0 ? member.getRoles().get(0) : null;
    }

    public static Role getTopRoleWithCustomColor(Member member) {
        for (Role role : member.getRoles()) {
            if (role.getColor() == null) continue;
            return role;
        }
        return null;
    }

    public static String convertMentionsToNames(String message) {
        Matcher userMatcher = USER_MENTION_PATTERN.matcher(message);
        while (userMatcher.find()) {
            String mention = userMatcher.group(1);
            String userId = userMatcher.group(2);
            User user = DiscordUtil.getUserById(userId);
            message = message.replace(mention, user != null ? "@" + user.getName() : mention);
        }
        Matcher channelMatcher = CHANNEL_MENTION_PATTERN.matcher(message);
        while (channelMatcher.find()) {
            String mention = channelMatcher.group(1);
            String channelId = channelMatcher.group(2);
            TextChannel channel = DiscordUtil.getTextChannelById(channelId);
            message = message.replace(mention, channel != null ? "#" + channel.getName() : mention);
        }
        Matcher roleMatcher = ROLE_MENTION_PATTERN.matcher(message);
        while (roleMatcher.find()) {
            String mention = roleMatcher.group(1);
            String roleId = roleMatcher.group(2);
            Role role = DiscordUtil.getRole(roleId);
            message = message.replace(mention, role != null ? "@" + role.getName() : mention);
        }
        Matcher emoteMatcher = EMOTE_MENTION_PATTERN.matcher(message);
        while (emoteMatcher.find()) {
            message = message.replace(emoteMatcher.group(1), ":" + emoteMatcher.group(2) + ":");
        }
        return message;
    }

    public static String convertMentionsFromNames(String message, Guild guild) {
        Pattern pattern;
        if (!message.contains("@")) {
            return message;
        }
        HashMap<Pattern, String> patterns = new HashMap<Pattern, String>();
        for (Role role : guild.getRoles()) {
            pattern = mentionPatternCache.computeIfAbsent(role.getId(), mentionable -> Pattern.compile("(?<!<)" + Pattern.quote("@" + role.getName()), 66));
            patterns.put(pattern, role.getAsMention());
        }
        for (Member member : guild.getMembers()) {
            pattern = mentionPatternCache.computeIfAbsent(member.getId(), mentionable -> Pattern.compile("(?<!<)" + Pattern.quote("@" + member.getEffectiveName()), 66));
            patterns.put(pattern, member.getAsMention());
        }
        for (Map.Entry entry : patterns.entrySet()) {
            message = ((Pattern)entry.getKey()).matcher(message).replaceAll((String)entry.getValue());
        }
        return message;
    }

    public static String escapeMarkdown(String text) {
        return text == null ? "" : text.replace("\\", "\\\\").replace("_", "\\_").replace("*", "\\*").replace("~", "\\~").replace("|", "\\|").replace(">", "\\>").replace("`", "\\`");
    }

    @Deprecated
    public static String strip(String text) {
        return MessageUtil.stripLegacy(text);
    }

    @Deprecated
    public static String stripSectionOnly(String text) {
        return MessageUtil.stripLegacySectionOnly(text);
    }

    public static String aggressiveStrip(String text) {
        if (StringUtils.isBlank(text)) {
            DiscordSRV.debug("Tried aggressively stripping blank message");
            return null;
        }
        return aggressiveStripPattern.matcher(text).replaceAll("");
    }

    @Deprecated
    public static void sendMessage(TextChannel channel, String message, int expiration, @Deprecated boolean editMessage) {
        DiscordUtil.sendMessage(channel, message, expiration);
    }

    public static void sendMessage(TextChannel channel, String message) {
        DiscordUtil.sendMessage(channel, message, 0);
    }

    public static void sendMessage(TextChannel channel, String message, int expiration) {
        if (channel == null) {
            DiscordSRV.debug("Tried sending a message to a null channel");
            return;
        }
        if (DiscordUtil.getJda() == null) {
            DiscordSRV.debug("Tried sending a message using a null JDA instance");
            return;
        }
        if (message == null) {
            DiscordSRV.debug("Tried sending a null message to " + channel);
            return;
        }
        if (StringUtils.isBlank(message)) {
            DiscordSRV.debug("Tried sending a blank message to " + channel);
            return;
        }
        message = MessageUtil.strip(message);
        String overflow = null;
        int maxLength = 2000;
        if (message.length() > maxLength) {
            DiscordSRV.debug("Tried sending message with length of " + message.length() + " (" + (message.length() - maxLength) + " over limit)");
            overflow = message.substring(maxLength);
            message = message.substring(0, maxLength);
        }
        DiscordUtil.queueMessage(channel, message, (Message m) -> {
            if (expiration > 0) {
                try {
                    Thread.sleep(expiration);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DiscordUtil.deleteMessage(m);
            }
        });
        if (overflow != null) {
            DiscordUtil.sendMessage(channel, overflow, expiration);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static String cutPhrases(String message) {
        return message;
    }

    public static boolean checkPermission(GuildChannel channel, Permission permission) {
        return DiscordUtil.checkPermission(channel, DiscordUtil.getJda().getSelfUser(), permission);
    }

    public static boolean checkPermission(Guild guild, Permission permission) {
        return guild != null && guild.getSelfMember().hasPermission(permission);
    }

    public static boolean checkPermission(GuildChannel channel, User user, Permission permission) {
        if (channel == null) {
            return false;
        }
        Member member = channel.getGuild().getMember(user);
        if (member == null) {
            return false;
        }
        return member.hasPermission(channel, permission);
    }

    public static Message sendMessageBlocking(TextChannel channel, String message) {
        return DiscordUtil.sendMessageBlocking(channel, message, false);
    }

    public static Message sendMessageBlocking(TextChannel channel, String message, boolean allowMassPing) {
        if (message == null || StringUtils.isBlank(message)) {
            DiscordSRV.debug("Tried sending a null or blank message");
            return null;
        }
        if (channel == null) {
            DiscordSRV.debug("Tried sending a message to a null channel");
            return null;
        }
        message = DiscordUtil.translateEmotes(message, channel.getGuild());
        return DiscordUtil.sendMessageBlocking(channel, new MessageBuilder().append(message).build(), allowMassPing);
    }

    public static Message sendMessageBlocking(TextChannel channel, Message message, boolean allowMassPing) {
        Message sentMessage;
        if (DiscordUtil.getJda() == null) {
            DiscordSRV.debug("Tried sending a message when JDA was null");
            return null;
        }
        if (channel == null) {
            DiscordSRV.debug("Tried sending a message to a null channel");
            return null;
        }
        if (message == null || StringUtils.isBlank(message.getContentRaw())) {
            DiscordSRV.debug("Tried sending a null or blank message");
            return null;
        }
        try {
            MessageAction action = channel.sendMessage(message);
            if (allowMassPing) {
                action = (MessageAction)action.allowedMentions(EnumSet.allOf(Message.MentionType.class));
            }
            sentMessage = (Message)action.complete();
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Could not send message in channel " + channel + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            } else {
                DiscordSRV.warning("Could not send message in channel " + channel + " because \"" + e.getMessage() + "\"");
            }
            return null;
        }
        DiscordSRV.api.callEvent(new DiscordGuildMessageSentEvent(DiscordUtil.getJda(), sentMessage));
        return sentMessage;
    }

    public static void queueMessage(TextChannel channel, String message) {
        if (channel == null) {
            DiscordSRV.debug("Tried sending a message to a null channel");
            return;
        }
        if (StringUtils.isBlank(message = DiscordUtil.translateEmotes(message, channel.getGuild()))) {
            return;
        }
        DiscordUtil.queueMessage(channel, new MessageBuilder().append(message).build(), false);
    }

    public static void queueMessage(TextChannel channel, String message, boolean allowMassPing) {
        if (channel == null) {
            DiscordSRV.debug("Tried sending a message to a null channel");
            return;
        }
        if (StringUtils.isBlank(message = DiscordUtil.translateEmotes(message, channel.getGuild()))) {
            return;
        }
        DiscordUtil.queueMessage(channel, new MessageBuilder().append(message).build(), allowMassPing);
    }

    public static void queueMessage(TextChannel channel, Message message) {
        DiscordUtil.queueMessage(channel, message, null);
    }

    public static void queueMessage(TextChannel channel, Message message, boolean allowMassPing) {
        DiscordUtil.queueMessage(channel, message, null, allowMassPing);
    }

    public static void queueMessage(TextChannel channel, String message, Consumer<Message> consumer) {
        if (StringUtils.isBlank(message = DiscordUtil.translateEmotes(message, channel.getGuild()))) {
            return;
        }
        DiscordUtil.queueMessage(channel, new MessageBuilder().append(message).build(), consumer);
    }

    public static void queueMessage(TextChannel channel, String message, Consumer<Message> consumer, boolean allowMassPing) {
        message = DiscordUtil.translateEmotes(message, channel.getGuild());
        DiscordUtil.queueMessage(channel, new MessageBuilder().append(message).build(), consumer, allowMassPing);
    }

    public static void queueMessage(TextChannel channel, Message message, Consumer<Message> consumer) {
        DiscordUtil.queueMessage(channel, message, consumer, false);
    }

    public static void queueMessage(TextChannel channel, Message message, Consumer<Message> consumer, boolean allowMassPing) {
        if (channel == null) {
            DiscordSRV.debug("Tried sending a message to a null channel");
            return;
        }
        try {
            MessageAction action = channel.sendMessage(message);
            if (allowMassPing) {
                action = (MessageAction)action.allowedMentions(EnumSet.allOf(Message.MentionType.class));
            }
            action.queue(sentMessage -> {
                DiscordSRV.api.callEvent(new DiscordGuildMessageSentEvent(DiscordUtil.getJda(), (Message)sentMessage));
                if (consumer != null) {
                    consumer.accept((Message)sentMessage);
                }
            }, throwable -> DiscordSRV.error("Failed to send message to channel " + channel + ": " + throwable.getMessage()));
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Could not send message in channel " + channel + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            } else {
                DiscordSRV.warning("Could not send message in channel " + channel + " because \"" + e.getMessage() + "\"");
            }
        }
        catch (IllegalStateException e) {
            DiscordSRV.error("Could not send message to channel " + channel + ": " + e.getMessage());
        }
    }

    public static void setTextChannelTopic(TextChannel channel, String topic) {
        if (channel == null) {
            DiscordSRV.debug("Attempted to set status of null channel");
            return;
        }
        try {
            channel.getManager().setTopic(topic).queue();
        }
        catch (Exception e) {
            if (e instanceof PermissionException) {
                PermissionException pe = (PermissionException)e;
                if (pe.getPermission() != Permission.UNKNOWN) {
                    DiscordSRV.warning("Could not set topic of channel " + channel + " because the bot does not have the \"" + pe.getPermission().getName() + "\" permission");
                }
            }
            DiscordSRV.warning("Could not set topic of channel " + channel + " because \"" + e.getMessage() + "\"");
        }
    }

    public static void setChannelName(GuildChannel channel, String name, boolean blockThread) {
        try {
            if (blockThread) {
                channel.getManager().setName(name).complete();
            } else {
                channel.getManager().setName(name).queue();
            }
        }
        catch (Exception e) {
            if (e instanceof PermissionException) {
                PermissionException pe = (PermissionException)e;
                if (pe.getPermission() != Permission.UNKNOWN) {
                    DiscordSRV.warning(String.format("Could not rename channel \"%s\" because the bot does not have the \"%s\" permission.", channel.getName(), pe.getPermission().getName()));
                } else {
                    DiscordSRV.warning(String.format("Received an unknown permission exception when trying to rename channel \"%s\".", channel.getName()));
                }
            }
            DiscordSRV.warning(String.format("Could not rename channel \"%s\" because \"%s\"", channel.getName(), e.getMessage()));
        }
    }

    public static void setGameStatus(String gameStatus) {
        if (DiscordUtil.getJda() == null) {
            DiscordSRV.debug("Attempted to set game status using null JDA");
            return;
        }
        if (StringUtils.isBlank(gameStatus)) {
            DiscordSRV.debug("Attempted setting game status to a null or empty string");
            return;
        }
        if (PluginUtil.pluginHookIsEnabled("placeholderapi")) {
            gameStatus = PlaceholderAPI.setPlaceholders(null, (String)gameStatus);
        }
        DiscordUtil.getJda().getPresence().setActivity(Activity.playing(gameStatus));
    }

    public static void deleteMessage(Message message) {
        if (message.isFromType(ChannelType.PRIVATE)) {
            return;
        }
        try {
            message.delete().queue();
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Could not delete message in channel " + message.getTextChannel() + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            }
            DiscordSRV.warning("Could not delete message in channel " + message.getTextChannel() + " because \"" + e.getMessage() + "\"");
        }
    }

    public static void privateMessage(User user, String message) {
        user.openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage(message).queue(sentMessage -> DiscordSRV.api.callEvent(new DiscordPrivateMessageSentEvent(DiscordUtil.getJda(), (Message)sentMessage))));
    }

    public static boolean memberHasRole(Member member, Set<String> rolesToCheck) {
        if (member == null) {
            return false;
        }
        if (rolesToCheck.contains("@everyone")) {
            return true;
        }
        Set rolesLowercase = rolesToCheck.stream().map(String::toLowerCase).collect(Collectors.toSet());
        return member.getRoles().stream().anyMatch(role -> rolesLowercase.contains(role.getName().toLowerCase()) || rolesLowercase.contains(role.getId()));
    }

    @Deprecated
    public static String convertRoleToMinecraftColor(Role role) {
        if (role == null) {
            DiscordSRV.debug("Attempted to look up color for null role");
            return "";
        }
        return MessageUtil.toLegacy(Component.empty().color(TextColor.color(role.getColorRaw())));
    }

    public static String getFormattedRoles(List<Role> roles) {
        return String.join((CharSequence)LangUtil.Message.CHAT_TO_MINECRAFT_ALL_ROLES_SEPARATOR.toString(), roles.stream().map(DiscordUtil::getRoleName).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
    }

    public static void setAvatar(File avatar) throws RuntimeException {
        try {
            DiscordUtil.getJda().getSelfUser().getManager().setAvatar(Icon.from(avatar)).queue();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void setAvatarBlocking(File avatar) throws RuntimeException {
        try {
            DiscordUtil.getJda().getSelfUser().getManager().setAvatar(Icon.from(avatar)).complete();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void modifyRolesOfMember(Member member, Set<Role> rolesToAdd, Set<Role> rolesToRemove) {
        rolesToAdd = rolesToAdd.stream().filter(role -> !role.isManaged()).filter(role -> !role.getGuild().getPublicRole().getId().equals(role.getId())).filter(role -> !member.getRoles().contains(role)).collect(Collectors.toSet());
        Set<Role> nonInteractableRolesToAdd = rolesToAdd.stream().filter(role -> !member.getGuild().getSelfMember().canInteract((Role)role)).collect(Collectors.toSet());
        rolesToAdd.removeAll(nonInteractableRolesToAdd);
        nonInteractableRolesToAdd.forEach(role -> DiscordSRV.warning("Failed to add role \"" + role.getName() + "\" to \"" + member.getEffectiveName() + "\" because the bot's highest role is lower than the target role and thus can't interact with it"));
        rolesToRemove = rolesToRemove.stream().filter(role -> !role.isManaged()).filter(role -> !role.getGuild().getPublicRole().getId().equals(role.getId())).filter(role -> member.getRoles().contains(role)).collect(Collectors.toSet());
        Set<Role> nonInteractableRolesToRemove = rolesToRemove.stream().filter(role -> !member.getGuild().getSelfMember().canInteract((Role)role)).collect(Collectors.toSet());
        rolesToRemove.removeAll(nonInteractableRolesToRemove);
        nonInteractableRolesToRemove.forEach(role -> DiscordSRV.warning("Failed to remove role \"" + role.getName() + "\" from \"" + member.getEffectiveName() + "\" because the bot's highest role is lower than the target role and thus can't interact with it"));
        member.getGuild().modifyMemberRoles(member, rolesToAdd, rolesToRemove).queue();
    }

    public static void addRoleToMember(Member member, Role role) {
        if (member == null) {
            DiscordSRV.debug("Can't add role to null member");
            return;
        }
        try {
            member.getGuild().addRoleToMember(member, role).queue();
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Could not add " + member + " to role " + role + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            }
            DiscordSRV.warning("Could not add " + member + " to role " + role + " because \"" + e.getMessage() + "\"");
        }
    }

    public static void addRolesToMember(Member member, Role ... roles) {
        if (member == null) {
            DiscordSRV.debug("Can't add roles to null member");
            return;
        }
        List<Role> rolesToAdd = Arrays.stream(roles).filter(role -> !role.isManaged()).filter(role -> !role.getGuild().getPublicRole().getId().equals(role.getId())).collect(Collectors.toList());
        try {
            member.getGuild().modifyMemberRoles(member, rolesToAdd, Collections.emptySet()).queue();
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Could not add " + member + " to role(s) " + rolesToAdd + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            }
            DiscordSRV.warning("Could not add " + member + " to role(s) " + rolesToAdd + " because \"" + e.getMessage() + "\"");
        }
    }

    public static void addRolesToMember(Member member, Set<Role> rolesToAdd) {
        DiscordUtil.addRolesToMember(member, rolesToAdd.toArray(new Role[0]));
    }

    public static void removeRolesFromMember(Member member, Role ... roles) {
        if (member == null) {
            DiscordSRV.debug("Can't remove roles from null member");
            return;
        }
        List<Role> rolesToRemove = Arrays.stream(roles).filter(role -> !role.isManaged()).filter(role -> !role.getGuild().getPublicRole().getId().equals(role.getId())).collect(Collectors.toList());
        try {
            member.getGuild().modifyMemberRoles(member, Collections.emptySet(), rolesToRemove).queue();
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Could not demote " + member + " from role(s) " + rolesToRemove + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            }
            DiscordSRV.warning("Could not demote " + member + " from role(s) " + rolesToRemove + " because \"" + e.getMessage() + "\"");
        }
    }

    public static void removeRolesFromMember(Member member, Set<Role> rolesToRemove) {
        DiscordUtil.removeRolesFromMember(member, rolesToRemove.toArray(new Role[0]));
    }

    public static void setNickname(Member member, String nickname) {
        if (member == null) {
            DiscordSRV.debug(Debug.NICKNAME_SYNC, "Can't set nickname of null member");
            return;
        }
        if (!member.getGuild().getSelfMember().canInteract(member)) {
            DiscordSRV.debug(Debug.NICKNAME_SYNC, "Not setting " + member + "'s nickname because we can't interact with them");
            return;
        }
        if (nickname != null && nickname.equals(member.getNickname())) {
            DiscordSRV.debug(Debug.NICKNAME_SYNC, "Not setting " + member + "'s nickname because it wouldn't change");
            return;
        }
        try {
            member.modifyNickname(nickname).queue();
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Could not set nickname for " + member + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            }
            DiscordSRV.warning("Could not set nickname for " + member + " because \"" + e.getMessage() + "\"");
        }
    }

    public static Role getRole(String roleId) {
        try {
            return DiscordUtil.getJda().getRoleById(roleId);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Role resolveRole(String resolvable) {
        return DiscordUtil.getJda().getRoles().stream().filter(role -> role.getName().equalsIgnoreCase(resolvable) || role.getId().equals(resolvable)).findFirst().orElse(null);
    }

    public static void banMember(Member member) {
        DiscordUtil.banMember(member, 0);
    }

    public static void banMember(Member member, int daysOfMessagesToDelete) {
        if (member == null) {
            DiscordSRV.debug("Attempted to ban null member");
            return;
        }
        daysOfMessagesToDelete = Math.abs(daysOfMessagesToDelete);
        try {
            member.ban(daysOfMessagesToDelete).queue();
        }
        catch (PermissionException e) {
            if (e.getPermission() != Permission.UNKNOWN) {
                DiscordSRV.warning("Failed to ban " + member + " because the bot does not have the \"" + e.getPermission().getName() + "\" permission");
            }
            DiscordSRV.warning("Failed to ban " + member + " because \"" + e.getMessage() + "\"");
        }
    }

    public static void unbanUser(Guild guild, User user) {
        try {
            guild.unban(user).queue(null, t -> DiscordSRV.error("Failed to unban user " + user + ": " + t.getMessage()));
        }
        catch (Exception e) {
            DiscordSRV.error("Failed to unban user " + user + ": " + e.getMessage());
        }
    }

    public static String translateEmotes(String messageToTranslate) {
        return DiscordUtil.translateEmotes(messageToTranslate, DiscordUtil.getJda().getEmotes());
    }

    public static String translateEmotes(String messageToTranslate, Guild guild) {
        return DiscordUtil.translateEmotes(messageToTranslate, guild.getEmotes());
    }

    public static String translateEmotes(String messageToTranslate, List<Emote> emotes) {
        for (Emote emote : emotes) {
            messageToTranslate = messageToTranslate.replace(":" + emote.getName() + ":", emote.getAsMention());
        }
        return messageToTranslate;
    }

    public static TextChannel getTextChannelById(String channelId) {
        try {
            return DiscordUtil.getJda().getTextChannelById(channelId);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Member getMemberById(String memberId) {
        try {
            return DiscordUtil.getJda().getGuilds().stream().filter(guild -> guild.getMemberById(memberId) != null).findFirst().map(guild -> guild.getMemberById(memberId)).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static User getUserById(String userId) {
        try {
            return DiscordUtil.getJda().retrieveUserById(userId).complete();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static {
        if (DiscordUtil.getJda() != null) {
            DiscordUtil.getJda().addEventListener(new ListenerAdapter(){

                @Override
                public void onUserUpdateName(UserUpdateNameEvent event) {
                    mentionPatternCache.remove(event.getUser().getId());
                }

                @Override
                public void onGuildMemberUpdateNickname(GuildMemberUpdateNicknameEvent event) {
                    mentionPatternCache.remove(event.getMember().getId());
                }

                @Override
                public void onRoleUpdateName(RoleUpdateNameEvent event) {
                    mentionPatternCache.remove(event.getRole().getId());
                }
            });
        }
        aggressiveStripPattern = Pattern.compile("\u001b\\[[\\d;]*m");
        Color color = null;
        try {
            color = new Color(153, 170, 181, 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DISCORD_DEFAULT_COLOR = color;
    }
}

