/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.kevinsawicki.http.HttpRequest;
import github.scarsz.discordsrv.util.LangUtil;
import java.io.File;
import java.util.concurrent.TimeUnit;

public abstract class HttpUtil {
    private static HttpRequest setTimeout(HttpRequest httpRequest) {
        return httpRequest.connectTimeout(Math.toIntExact(TimeUnit.SECONDS.toMillis(30L))).readTimeout(Math.toIntExact(TimeUnit.SECONDS.toMillis(30L)));
    }

    public static String requestHttp(String requestUrl) {
        try {
            return HttpUtil.setTimeout(HttpRequest.get(requestUrl)).body();
        }
        catch (HttpRequest.HttpRequestException e) {
            DiscordSRV.error((Object)((Object)LangUtil.InternalMessage.HTTP_FAILED_TO_FETCH_URL) + " " + requestUrl + ": " + e.getMessage());
            return "";
        }
    }

    public static void downloadFile(String requestUrl, File destination) {
        try {
            HttpUtil.setTimeout(HttpRequest.get(requestUrl)).receive(destination);
        }
        catch (HttpRequest.HttpRequestException e) {
            DiscordSRV.error((Object)((Object)LangUtil.InternalMessage.HTTP_FAILED_TO_DOWNLOAD_URL) + " " + requestUrl + ": " + e.getMessage());
        }
    }

    public static boolean exists(String url) {
        try {
            HttpRequest request = HttpUtil.setTimeout(HttpRequest.head(url));
            return request.code() / 100 == 2;
        }
        catch (Exception e) {
            return false;
        }
    }
}

