/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.configuralize.Language;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.util.MessageUtil;
import java.util.HashMap;
import java.util.Map;

public class LangUtil {

    public static enum Message {
        ACCOUNT_ALREADY_LINKED("MinecraftAccountAlreadyLinked", true),
        ALREADY_LINKED("DiscordAccountAlreadyLinked", false),
        BAN_DISCORD_TO_MINECRAFT("BanSynchronizationDiscordToMinecraftReason", true),
        CHAT_CHANNEL_COMMAND_ERROR("DiscordChatChannelConsoleCommandNotifyErrorsFormat", false),
        CHAT_CHANNEL_MESSAGE("ChatChannelHookMessageFormat", true),
        CHAT_CHANNEL_TOPIC("ChannelTopicUpdaterChatChannelTopicFormat", false),
        CHAT_CHANNEL_TOPIC_AT_SERVER_SHUTDOWN("ChannelTopicUpdaterChatChannelTopicAtServerShutdownFormat", false),
        CHAT_TO_DISCORD("MinecraftChatToDiscordMessageFormat", false),
        CHAT_TO_DISCORD_NO_PRIMARY_GROUP("MinecraftChatToDiscordMessageFormatNoPrimaryGroup", false),
        CHAT_TO_MINECRAFT("DiscordToMinecraftChatMessageFormat", true),
        CHAT_TO_MINECRAFT_ALL_ROLES_SEPARATOR("DiscordToMinecraftAllRolesSeparator", true),
        CHAT_TO_MINECRAFT_NO_ROLE("DiscordToMinecraftChatMessageFormatNoRole", true),
        CHAT_TO_MINECRAFT_REPLY("DiscordToMinecraftMessageReplyFormat", true),
        CODE_GENERATED("CodeGenerated", false),
        CLICK_TO_COPY_CODE("ClickToCopyCode", false),
        COMMAND_DOESNT_EXIST("UnknownCommandMessage", true),
        CONSOLE_CHANNEL_PREFIX("DiscordConsoleChannelPrefix", false),
        CONSOLE_CHANNEL_SUFFIX("DiscordConsoleChannelSuffix", false),
        CONSOLE_CHANNEL_TOPIC("ChannelTopicUpdaterConsoleChannelTopicFormat", false),
        CONSOLE_CHANNEL_TOPIC_AT_SERVER_SHUTDOWN("ChannelTopicUpdaterConsoleChannelTopicAtServerShutdownFormat", false),
        DISCORD_ACCOUNT_LINKED("DiscordAccountLinked", false),
        DISCORD_COMMAND("DiscordCommandFormat", true),
        DYNMAP_CHAT_FORMAT("DynmapChatFormat", true),
        DYNMAP_DISCORD_FORMAT("DynmapDiscordFormat", false),
        DYNMAP_NAME_FORMAT("DynmapNameFormat", true),
        FAILED_TO_CHECK_LINKED_ACCOUNT("DiscordLinkedAccountCheckFailed", false),
        INVALID_CODE("InvalidCode", false),
        LINKED_SUCCESS("LinkedCommandSuccess", true),
        LINKED_ACCOUNT_REQUIRED("DiscordLinkedAccountRequired", false),
        LINKED_NOBODY_FOUND("MinecraftNobodyFound", true),
        LINK_FAIL_NOT_ASSOCIATED_WITH_AN_ACCOUNT("MinecraftNoLinkedAccount", true),
        MINECRAFT_ACCOUNT_LINKED("MinecraftAccountLinked", true),
        NO_PERMISSION("NoPermissionMessage", true),
        PLAYER_LIST_COMMAND("DiscordChatChannelListCommandFormatOnlinePlayers", false),
        PLAYER_LIST_COMMAND_NO_PLAYERS("DiscordChatChannelListCommandFormatNoOnlinePlayers", false),
        PLAYER_LIST_COMMAND_PLAYER("DiscordChatChannelListCommandPlayerFormat", true),
        PLAYER_LIST_COMMAND_ALL_PLAYERS_SEPARATOR("DiscordChatChannelListCommandAllPlayersSeparator", false),
        SERVER_SHUTDOWN_MESSAGE("DiscordChatChannelServerShutdownMessage", false),
        SERVER_STARTUP_MESSAGE("DiscordChatChannelServerStartupMessage", false),
        SERVER_WATCHDOG("ServerWatchdogMessage", false),
        UNABLE_TO_LINK_ACCOUNTS_RIGHT_NOW("LinkingError", true),
        UNKNOWN_CODE("UnknownCode", false),
        UNLINK_SUCCESS("UnlinkCommandSuccess", true);

        private final String keyName;
        private final boolean translateColors;

        private Message(String keyName, boolean translateColors) {
            this.keyName = keyName;
            this.translateColors = translateColors;
        }

        public String toString() {
            return this.toString(this.translateColors);
        }

        public String toString(boolean translateColors) {
            String message = DiscordSRV.config().getString(this.keyName);
            return translateColors ? MessageUtil.translateLegacy(message) : message;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public boolean isTranslateColors() {
            return this.translateColors;
        }
    }

    public static enum InternalMessage {
        ASM_WARNING((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "\n\nYou're attempting to use DiscordSRV on ASM 4. DiscordSRV requires ASM 5 to function.\nDiscordSRV WILL NOT WORK without ASM 5. Blame your server software's developers for having outdated libraries.\n\nInstructions for updating to ASM 5:\n1. Navigate to the {specialsourcefolder} folder of the server\n2. Delete the SpecialSource-1.7-SNAPSHOT.jar jar file\n3. Download SpecialSource v1.7.4 from https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Copy the jar file to the {specialsourcefolder} folder of the server you navigated to earlier\n5. Rename the jar file you just copied to SpecialSource-1.7-SNAPSHOT.jar\n6. Restart the server\n\n\n");
                this.put(Language.FR, "\n\nVous essayez d'utiliser Discord SRV sur ASM 4. DiscordSRV a besoin de ASM 5 pour fonctionner.\nDiscordSRV ne fonctionne pas sans ASM 5. Vos librairies ne sont pas \u00e0 jour.\n\nInstructions pour mettre \u00e0 jour ASM 5:\n1. Allez sur le dossier {specialsourcefolder} du serveur\n2. Supprimez le fichier SpecialSource-1.7-SNAPSHOT.jar\n3. T\u00e9l\u00e9chargez le fichier v1.7.4 depuis https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Copiez le fichier jar dans le dossier {specialsourcefolder} \n5. Renommez le fichier de la fa\u00e7on suivante SpecialSource-1.7-SNAPSHOT.jar\n6. Red\u00e9marrez le serveur\n\n\n");
                this.put(Language.DE, "\n\nDu versuchst DiscordSRV mit ASM 4 zu nuten. DiscordSRV ben\u00f6tigt ASM 5, um zu funktionieren.\nDiscordSRV wird ohne ASM5 NICHT funktionieren. Beschuldige die Entwickler deiner Serversoftware daf\u00fcr, veraltete Bibliotheken zu nutzen.\n\nAnleitung zum Nutzen von ASM 5:\n1. Navigiere zum Ordner {specialsourcefolder} deines Servers\n2. L\u00f6sche die Datei SpecialSource-1.7-SNAPSHOT.jar\n3. Lade dir die Datei SpecialSource v1.7.4 von hier herunter: https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Kopiere die jar Datei in den zuvor ausgew\u00e4hlten Ordner {specialsourcefolder}\n5. Bennen die kopierte jar Datei in SpecialSource-1.7-SNAPSHOT.jar um\n6. Starte deinen Server neu\n\n\n");
                this.put(Language.JA, "\n\n\u3042\u306a\u305f\u306f\u3001DiscordSRV \u3092 ASM 4 \u3067\u4f7f\u7528\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002DiscordSRV \u3092\u4f7f\u7528\u3059\u308b\u306b\u306f\u3001ASM 5 \u304c\u5fc5\u8981\u3067\u3059\u3002\nDiscordSRV \u306f ASM 5 \u3067\u306a\u3044\u3068\u6b63\u3057\u304f\u52d5\u4f5c\u3057\u307e\u305b\u3093\u3002\u30b5\u30fc\u30d0\u30fc\u30bd\u30d5\u30c8\u30a6\u30a8\u30a2\u958b\u767a\u8005\u306b\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u53e4\u304f\u306a\u3063\u3066\u3044\u308b\u3053\u3068\u3092\u6559\u3048\u3066\u3042\u3052\u3066\u304f\u3060\u3055\u3044\u3002\n\nASM 5 \u3078\u306e\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u624b\u9806\uff1a\n1. \u30b5\u30fc\u30d0\u30fc\u306e {specialsourcefolder} \u30d5\u30a9\u30eb\u30c0\u30fc\u306b\u79fb\u52d5\u3057\u307e\u3059\u3002\n2. SpecialSource-1.7-SNAPSHOT.jar \u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3059\u3002\n3. SpecialSource v1.7.4 \u3092\u3001\u6b21\u306eURL\u304b\u3089\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3059\u3002https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. \u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u305fjar\u30d5\u30a1\u30a4\u30eb\u3092\u3001{specialsourcefolder} \u30d5\u30a9\u30eb\u30c0\u30fc\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002\n5. \u30b3\u30d4\u30fc\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u3001SpecialSource-1.7-SNAPSHOT.jar \u306b\u30ea\u30cd\u30fc\u30e0\u3057\u307e\u3059\u3002\n6. \u30b5\u30fc\u30d0\u30fc\u3092\u8d77\u52d5\u3057\u307e\u3059\u3002\n\n\n");
                this.put(Language.KO, "\n\nDiscordSRV\ub97c ASM 4\uc5d0\uc11c \uad6c\ub3d9 \uc911 \uc785\ub2c8\ub2e4.. DiscordSRV\ub294 ASM 5 \uc774\uc0c1 \ubc84\uc804\uc5d0\uc11c \uc791\ub3d9\ud569\ub2c8\ub2e4.\nDiscordSRV\ub294 ASM 5\uc5c6\uc774\ub294 \uc791\ub3d9 \ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uad6c\uc2dd \ub77c\uc774\ube0c\ub7ec\ub9ac\ub97c \uc368\uc11c \ub9cc\ub4e0 \uc11c\ubc84 \uc18c\ud504\ud2b8\uc6e8\uc5b4 \uac1c\ubc1c\uc790 \ud55c\ud14c \ub530\uc9c0\uc138\uc694.\n\nASM 5\ub85c \uc5c5\ub370\uc774\ud2b8 \ud558\ub294 \ubc29\ubc95:\n1. \uc11c\ubc84\uc758 {specialsourcefolder} \ud3f4\ub354\ub85c \ub4e4\uc5b4\uac11\ub2c8\ub2e4.\n2. SpecialSource-1.7-SNAPSHOT.jar \ud30c\uc77c\uc744 \uc0ad\uc81c \ud569\ub2c8\ub2e4.\n3. SpecialSource v1.7.4\ub97c https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar \uc5d0\uc11c \ub2e4\uc6b4\ub85c\ub4dc \ubc1b\uc2b5\ub2c8\ub2e4.\n4. {specialsourcefolder}\ub85c 3\uc5d0\uc11c \ub2e4\uc6b4\ub85c\ub4dc \ubc1b\uc740 \ud30c\uc77c\uc744 \ubcf5\uc0ac\ud569\ub2c8\ub2e4.\n5. 4\uc5d0\uc11c \ubcf5\uc0ac\ud55c \ud30c\uc77c\uc758 \uc774\ub984\uc744 SpecialSource-1.7-SNAPSHOT.jar\ub85c \ubc14\uafc9\ub2c8\ub2e4.\n6. \uc11c\ubc84\ub97c \uc7ac\ubd80\ud305 \ud569\ub2c8\ub2e4.\n\n\n");
                this.put(Language.NL, "\n\nJe probeerd DiscordSRV te gebruiken op ASM 4. DiscordSRV heeft ASM 5 nodig om te functioneren.\nDiscordSRV WERKT NIET zonder ASM 5. Geef je server software's developers de schuld maar voor het hebben van outdated libraries.\n\nInstructies voor het updaten naar ASM 5:\n1. Ga naar de {specialsourcefolder} folder van je server.\n2. Verwijder de SpecialSource-1.7-SNAPSHOT.jar jar file.\n3. Download SpecialSource v1.7.4 vanaf https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Kopieer de jar file naar de {specialsourcefolder} folder van je server waar je mee bezig bent.\n5. Verander de naam van de jar file die je hebt gekopieerd naar SpecialSource-1.7-SNAPSHOT.jar\n6. Herstart je server.\n\n\n");
                this.put(Language.ES, "\n\nEst\u00e1s intentando usar DiscordSRV en ASM 4. DiscordSRV necesita ASM 5 para funcionar.\nDiscordSRV NO FUNCIONAR\u00c1 sin ASM 5. Informe al desarrollador del software del servidor de que la biblioteca no est\u00e1 actualizada.\n\nInstrucciones para actualizar a ASM 5:\n1. Navegue a la carpeta {specialsourcefolder} de tu servidor\n2. Elimine el archivo jar de SpecialSource-1.7-SNAPSHOT.jar\n3. Descargue SpecialSource v1.7.4 desde https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Copie el archivo jar en la carpeta {specialsourcefolder} del servidor al que navegaste anteriormente\n5. Renombre el archivo jar que acaba de copiar a: SpecialSource-1.7-SNAPSHOT.jar\n6. Reinicie el servidor\n\n\n");
                this.put(Language.RU, "\n\n\u0412\u044b \u043f\u044b\u0442\u0430\u0435\u0442\u0435\u0441\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c DiscordSRV \u043d\u0430 ASM 4. DiscordSRV \u0442\u0440\u0435\u0431\u0443\u0435\u0442 ASM 5 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b.\nDiscordSRV \u041d\u0415 \u0411\u0423\u0414\u0415\u0422 \u0420\u0410\u0411\u041e\u0422\u0410\u0422\u042c \u0431\u0435\u0437 ASM 5. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c \u0432\u0430\u0448\u0435\u0439 \u0438\u0433\u0440\u043e\u0432\u043e\u0439 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438.\n\n\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043e ASM 5:\n1. \u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 {specialsourcefolder} \u043d\u0430 \u0432\u0430\u0448\u0435\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435\n2. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 SpecialSource-1.7-SNAPSHOT.jar \u0444\u0430\u0439\u043b\n3. \u0421\u043a\u0430\u0447\u0430\u0439\u0442\u0435 SpecialSource v1.7.4.jar \u043e\u0442\u0441\u044e\u0434\u0430 https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. \u0421\u043a\u043e\u043f\u0438\u0440\u0443\u0439\u0442\u0435 jar \u0444\u0430\u0439\u043b \u0432 \u043f\u0430\u043f\u043a\u0443 {specialsourcefolder} \u0432\u0430\u0448\u0435\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u044b \u043e\u0442\u043a\u0440\u044b\u043b\u0438 \u0440\u0430\u043d\u0435\u0435\n5. \u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u0443\u0439\u0442\u0435 jar \u0444\u0430\u0439\u043b, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u044b \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043b\u0438 \u0432 SpecialSource-1.7-SNAPSHOT.jar\n6. \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\n\n\n");
                this.put(Language.ET, "\n\nSa proovid DiscordSRV'i kasutada ASM 4 peal. DiscordSRV n\u00f5uab t\u00f6\u00f6tamiseks ASM 5-te.\nDiscordSRV EI T\u00d6\u00d6TA ilma ASM 5-ta. S\u00fc\u00fcdista oma serveritarkvara arendajaid vananenud teekide kasutamise eest.\n\nJuhised ASM 5-le t\u00e4iendamiseks:\n1. Mine serveris kausta {specialsourcefolder}\n2. Kustuta fail SpecialSource-1.7-SNAPSHOT.jar\n3. Laadi SpecialSource v1.7.4 alla saidilt https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Kopeeri saadud jar-fail eelnevalt avatud kausta {specialsourcefolder}\n5. Nimeta just kopeeritud jar-fail \u00fcmber nimeks SpecialSource-1.7-SNAPSHOT.jar\n6. Taask\u00e4ivita server\n\n\n");
                this.put(Language.ZH, "\n\n\u60a8\u5617\u8a66\u4f7f\u7528ASM 4\u4f86\u555f\u52d5DiscordSRV\u3002 DiscordSRV\u9700\u8981ASM 5\u4f86\u555f\u52d5\u3002\nDiscordSRV\u7121\u6cd5\u5728\u7f3a\u5c11ASM 5\u7684\u60c5\u6cc1\u4e0b\u555f\u52d5\u3002 \u8acb\u8aee\u8a62\u60a8\u7684\u4f3a\u670d\u5668\u8edf\u9ad4\u958b\u767c\u4eba\u54e1\u95dc\u65bc\u820a\u7248\u51fd\u5f0f\u5eab\u3002\n\nASM 5 \u5347\u7d1a\u6307\u5357:\n1. \u958b\u555f\u4f3a\u670d\u5668\u4e2d\u7684 {specialsourcefolder} \u8cc7\u6599\u593e\n2. \u522a\u9664jar\u6a94 SpecialSource-1.7-SNAPSHOT.jar \n3. \u4e0b\u8f09 SpecialSource v1.7.4 \u5f9e https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. \u8907\u88fd\u8a72jar\u6a94\u81f3\u5148\u524d\u5728\u4f3a\u670d\u5668\u4e2d\u958b\u555f\u7684 {specialsourcefolder} \u8cc7\u6599\u593e\n5. \u4e26\u5c07\u6a94\u6848\u91cd\u65b0\u547d\u540d\u70ba SpecialSource-1.7-SNAPSHOT.jar\n6. \u91cd\u555f\u4f3a\u670d\u5668\n\n\n");
                this.put(Language.PL, "\n\nPr\u00f3bujesz u\u017cy\u0107 DiscordSRV na ASM 4. DiscordSRV wymaga ASM 5 do dzia\u0142ania.\nDiscordSRV NIE B\u0118DZIE DZIA\u0141A\u0141 bez ASM 5. wincie tw\u00f3rc\u00f3w oprogramowania serwera za posiadanie nieaktualnych bibliotek.\n\nInstrukcje dotycz\u0105ce aktualizacji do ASM 5:\n1. Przejd\u017a do {specialsourcefolder} folder serwera\n2. Usu\u0144 SpecialSource-1.7-SNAPSHOT.jar plik jar\n3. Pobierz SpecialSource v1.7.4 z https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Skopiuj plik jar do {specialsourcefolder} folderu serwera, do kt\u00f3rego nawigowa\u0142e\u015b wcze\u015bniej\n5. Zmie\u0144 nazw\u0119 w\u0142a\u015bnie skopiowanego pliku jar na SpecialSource-1.7-SNAPSHOT.jar\n6. Zrestartuj serwer\n\n\n");
                this.put(Language.DA, "\n\nDu pr\u00f8ver at bruge DiscordSRV p\u00e5 ASM 4. DiscordSRV kr\u00e6ver ASM 5 for at fungere.\nDiscordSRV VIL IKKE VIRKE uden ASM 5. Skyd skylden p\u00e5 din servers software udviklere for at have uddaterede biblioteketer.\n\nInstruktionen til at opdatere til ASM 5:\n1. Naviger til {specialsourcefolder} folder i serveren\n2. Slet SpcialSource-1.7-SNAPSHOT.jar jar filen\n3. Download SpecialSource v1.7.4 fra https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Kopier jar filen til {specialsourcefolder} folderen som n\u00e6vnt tidligere.\n5. Omd\u00f8b jar filen du lige kopierede til SpecialSource-1.7-SNAPSHOT.jar\n6. Genstart serveren\n\n\n");
                this.put(Language.UK, "\n\n\u0412\u0438 \u043d\u0430\u043c\u0430\u0433\u0430\u0454\u0442\u0435\u0441\u044c \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0432\u0430\u0442\u0438 DiscordSRV \u043d\u0430 ASM 4. DiscordSRV \u0432\u0438\u043c\u0430\u0433\u0430\u0454 ASM 5 \u0434\u043b\u044f \u0440\u043e\u0431\u043e\u0442\u0438.\nDiscordSRV \u043d\u0435 \u043f\u0440\u0430\u0446\u044e\u0432\u0430\u0442\u0438\u043c\u0435 \u0431\u0435\u0437 ASM 5. \u0417\u0432\u0435\u0440\u043d\u0456\u0442\u044c\u0441\u044f \u0434\u043e \u0440\u043e\u0437\u0440\u043e\u0431\u043d\u0438\u043a\u0456\u0432 \u0432\u0430\u0448\u043e\u0457 \u0456\u0433\u0440\u043e\u0432\u043e\u0457 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0438, \u0449\u043e\u0431 \u043e\u0442\u0440\u0438\u043c\u0430\u0442\u0438 \u043d\u0435\u043e\u0431\u0445\u0456\u0434\u043d\u0456 \u0431\u0456\u0431\u043b\u0456\u043e\u0442\u0435\u043a\u0438.\n\n\u0406\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457 \u0434\u043b\u044f \u043e\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f \u0434\u043e ASM 5:\n1. \u0417\u043d\u0430\u0439\u0434\u0456\u0442\u044c \u043f\u0430\u043f\u043a\u0443 {special source folder} \u043d\u0430 \u0432\u0430\u0448\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0456\n2. \u0412\u0438\u0434\u0430\u043b\u0456\u0442\u044c SpecialSource-1.7-SNAPSHOT.JAR \u0444\u0430\u0439\u043b\n3. \u0421\u043a\u0430\u0447\u0430\u0439\u0442\u0435 Special Source v1.7. 4.jar \u0437\u0432\u0456\u0434\u0441\u0438 https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. \u0421\u043a\u043e\u043f\u0456\u044e\u0439\u0442\u0435 jar \u0444\u0430\u0439\u043b \u0432 \u043f\u0430\u043f\u043a\u0443 {specialsourcefolder} \u0432\u0430\u0448\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u044f\u043a\u0443 \u0432\u0438 \u0432\u0456\u0434\u043a\u0440\u0438\u043b\u0438 \u0440\u0430\u043d\u0456\u0448\u0435\n5. \u041f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u0443\u0439\u0442\u0435 jar \u0444\u0430\u0439\u043b, \u044f\u043a\u0438\u0439 \u0432\u0438 \u0441\u043a\u043e\u043f\u0456\u044e\u0432\u0430\u043b\u0438 \u0432 SpecialSource-1.7-SNAPSHOT.jar\n6. \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0456\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440\n\n\n");
                this.put(Language.NB, "\n\nDu fors\u00f8ker \u00e5 bruke DiscordSRV med ASM 4. DiscordSRV krever ASM 5 for \u00e5 fungere.\nDiscordSRV VIL IKKE FUNGERE uten ASM 5. Skyld p\u00e5 serverens programvareutvikler for \u00e5 bruke utdaterte biblioteker\n\nVeiledning for oppdatering til ASM 5:\n1. Naviger til {specialsourcefolder}-mappen p\u00e5 serveren\n2. Slett jar-filen SpecialSource-1.7-SNAPSHOT.jar\n3. Last ned SpecialSource versjon 1.7.4 fra https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. Kopier jar-filen til {specialsourcefolder}-mappen p\u00e5 serveren du var p\u00e5\n5. Omkall jar-filen du kopierte til SpecialSource-1.7-SNAPSHOT.jar\n6. Restart the server\n\n\n");
            }
        }),
        RESPECT_CHAT_PLUGINS_DISABLED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "\n\nRespectChatPlugins is disabled, this option is for TESTING PURPOSES ONLY\nand should NEVER be disabled on production servers.\nDisabling the option will cause cancelled messages to be forwarded to Discord\nincluding but not limited to private messages or staff chat messages without /commands\n\n\n");
                this.put(Language.FR, "\n\nRespectChatPlugins est d\u00e9sactiv\u00e9, cette option est UNIQUEMENT \u00c0 DES FINS DE TEST\net ne doit JAMAIS \u00eatre d\u00e9sactiv\u00e9 sur les serveurs de production.\nLa d\u00e9sactivation de cette option entra\u00eenera le transfert des messages annul\u00e9s vers Discord\ny compris, mais sans s'y limiter, les messages priv\u00e9s ou les messages de discussion du personnel sans commandes\n\n\n");
                this.put(Language.DE, "\n\nRespectChatPlugins ist deaktiviert. Diese Option dient nur zum Testen von Zwecken\nund sollte NIEMALS auf Produktionsservern deaktiviert werden.\nDurch Deaktivieren der Option werden abgebrochene Nachrichten an Discord weitergeleitet\neinschlie\u00dflich, aber nicht beschr\u00e4nkt auf private Nachrichten oder Chat-Nachrichten von Mitarbeitern ohne / Befehle\n\n\n");
                this.put(Language.JA, "\n\nRespectChatPlugins\u306f\u7121\u52b9\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002\u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3001\u76ee\u7684\u3092\u30c6\u30b9\u30c8\u3059\u308b\u305f\u3081\u3060\u3051\u306e\u3082\u306e\u3067\u3059\n\u5b9f\u7a3c\u50cd\u30b5\u30fc\u30d0\u30fc\u3067\u306f\u7121\u52b9\u306b\u3057\u306a\u3044\u3067\u304f\u3060\u3055\u3044\u3002\n\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u7121\u52b9\u306b\u3059\u308b\u3068\u3001\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u305f\u30e1\u30c3\u30bb\u30fc\u30b8\u304cDiscord\u306b\u8ee2\u9001\u3055\u308c\u307e\u3059\n/commands\u3092\u4f7f\u7528\u3057\u306a\u3044\u30d7\u30e9\u30a4\u30d9\u30fc\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u307e\u305f\u306f\u30b9\u30bf\u30c3\u30d5\u30c1\u30e3\u30c3\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u542b\u307e\u308c\u307e\u3059\u304c\u3001\u3053\u308c\u3089\u306b\u9650\u5b9a\u3055\u308c\u307e\u305b\u3093\n\n\n");
                this.put(Language.KO, "\n\nRespectChatPlugins\uac00 \ube44\ud65c\uc131\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\uc774 \uc635\uc158\uc740 \ud14c\uc2a4\ud2b8 \ubaa9\uc801\uc73c\ub85c \ub9cc \uc0ac\uc6a9\ub429\ub2c8\ub2e4.\n\ud504\ub85c\ub355\uc158 \uc11c\ubc84\uc5d0\uc11c\ub294 \uc808\ub300 \ube44\ud65c\uc131\ud654\ud558\uc9c0 \uc54a\uc544\uc57c\ud569\ub2c8\ub2e4.\n\uc774 \uc635\uc158\uc744 \ube44\ud65c\uc131\ud654\ud558\uba74 \ucde8\uc18c \ub41c \uba54\uc2dc\uc9c0\uac00 \ubd88\uc77c\uce58\ub85c \uc804\ub2ec\ub429\ub2c8\ub2e4.\n/command\uac00\uc5c6\ub294 \uac1c\uc778 \uba54\uc2dc\uc9c0 \ub610\ub294 \uc9c1\uc6d0 \ucc44\ud305 \uba54\uc2dc\uc9c0\ub97c \ud3ec\ud568\ud558\uc9c0\ub9cc \uc774\uc5d0 \uad6d\ud55c\ub418\uc9c0\ub294 \uc54a\uc2b5\ub2c8\ub2e4.\n\n\n");
                this.put(Language.NL, "\n\nRespectChatPlugins is uitgeschakeld, deze optie is ALLEEN voor TESTEN VAN DOELEINDEN\nen mag NOOIT worden uitgeschakeld op productieservers.\nAls u deze optie uitschakelt, worden geannuleerde berichten doorgestuurd naar Discord\ninclusief maar niet beperkt tot priv\u00e9berichten of chatberichten van personeel zonder / commando's\n\n\n");
                this.put(Language.ES, "\n\nRespectChatPlugins est\u00e1 deshabilitado, esta opci\u00f3n es SOLO PARA PROP\u00d3SITOS\ny NUNCA debe deshabilitarse en los servidores de producci\u00f3n.\nDeshabilitar la opci\u00f3n har\u00e1 que los mensajes cancelados se reenv\u00eden a Discord\nincluidos, entre otros, mensajes privados o mensajes de chat del personal sin / comandos\n\n\n");
                this.put(Language.RU, "\n\nRespectChatPlugins \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d, \u044d\u0442\u0430 \u043e\u043f\u0446\u0438\u044f \u0422\u041e\u041b\u042c\u041a\u041e \u0414\u041b\u042f \u0422\u0415\u0421\u0422\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u042f\n\u0438 \u043d\u0438\u043a\u043e\u0433\u0434\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430\u0445.\n\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u044d\u0442\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u0442 \u043a \u0442\u043e\u043c\u0443, \u0447\u0442\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0431\u0443\u0434\u0443\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b \u0432 Discord\n\u0432\u043a\u043b\u044e\u0447\u0430\u044f, \u043d\u043e \u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0432\u0430\u044f\u0441\u044c, \u043b\u0438\u0447\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0438\u043b\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0447\u0430\u0442\u0430 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u0430 \u0431\u0435\u0437 / \u043a\u043e\u043c\u0430\u043d\u0434\n\n\n");
                this.put(Language.ET, "\n\nRespectChatPlugins on keelatud, see suvand on ette n\u00e4htud AINULT EESM\u00c4RKIDE TESTIMISEKS\nja seda ei tohiks KUNAGI tootmisserverites keelata.\nSelle valiku keelamisel edastatakse t\u00fchistatud kirjad Discordile\nsealhulgas, kuid mitte ainult, privaats\u00f5numid v\u00f5i personali vestluss\u00f5numid ilma / k\u00e4skudeta\n\n\n");
                this.put(Language.ZH, "\n\nRespectChatPlugins\u5df2\u7981\u7528\uff0c\u6b64\u9078\u9805\u50c5\u7528\u65bc\u6e2c\u8a66\u76ee\u7684\n\u4e26\u4e14\u6c38\u9060\u4e0d\u8981\u5728\u751f\u7522\u4f3a\u670d\u5668\u4e0a\u7981\u7528\u5b83\u3002\n\u7981\u7528\u8a72\u9078\u9805\u5c07\u5c0e\u81f4\u53d6\u6d88\u7684\u90f5\u4ef6\u8f49\u767c\u5230Discord\n\u5305\u62ec\u4f46\u4e0d\u9650\u65bc\u4e0d\u5e36/ command\u7684\u79c1\u4eba\u6d88\u606f\u6216\u54e1\u5de5\u804a\u5929\u6d88\u606f\n\n\n");
                this.put(Language.PL, "\n\nRespectChatPlugins jest wy\u0142\u0105czone, ta opcja s\u0142u\u017cy TYLKO DO CEL\u00d3W TESTOWYCH\ni NIGDY nie powinno by\u0107 wy\u0142\u0105czane na serwerach produkcyjnych.\nWy\u0142\u0105czenie tej opcji spowoduje, \u017ce anulowane wiadomo\u015bci b\u0119d\u0105 przekazywane do Discord\nw tym mi\u0119dzy innymi prywatne wiadomo\u015bci lub wiadomo\u015bci na czacie graczy bez /komend\n\n\n");
                this.put(Language.DA, "\n\nRespectChatPlugins er deaktiveret, denne mulighed er KUN til TESTFORM\u00c5L\nog b\u00f8r ALDRIG deaktiveres p\u00e5 produktionsservere.\nHvis du deaktiverer indstillingen, vil annullerede beskeder blive videresendt til Discord\ninklusive men ikke begr\u00e6nset til private beskeder eller personalechatbeskeder uden /kommandoer\n\n\n");
                this.put(Language.UK, "\n\n\u0412\u0438 \u043d\u0430\u043c\u0430\u0433\u0430\u0454\u0442\u0435\u0441\u044c \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0432\u0430\u0442\u0438 DiscordSRV \u043d\u0430 ASM 4. DiscordSRV \u0432\u0438\u043c\u0430\u0433\u0430\u0454 ASM 5 \u0434\u043b\u044f \u0440\u043e\u0431\u043e\u0442\u0438.\nDiscordSRV \u043d\u0435 \u043f\u0440\u0430\u0446\u044e\u0432\u0430\u0442\u0438\u043c\u0435 \u0431\u0435\u0437 ASM 5. \u0417\u0432\u0435\u0440\u043d\u0456\u0442\u044c\u0441\u044f \u0434\u043e \u0440\u043e\u0437\u0440\u043e\u0431\u043d\u0438\u043a\u0456\u0432 \u0432\u0430\u0448\u043e\u0457 \u0456\u0433\u0440\u043e\u0432\u043e\u0457 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0438, \u0449\u043e\u0431 \u043e\u0442\u0440\u0438\u043c\u0430\u0442\u0438 \u043d\u0435\u043e\u0431\u0445\u0456\u0434\u043d\u0456 \u0431\u0456\u0431\u043b\u0456\u043e\u0442\u0435\u043a\u0438.\n\n\u0406\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457 \u0449\u043e\u0434\u043e \u043e\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f \u0434\u043e ASM 5:\n1. \u0417\u043d\u0430\u0439\u0434\u0456\u0442\u044c \u043f\u0430\u043f\u043a\u0443 {special source folder} \u043d\u0430 \u0432\u0430\u0448\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0456\n2. Respect Chat Plugins \u0432\u0438\u043c\u043a\u043d\u0435\u043d\u043e, \u0446\u044f \u043e\u043f\u0446\u0456\u044f \u043b\u0438\u0448\u0435 \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0443\u0432\u0430\u043d\u043d\u044f\n3. \u0421\u043a\u0430\u0447\u0430\u0439\u0442\u0435 Special Source v1.7. 4.jar \u0437\u0432\u0456\u0434\u0441\u0438 https://repo1.maven.org/maven2/net/md-5/SpecialSource/1.7.4/SpecialSource-1.7.4.jar\n4. \u0421\u043a\u043e\u043f\u0456\u044e\u0439\u0442\u0435 jar \u0444\u0430\u0439\u043b \u0432 \u043f\u0430\u043f\u043a\u0443 {special source folder} \u0432\u0430\u0448\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u044f\u043a\u0443 \u0432\u0438 \u0432\u0456\u0434\u043a\u0440\u0438\u043b\u0438 \u0440\u0430\u043d\u0456\u0448\u0435\n5. \u041f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u0443\u0439\u0442\u0435 jar \u0444\u0430\u0439\u043b, \u044f\u043a\u0438\u0439 \u0432\u0438 \u0441\u043a\u043e\u043f\u0456\u044e\u0432\u0430\u043b\u0438 \u0432 SpecialSource-1.7-SNAPSHOT.jar\n6. \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0456\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440\n\n\n");
                this.put(Language.NB, "\n\nRespectChatPlugins er deaktivert, dette alternativet er BARE FOR TESTBRUK\nog skal ALDRI bli deaktivert p\u00e5 produksjonsservere.\nDeaktiveing av dette alternativet vil for\u00e5rsake at kansellerte meldinger vil bli sendt til Discord\ninkludert, men ikke begrenset til private meldinger eller chat-meldinger fra serverpersonell uten /kommandoer\n\n\n");
            }
        }),
        INCOMPATIBLE_CLIENT((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Your user experience is degraded due to using {client}, some commands may not work as expected.");
                this.put(Language.FR, "Votre exp\u00e9rience utilisateur est d\u00e9grad\u00e9e en raison de l'utilisation de {client}, certaines commandes peuvent ne pas fonctionner comme pr\u00e9vu.");
                this.put(Language.DE, "Ihre Benutzererfahrung ist durch die Verwendung von {client} beeintr\u00e4chtigt. Einige Befehle funktionieren m\u00f6glicherweise nicht wie erwartet.");
                this.put(Language.JA, "{client}\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30e6\u30fc\u30b6\u30fc\u30a8\u30af\u30b9\u30da\u30ea\u30a8\u30f3\u30b9\u304c\u4f4e\u4e0b\u3057\u3001\u4e00\u90e8\u306e\u30b3\u30de\u30f3\u30c9\u304c\u671f\u5f85\u3069\u304a\u308a\u306b\u6a5f\u80fd\u3057\u306a\u3044\u5834\u5408\u304c\u3042\u308a\u307e\u3059\u3002 ");
                this.put(Language.KO, "{client} \uc0ac\uc6a9\uc73c\ub85c \uc778\ud574 \uc0ac\uc6a9\uc790 \uacbd\ud5d8\uc774 \uc800\ud558\ub418\uace0 \uc77c\ubd80 \uba85\ub839\uc774 \uc608\uc0c1\ub300\ub85c \uc791\ub3d9\ud558\uc9c0 \uc54a\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Uw gebruikerservaring is verslechterd door het gebruik van {client}. Sommige opdrachten werken mogelijk niet zoals verwacht.");
                this.put(Language.ES, "Su experiencia de usuario se degrada debido al uso de {cliente}, es posible que algunos comandos no funcionen como se esperaba.");
                this.put(Language.RU, "\u0412\u0430\u0448\u0435 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \u0443\u0445\u0443\u0434\u0448\u0430\u0435\u0442\u0441\u044f \u0438\u0437-\u0437\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f {client}, \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435 \u0442\u0430\u043a, \u043a\u0430\u043a \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c.");
                this.put(Language.ET, "Teie kasutuskogemus on {client} kasutamise t\u00f5ttu halvenenud, m\u00f5ned k\u00e4sud ei pruugi ootusp\u00e4raselt t\u00f6\u00f6tada.");
                this.put(Language.ZH, "\u60a8\u7684\u7528\u6236\u9ad4\u9a57\u56e0\u4f7f\u7528 {client} \u800c\u4e0b\u964d\uff0c\u67d0\u4e9b\u547d\u4ee4\u53ef\u80fd\u7121\u6cd5\u6309\u9810\u671f\u5de5\u4f5c\u3002");
                this.put(Language.PL, "Twoje do\u015bwiadczenie u\u017cytkownika jest pogorszone z powodu korzystania z {client}, niekt\u00f3re polecenia mog\u0105 nie dzia\u0142a\u0107 zgodnie z oczekiwaniami.");
                this.put(Language.DA, "Din brugeroplevelse er nedgraderet grundet din brug af {client}, nogle kommandoer ville ikke virke som forventet.");
                this.put(Language.UK, "\u0412\u0430\u0448\u0430 \u0432\u0437\u0430\u0454\u043c\u043e\u0434\u0456\u044f \u0437 \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0435\u043c \u043f\u043e\u0433\u0456\u0440\u0448\u0443\u0454\u0442\u044c\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f {client}, \u0434\u0435\u044f\u043a\u0456 \u043a\u043e\u043c\u0430\u043d\u0434\u0438 \u043c\u043e\u0436\u0443\u0442\u044c \u043f\u0440\u0430\u0446\u044e\u0432\u0430\u0442\u0438 \u043d\u0435 \u0442\u0430\u043a, \u044f\u043a \u043e\u0447\u0456\u043a\u0443\u0432\u0430\u043b\u043e\u0441\u044f.");
                this.put(Language.NB, "Brukeropplevelsen din er degradert grunnet bruk av {client}. Noen kommandoer vil kanskje ikke virke som forventet.");
            }
        }),
        CONSOLE_FORWARDING_ASSIGNED_TO_CHANNEL((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Console forwarding assigned to channel");
                this.put(Language.FR, "R\u00e9acheminement de la console affect\u00e9 au canal");
                this.put(Language.DE, "Konsolenausgabeweiterleitung aktiv");
                this.put(Language.JA, "\u30b3\u30f3\u30bd\u30fc\u30eb\u30d5\u30a9\u30ef\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30c1\u30e3\u30f3\u30cd\u30eb\u306b\u5272\u308a\u5f53\u3066\u3089\u308c\u307e\u3057\u305f");
                this.put(Language.KO, "\ucf58\uc194\ud3ec\uc6cc\ub529\uc774 \ucc44\ub110\uc5d0 \uc124\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4");
                this.put(Language.NL, "Console versturen verbonden aan kanaal");
                this.put(Language.ES, "Enviar la consola al canal asignado");
                this.put(Language.RU, "\u0412\u044b\u0432\u043e\u0434 \u043a\u043e\u043d\u0441\u043e\u043b\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u0432 \u043a\u0430\u043d\u0430\u043b");
                this.put(Language.ET, "Konsooliedastus on kanalile m\u00e4\u00e4ratud");
                this.put(Language.ZH, "\u63a7\u5236\u53f0\u8f49\u9001\u5df2\u6307\u6d3e\u81f3\u983b\u9053");
                this.put(Language.PL, "Przekazywanie konsoli przypisane do kana\u0142u");
                this.put(Language.DA, "Konsol videresendelse tildelt til kanal");
                this.put(Language.UK, "\u0412\u0438\u0445\u0456\u0434 \u043a\u043e\u043d\u0441\u043e\u043b\u0456 \u0443\u0441\u043f\u0456\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439 \u043d\u0430 \u043a\u0430\u043d\u0430\u043b");
                this.put(Language.NB, "Konsollsending er bundet til kanal");
            }
        }),
        NOT_FORWARDING_CONSOLE_OUTPUT((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Console channel ID was invalid, not forwarding console output");
                this.put(Language.FR, "L'ID du channel de la console est faux, l'envoie des messages de la console ne sera pas effectu\u00e9");
                this.put(Language.DE, "Konsolenkanal-ID ist ung\u00fcltig, keine Konsolenausgabe Weiterleitung aktiv");
                this.put(Language.JA, "\u30b3\u30f3\u30bd\u30fc\u30eb\u30c1\u30e3\u30cd\u30ebID\u306f\u7121\u52b9\u3067\u3042\u308b\u305f\u3081\u3001\u30b3\u30f3\u30bd\u30fc\u30eb\u8ee2\u9001\u306f\u884c\u308f\u308c\u307e\u305b\u3093");
                this.put(Language.KO, "\ucf58\uc194 \ucc44\ub110 ID\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ucf58\uc194 \uba54\uc138\uc9c0\ub97c \ucc44\ub110\ub85c \ubcf4\ub0b4\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Console kanaal ID is ongeldig, de console wordt niet verzonden");
                this.put(Language.ES, "El ID del canal de la consola no es v\u00e1lido, no se enviar\u00e1 ning\u00fan mensaje de la consola");
                this.put(Language.RU, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 ID \u043a\u0430\u043d\u0430\u043b\u0430 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u0432\u043e\u0434\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u0438, \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0441\u043e\u043b\u0438 \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u043f\u0435\u0440\u0435\u0441\u044b\u043b\u0430\u0442\u044c\u0441\u044f");
                this.put(Language.ET, "Konsoolikanali ID oli sobimatu, konsooli v\u00e4ljundit ei edastata");
                this.put(Language.ZH, "\u932f\u8aa4\u7684\u63a7\u5236\u53f0\u983b\u9053ID, \u4e26\u672a\u8f49\u9001\u63a7\u5236\u53f0\u8f38\u51fa\u3002");
                this.put(Language.PL, "Identyfikator kana\u0142u konsoli by\u0142 nieprawid\u0142owy, nie przekazuje danych wyj\u015bciowych konsoli");
                this.put(Language.DA, "Konsol kanal ID var invalidt, videresender ikke konsole beskeder");
                this.put(Language.UK, "\u043d\u0435\u0432\u0456\u0440\u043d\u0438\u0439 ID \u043a\u0430\u043d\u0430\u043b\u0443 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f \u0432\u0438\u0432\u043e\u0434\u0443 \u043a\u043e\u043d\u0441\u043e\u043b\u0456, \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f \u043a\u043e\u043d\u0441\u043e\u043b\u0456 \u043d\u0435 \u0431\u0443\u0434\u0443\u0442\u044c \u043f\u0435\u0440\u0435\u0441\u0438\u043b\u0430\u0442\u0438\u0441\u044f");
                this.put(Language.NB, "Konsollkanalens ID er ugyldig, sender ikke konsollutdata");
            }
        }),
        SHUTDOWN_COMPLETED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Shutdown completed in {ms}ms");
                this.put(Language.FR, "Arr\u00eat effectu\u00e9 en {ms}ms");
                this.put(Language.DE, "Herunterfahren wurde abgeschlossen in {ms}ms");
                this.put(Language.JA, "{ms}\u30df\u30ea\u79d2\u3067\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "\uc11c\ubc84\uac00 {ms}ms\ub9cc\uc5d0 \uc885\ub8cc \ub428.");
                this.put(Language.NL, "Shutdown klaar in {ms}ms");
                this.put(Language.ES, "Apagado completado en {ms}ms");
                this.put(Language.RU, "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0437\u0430 {ms}\u043c\u0441");
                this.put(Language.ET, "V\u00e4ljal\u00fclitus teostatud {ms}ms jooksul");
                this.put(Language.ZH, "\u4f3a\u670d\u5668\u5df2\u95dc\u9589\uff0c\u8017\u6642{ms}ms");
                this.put(Language.PL, "Wy\u0142\u0105czenie zostanie zako\u0144czone za {ms}ms");
                this.put(Language.DA, "Nedlukning gennemf\u00f8rt p\u00e5 {ms}ms");
                this.put(Language.UK, "\u0432\u0456\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0437\u0430 {ms}\u043c\u0441");
                this.put(Language.NB, "Avslutning fullf\u00f8rt p\u00e5 {ms}ms");
            }
        }),
        API_LISTENER_SUBSCRIBED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "API listener {listenername} subscribed ({methodcount} methods)");
                this.put(Language.FR, "API listener {listenername} associ\u00e9 \u00e0 ({methodcount} methods)");
                this.put(Language.DE, "API listener {listenername} Anmeldung ({methodcount} Methoden)");
                this.put(Language.JA, "API listener {listenername} \u304c\u8cfc\u8aad\u3092\u958b\u59cb\u3057\u307e\u3057\u305f (\u30e1\u30bd\u30c3\u30c9\u6570: {methodcount} )");
                this.put(Language.KO, "API listener {listenername} \uac00 \uad6c\ub3c5\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4. (Method \uc218: {methodcount})");
                this.put(Language.NL, "API listener {listenername} aangemeld ({methodcount} methods)");
                this.put(Language.ES, "API listener {listenername} suscrito a ({methodcount} m\u00e9todos)");
                this.put(Language.RU, "API listener {listenername} \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d \u043d\u0430 ({methodcount} \u043c\u0435\u0442\u043e\u0434\u044b)");
                this.put(Language.ET, "API listener {listenername} on kuulamas ({methodcount} meetodit)");
                this.put(Language.ZH, "API listener {listenername} \u5df2\u8a02\u95b1 ({methodcount} \u7a2e\u65b9\u6848)");
                this.put(Language.PL, "Odbiornik API {listenername} zasubskrybowano ({methodcount} metod\u0105)");
                this.put(Language.DA, "API listener {listenername} abonneret ({methodcount} metoder)");
                this.put(Language.UK, "API listener {listenername} \u043f\u0456\u0434\u043f\u0438\u0441\u0430\u043d\u043e \u043d\u0430 ({methodcount} \u043c\u0435\u0442\u043e\u0434\u0438)");
                this.put(Language.NB, "API-lytter {listenername} abonnerte p\u00e5 ({methodcount} m\u00e5ter)");
            }
        }),
        API_LISTENER_UNSUBSCRIBED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "API listener {listenername} unsubscribed");
                this.put(Language.FR, "API listener {listenername} n'est plus associ\u00e9");
                this.put(Language.DE, "API listener {listenername} Abmeldung");
                this.put(Language.JA, "API listener {listenername} \u304c\u8cfc\u8aad\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "API listener {listenername} \uc758 \uad6c\ub3c5\uc774 \ucde8\uc18c \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "API listener {listenername} afgemeld");
                this.put(Language.ES, "API listener {listenername} anulado");
                this.put(Language.RU, "API listener {listenername} \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d");
                this.put(Language.ET, "API listener {listenername} kuulamine l\u00f5petatud");
                this.put(Language.ZH, "API listener {listenername} \u5df2\u53d6\u6d88\u8a02\u95b1");
                this.put(Language.PL, "Odbiornik API {listenername} odbubskrybowano");
                this.put(Language.DA, "API listener {listenername} afmeldt abonnement");
                this.put(Language.UK, "API listener {listenername} \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u043e\u0432\u0430\u043d\u043e");
                this.put(Language.NB, "API-lytter {listenername} avmeldte");
            }
        }),
        API_LISTENER_METHOD_NOT_ACCESSIBLE((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "DiscordSRV API Listener {listenername} method {methodname} was inaccessible despite efforts to make it accessible");
                this.put(Language.FR, "DiscordSRV API Listener {listenername} m\u00e9thode {methodname} est inaccessible malgr\u00e9 les efforts pour la rendre accessible");
                this.put(Language.DE, "DiscordSRV API Listener {listenername} Methode {methodname} war unzug\u00e4nglich trotz der Bem\u00fchungen, es zug\u00e4nglich zu machen");
                this.put(Language.JA, "DiscordSRV API Listener {listenername} \u306e Method {methodname} \u306f\u3001\u30a2\u30af\u30bb\u30b9\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u306a\u304f\u306a\u308a\u307e\u3057\u305f");
                this.put(Language.KO, "DiscordSRV API Listener {listenername} \uc758 method {methodname} \uc758 \uc561\uc138\uc2a4\uc5d0 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "DiscordSRV API Listener {listenername} methode {methodname} was onberijkbaar ondanks alle moeite om het berijkbaar te maken");
                this.put(Language.ES, "DiscordSRV API Listener {listenername} m\u00e9todo {methodname} era inaccesible a pesar de los esfuerzos para hacerlo accesible");
                this.put(Language.RU, "DiscordSRV API Listener {listenername} \u043c\u0435\u0442\u043e\u0434 {methodname} \u0431\u044b\u043b \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d, \u043d\u0435\u0441\u043c\u043e\u0442\u0440\u044f \u043d\u0430 \u0432\u0441\u0435 \u043d\u0430\u0448\u0438 \u0443\u0441\u0438\u043b\u0438\u044f \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0435\u0433\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u043c");
                this.put(Language.ET, "DiscordSRV API Listener {listenername} meetod {methodname} polnud ligip\u00e4\u00e4setav, kuigi prooviti ligip\u00e4\u00e4setavaks teha");
                this.put(Language.ZH, "DiscordSRV API Listener {listenername} \u65b9\u6848 {methodname} \u7121\u6cd5\u5b58\u53d6");
                this.put(Language.PL, "Odbiornik DiscordSRV API {listenername} metod\u0105 {methodname} by\u0142 niedost\u0119pny pomimo stara\u0144, aby by\u0142 dost\u0119pny");
                this.put(Language.DA, "DiscordSRV API Listener {listenername} metode {methodname} var utilg\u00e6ngelig p\u00e5 trods af indsats til at g\u00f8re den tilg\u00e6ngelig");
                this.put(Language.UK, "DiscordSRV API Listener {listenername} \u043c\u0435\u0442\u043e\u0434 {methodname} \u0431\u0443\u0432 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0438\u0439, \u043d\u0435\u0437\u0432\u0430\u0436\u0430\u044e\u0447\u0438 \u043d\u0430 \u0432\u0441\u0456 \u043d\u0430\u0448\u0456 \u0437\u0443\u0441\u0438\u043b\u043b\u044f, \u0449\u043e\u0431 \u0437\u0440\u043e\u0431\u0438\u0442\u0438 \u0439\u043e\u0433\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0438\u043c");
                this.put(Language.NB, "DiscordSRVs API-lytter {listenername} metode {methodname} var utilgjengelig til tross for fors\u00f8k p\u00e5 \u00e5 gj\u00f8re det tilgjengelig");
            }
        }),
        HTTP_FAILED_TO_FETCH_URL((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Failed to fetch URL");
                this.put(Language.FR, "Impossible de r\u00e9cuperer l'URL");
                this.put(Language.DE, "Fehler beim Abrufen der URL");
                this.put(Language.JA, "URL\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "URL\uc744 \uac00\uc838\uc624\ub294\ub370 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Gefaald om de URL op te halen");
                this.put(Language.ES, "Fallo al buscar la URL");
                this.put(Language.RU, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f URL");
                this.put(Language.ET, "URLi hankimine eba\u00f5nnestus");
                this.put(Language.ZH, "\u7121\u6cd5\u53d6\u5f97URL");
                this.put(Language.PL, "Nie uda\u0142o si\u0119 pobra\u0107 adresu URL");
                this.put(Language.DA, "Kunne ikke hente URL");
                this.put(Language.UK, "\u043f\u043e\u043c\u0438\u043b\u043a\u0430 \u043e\u0442\u0440\u0438\u043c\u0430\u043d\u043d\u044f URL");
                this.put(Language.NB, "Kunne ikke hente URL");
            }
        }),
        HTTP_FAILED_TO_DOWNLOAD_URL((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Failed to download URL");
                this.put(Language.FR, "Impossible de t\u00e9l\u00e9charger l'URL");
                this.put(Language.DE, "Fehler beim Download von URL");
                this.put(Language.JA, "URL\u304b\u3089\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "URL \ub2e4\uc6b4\ub85c\ub4dc\uc5d0 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Gefaald om de URL te downloaden");
                this.put(Language.ES, "Fallo al descargar la URL");
                this.put(Language.RU, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 URL");
                this.put(Language.ET, "URLi allalaadimine eba\u00f5nnestus");
                this.put(Language.ZH, "\u81eaURL\u4e0b\u8f09\u5931\u6557");
                this.put(Language.PL, "Nie uda\u0142o si\u0119 pobra\u0107 adresu URL");
                this.put(Language.DA, "Kunne ikke downloade URL");
                this.put(Language.UK, "\u041f\u043e\u043c\u0438\u043b\u043a\u0430 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f URL");
                this.put(Language.NB, "Kunne ikke laste ned URL");
            }
        }),
        PLUGIN_HOOK_ENABLING((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Enabling {plugin} hook");
                this.put(Language.FR, "Activation de l'accrochage du plugin {plugin}");
                this.put(Language.DE, "Aktiviere {plugin} Verbindung");
                this.put(Language.JA, "{plugin} \u306e\u63a5\u7d9a\u3092\u6709\u52b9\u306b\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "Plugin {plugin} \uc758 \uc5f0\ub3d9\uc744 \ud65c\uc131\ud654\ud569\ub2c8\ub2e4.");
                this.put(Language.NL, "Inschakelen {plugin} hook");
                this.put(Language.ES, "Activando complementos de {plugin}");
                this.put(Language.RU, "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f {plugin} \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
                this.put(Language.ET, "{plugin} haakimine lubatud");
                this.put(Language.ZH, "\u555f\u7528\u9264\u53d6 {plugin}");
                this.put(Language.PL, "W\u0142\u0105czono {plugin} haczyk");
                this.put(Language.DA, "Aktivere {plugin} hook");
                this.put(Language.UK, "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0456\u044f {plugin} \u043f\u0456\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044f");
                this.put(Language.NB, "Aktiverer {plugin}-tilkopling");
            }
        }),
        NO_CHAT_PLUGIN_HOOKED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "No chat plugin hooks enabled");
                this.put(Language.FR, "Aucun accrochage de plugin activ\u00e9");
                this.put(Language.DE, "Keine Pluginverbindungen aktiviert");
                this.put(Language.JA, "\u30c1\u30e3\u30c3\u30c8\u30d7\u30e9\u30b0\u30a4\u30f3\u3078\u306e\u63a5\u7d9a\u306f\u4e00\u3064\u3082\u3042\u308a\u307e\u305b\u3093");
                this.put(Language.KO, "\ud65c\uc131\ud654\ub41c \ucc44\ud305 \ud50c\ub7ec\uadf8\uc778 \uc5f0\ub3d9 \uc5c6\uc74c");
                this.put(Language.NL, "Geen chat plugin hooks ingeschakeld");
                this.put(Language.ES, "Sin complementos");
                this.put(Language.RU, "\u041f\u043b\u0430\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u0433\u0440\u043e\u0432\u044b\u043c \u0447\u0430\u0442\u043e\u043c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e");
                this.put(Language.ET, "\u00dchegi vestlusplugina haakimine pole lubatud");
                this.put(Language.ZH, "\u672a\u555f\u7528\u9264\u53d6\u4efb\u4f55\u804a\u5929\u63d2\u4ef6");
                this.put(Language.PL, "\u017badna wtyczka czatu nie jest w\u0142\u0105czona");
                this.put(Language.DA, "Ingen chat plugin hooks aktiveret");
                this.put(Language.UK, "\u043f\u043b\u0430\u0433\u0456\u043d\u0456\u0432 \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0456\u043d\u043d\u044f \u0456\u0433\u0440\u043e\u0432\u0438\u043c \u0447\u0430\u0442\u043e\u043c \u043d\u0435 \u0432\u0438\u044f\u0432\u043b\u0435\u043d\u043e");
                this.put(Language.NB, "Ingen chatutvidelsestilkoplinger er aktivert");
            }
        }),
        CHAT_CANCELLATION_DETECTOR_ENABLED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Chat event cancellation detector has been enabled");
                this.put(Language.FR, "D\u00e9tecteur d'annulation d'\u00e9v\u00e9nement de chat vient d'\u00eatre activ\u00e9");
                this.put(Language.DE, "Chatevent-Abbruch-Detektor wurde aktiviert");
                this.put(Language.JA, "\u30c1\u30e3\u30c3\u30c8\u30a4\u30d9\u30f3\u30c8\u30ad\u30e3\u30f3\u30bb\u30eb\u691c\u51fa\u6a5f\u80fd\u304c\u6709\u52b9\u306b\u306a\u3063\u3066\u3044\u307e\u3059");
                this.put(Language.KO, "\ucc44\ud305 \ucde8\uc18c \uac10\uc9c0\uae30\uac00 \uad6c\ub3d9\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Chat gebeurtenis annulering");
                this.put(Language.ES, "El detector de cancelaci\u00f3n de eventos de chat ha sido activado");
                this.put(Language.RU, "\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u0434\u0435\u0442\u0435\u043a\u0442\u043e\u0440 \u043e\u0442\u043c\u0435\u043d\u044b \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0447\u0430\u0442\u0430");
                this.put(Language.ET, "Vestluss\u00fcndmuste t\u00fchistamise tuvastaja on lubatud");
                this.put(Language.ZH, "\u804a\u5929\u4e8b\u4ef6\u64a4\u92b7\u6aa2\u6e2c\u5668\u5df2\u555f\u52d5");
                this.put(Language.PL, "Wykrywacz anulowania zdarze\u0144 czatu zosta\u0142 w\u0142\u0105czony");
                this.put(Language.DA, "Detektor for annullering af events er blevet aktiveret");
                this.put(Language.UK, "\u0443\u0432\u0456\u043c\u043a\u043d\u0435\u043d\u043e \u0434\u0435\u0442\u0435\u043a\u0442\u043e\u0440 \u0441\u043a\u0430\u0441\u0443\u0432\u0430\u043d\u043d\u044f \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u044c \u0447\u0430\u0442\u0443");
                this.put(Language.NB, "Chat-hendelseskanselleringsdetektor har blitt aktivert");
            }
        }),
        BOT_NOT_IN_ANY_SERVERS((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "The bot is not a part of any Discord servers. Follow the installation instructions");
                this.put(Language.FR, "Le bot ne fait partie d'aucun serveur. Suivez les instructions d'installation");
                this.put(Language.DE, "Der Bot ist nicht Bestandteil irgendwelcher Discordserver. Folge den Installationsanweisungen");
                this.put(Language.JA, "\u3053\u306eBot\u306f\u3069\u306eDiscord\u30b5\u30fc\u30d0\u30fc\u306b\u3082\u6240\u5c5e\u3057\u3066\u3044\u307e\u305b\u3093\u3002\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u624b\u9806\u306b\u5f93\u3063\u3066\u304f\u3060\u3055\u3044");
                this.put(Language.KO, "\uc5f0\ub3d9\ub41c \uc11c\ubc84\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uc124\uce58 \ubc29\ubc95\uc744 \ub530\ub77c \uc8fc\uc138\uc694.");
                this.put(Language.NL, "De bot maakt geen deel uit van een Discord server. Volg de instalatie instructies.");
                this.put(Language.ES, "El bot no es parte de ning\u00fan servidor de Discord. Siga las instrucciones de instalaci\u00f3n");
                this.put(Language.RU, "\u042d\u0442\u043e\u0442 \u0411\u043e\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0430\u0441\u0442\u044c\u044e \u043a\u0430\u043a\u043e\u0433\u043e-\u043b\u0438\u0431\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 Discord. \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0435\u0433\u043e \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443, \u0441\u043b\u0435\u0434\u0443\u044f \u0438\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f\u043c \u043f\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435");
                this.put(Language.ET, "See bot ei ole \u00fchegi Discordi serveri osa. J\u00e4rgi paigaldusjuhiseid");
                this.put(Language.ZH, "\u9019\u500bBOT\u4e26\u4e0d\u5c6c\u65bcDiscord\u4f3a\u670d\u5668\u3002 \u8acb\u53c3\u7167\u5b89\u88dd\u6307\u5357\u3002");
                this.put(Language.PL, "Bot nie jest cz\u0119\u015bci\u0105 \u017cadnego serwera Discord. Post\u0119puj zgodnie z instrukcjami instalacji");
                this.put(Language.DA, "Botten er ikke en del af nogle Discord servere. F\u00f8lg installations manualen");
                this.put(Language.UK, "\u0446\u0435\u0439 \u0411\u043e\u0442 \u043d\u0435 \u0454 \u0447\u0430\u0441\u0442\u0438\u043d\u043e\u044e \u0436\u043e\u0434\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 Discord. \u041f\u0456\u0434\u043a\u043b\u044e\u0447\u0456\u0442\u044c \u0439\u043e\u0433\u043e \u0434\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0434\u043e\u0442\u0440\u0438\u043c\u0443\u044e\u0447\u0438\u0441\u044c \u0456\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0439 \u0437 \u0432\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f");
                this.put(Language.NB, "Boten er ikke med i noen Discord-servere. F\u00f8lg installasjonsinstruksjonene");
            }
        }),
        CONSOLE_CHANNEL_ASSIGNED_TO_LINKED_CHANNEL((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "The console channel was assigned to a channel that's being used for chat. Did you blindly copy/paste an ID into the channel ID config option?");
                this.put(Language.FR, "Le channel de la console \u00e0 \u00e9t\u00e9 assign\u00e9 \u00e0 un channel utilis\u00e9 pour le tchat. Avez vous copi\u00e9 aveuglement l'ID d'un channel");
                this.put(Language.DE, "Der Konsolenkanal wurde mit einem Kanal verbunden, der auch f\u00fcr den Chat genutzt werden soll. Bitte korrigiere das und folge den Installationsanweisungen!");
                this.put(Language.JA, "\u30b3\u30f3\u30bd\u30fc\u30eb\u30c1\u30e3\u30f3\u30cd\u30eb\u306f\u3001\u30c1\u30e3\u30c3\u30c8\u306b\u4f7f\u7528\u3055\u308c\u3066\u3044\u308b\u30c1\u30e3\u30f3\u30cd\u30eb\u3068\u540c\u3058\u3082\u306e\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002ID\u3092\u30c1\u30e3\u30f3\u30cd\u30ebID\u8a2d\u5b9a\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u305d\u306e\u307e\u307e\u30b3\u30d4\u30da\u3057\u3066\u3044\u307e\u305b\u3093\u304b\uff1f");
                this.put(Language.KO, "\ucc44\ud305 \ucc44\ub110 ID\uac00 \ucf58\uc194 \ucc44\ub110 ID\uc640 \uac19\uc2b5\ub2c8\ub2e4. \uc815\uc2e0 \ucc28\ub9ac\uc138\uc694.");
                this.put(Language.NL, "Het console kanaal is gelinked met een kanaal dat voor chat gebruikt. Heb je het channel ID gekopieerd?? ;P");
                this.put(Language.ES, "El canal de la consola se asign\u00f3 a un canal que se est\u00e1 utilizando para el chat. \u00bfCopi\u00f3/peg\u00f3 a ciegas el ID en la opci\u00f3n de configuraci\u00f3n de identificaci\u00f3n del canal?");
                this.put(Language.RU, "\u041a\u0430\u043d\u0430\u043b \u0434\u043b\u044f \u043a\u043e\u043d\u0441\u043e\u043b\u0438 \u0431\u044b\u043b \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d \u043a \u043a\u0430\u043d\u0430\u043b\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u043e\u0433\u043e \u0447\u0430\u0442\u0430! \u0421\u043b\u0435\u043f\u043e\u0439 \u043a\u043e\u043f\u0438\u043f\u0430\u0441\u0442 ID \u043a\u0430\u043d\u0430\u043b\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438?");
                this.put(Language.ET, "Konsoolikanal m\u00e4\u00e4rati kanalile, mida kasutatakse vestluseks. Kas sa kopeerisid m\u00f5ne ID pimesi kanali ID seadistusvalikusse?");
                this.put(Language.ZH, "\u9019\u500b\u63a7\u5236\u53f0\u983b\u9053\u5df2\u6307\u6d3e\u7d66\u804a\u5929\u7528\u983b\u9053\u3002 \u8acb\u78ba\u8a8d\u8a2d\u5b9a\u4e2d\u7684\u983b\u9053ID\u662f\u5426\u6b63\u78ba\u3002");
                this.put(Language.PL, "Kana\u0142 konsoli zosta\u0142 przypisany do kana\u0142u u\u017cywanego do czatu. Czy na \u015blepo skopiowa\u0142e\u015b / wklei\u0142e\u015b identyfikator do opcji konfiguracji identyfikatora kana\u0142u?");
                this.put(Language.DA, "Konsol kanalen er blevet tildelt til en kanal der bliver brugt til chatten. Har du indsat ID'et i den forkerte kanal i konfigurations filen?");
                this.put(Language.UK, "\u041a\u0430\u043d\u0430\u043b \u0434\u043b\u044f \u043a\u043e\u043d\u0441\u043e\u043b\u0456 \u0431\u0443\u0432 \u043f\u0440\u0438\u043a\u0440\u0456\u043f\u043b\u0435\u043d\u0438\u0439 \u0434\u043e \u043a\u0430\u043d\u0430\u043b\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u043e\u0433\u043e \u0447\u0430\u0442\u0443! \u0421\u043b\u0456\u043f\u0438\u0439 \u043a\u043e\u043f\u0456\u043f\u0430\u0441\u0442 ID \u043a\u0430\u043d\u0430\u043b\u0443 \u0443 \u0444\u0430\u0439\u043b\u0456 \u043a\u043e\u043d\u0444\u0456\u0433\u0443\u0440\u0430\u0446\u0456\u0457?");
                this.put(Language.NB, "Konsollkanalen ble bundet til en kanal som blir brukt som chat. Kopierte og limte du en ID i kanal-ID-alternativet uten \u00e5 tenke deg om?");
            }
        }),
        CHAT((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Chat");
                this.put(Language.FR, "Tchat");
                this.put(Language.DE, "Chat");
                this.put(Language.JA, "\u30c1\u30e3\u30c3\u30c8");
                this.put(Language.KO, "\ucc57");
                this.put(Language.NL, "Chat");
                this.put(Language.ES, "Chat");
                this.put(Language.RU, "\u0427\u0430\u0442");
                this.put(Language.ET, "Vestlus");
                this.put(Language.ZH, "\u804a\u5929");
                this.put(Language.PL, "Czat");
                this.put(Language.DA, "Chat");
                this.put(Language.UK, "\u0427\u0430\u0442");
                this.put(Language.NB, "Chat");
            }
        }),
        ERROR_LOGGING_CONSOLE_ACTION((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Error logging console action to");
                this.put(Language.FR, "Erreur lors de la journalisation de l'action de la console");
                this.put(Language.DE, "Fehler beim Loggen einer Konsolenaktion nach");
                this.put(Language.JA, "\u52d5\u4f5c\u8a18\u9332\u5931\u6557");
                this.put(Language.KO, "\ucf58\uc194 \ub85c\uae45\uc911 \uc624\ub958 \ubc1c\uc0dd ");
                this.put(Language.NL, "Fout opgetreden tijdens het loggen van console acties");
                this.put(Language.ES, "Error al iniciar sesi\u00f3n en la consola");
                this.put(Language.RU, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 \u043a\u043e\u043d\u0441\u043e\u043b\u0438 \u0432");
                this.put(Language.ET, "Esines viga konsoolitegevuse logimisel asukohta");
                this.put(Language.ZH, "\u63a7\u5236\u53f0\u8a18\u9304\u932f\u8aa4");
                this.put(Language.PL, "B\u0142\u0105d podczas rejestrowania akcji konsoli do");
                this.put(Language.DA, "Fejl under logning af konsolhandling");
                this.put(Language.UK, "\u043f\u043e\u043c\u0438\u043b\u043a\u0430 \u043b\u043e\u0433\u0443\u0432\u0430\u043d\u043d\u044f \u0434\u0456\u0439 \u043a\u043e\u043d\u0441\u043e\u043b\u0456 \u0432");
                this.put(Language.NB, "Feil ved logging av konsollhandling til");
            }
        }),
        SILENT_JOIN((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Player {player} joined with silent joining permission, not sending a join message");
                this.put(Language.FR, "Le joueur {player} a rejoint le jeu avec une permission de silence lors de la connexion.");
                this.put(Language.DE, "Spieler {player} hat den Server mit Berechtigung zum stillen Betreten betreten, es wird keine Nachricht gesendet");
                this.put(Language.JA, "\u30d7\u30ec\u30a4\u30e4\u30fc {player} \u306f discordsrv.silentjoin \u306e\u6a29\u9650\u304c\u3042\u308b\u306e\u3067\u3001\u30b5\u30fc\u30d0\u30fc\u53c2\u52a0\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9001\u4fe1\u3055\u308c\u307e\u305b\u3093");
                this.put(Language.KO, "\ud50c\ub808\uc774\uc5b4 {player}\uac00 discordsrv.slientjoin \ud37c\ubbf8\uc158\uc744 \uac00\uc9c0\uace0 \uc788\uc2b5\ub2c8\ub2e4. \ucc38\uac00\uba54\uc138\uc9c0\ub97c \ubcf4\ub0b4\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Speler {speler} joined met toestemming om stil te joinen, geen join bericht wordt verstuurd.");
                this.put(Language.ES, "Jugador {player} entr\u00f3 con el permiso de entrada silenciosa, no se ha enviado mensaje de entrada");
                this.put(Language.RU, "\u0418\u0433\u0440\u043e\u043a {player} \u043d\u0435\u0437\u0430\u043c\u0435\u0442\u043d\u043e \u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443, \u0431\u0435\u0437\u043e \u0432\u0441\u044f\u043a\u0438\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0432 \u0447\u0430\u0442\u0435");
                this.put(Language.ET, "M\u00e4ngija {player} liitus vaikse liitumise \u00f5igusega, liitumiss\u00f5numit ei saadeta");
                this.put(Language.ZH, "\u73a9\u5bb6 {player} \u4f7f\u7528\u975c\u9ed8\u767b\u5165\u6b0a\u9650\u9032\u5165\u4e86\u4f3a\u670d\u5668\uff0c\u4e26\u672a\u767c\u9001\u767b\u5165\u8a0a\u606f\u3002");
                this.put(Language.PL, "Gracz {player} do\u0142\u0105czy\u0142 z uprawnieniem do cichego do\u0142\u0105czania, bez wysy\u0142ania wiadomo\u015bci o do\u0142\u0105czeniu");
                this.put(Language.DA, "Spilleren {player} joinede med stille join tilladelsen, sender ikke join besked");
                this.put(Language.UK, "\u0433\u0440\u0430\u0432\u0435\u0446\u044c {player} \u043d\u0435\u043f\u043e\u043c\u0456\u0442\u043d\u043e \u043f\u0440\u0438\u0454\u0434\u043d\u0430\u0432\u0441\u044f \u0434\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u0431\u0435\u0437 \u0436\u043e\u0434\u043d\u0438\u0445 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u044c \u0432 \u0447\u0430\u0442\u0456");
                this.put(Language.NB, "Spiller {player} koblet til med tillatelsen lydl\u00f8s tilkobling, sender ikke en tilkoblingsmelding");
            }
        }),
        SILENT_QUIT((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Player {player} quit with silent quitting permission, not sending a quit message");
                this.put(Language.FR, "Le joueur {player} a quitt\u00e9 le jeu avec une permission de silence lors de le d\u00e9connexion.");
                this.put(Language.DE, "Spieler {player} hat den Server mit Berechtigung zum stillen Verlassen verlassen, es wird keine Nachricht gesendet");
                this.put(Language.JA, "\u30d7\u30ec\u30a4\u30e4\u30fc {player} \u306f discordsrv.silentquit \u306e\u6a29\u9650\u304c\u3042\u308b\u306e\u3067\u3001\u30b5\u30fc\u30d0\u30fc\u9000\u51fa\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9001\u4fe1\u3055\u308c\u307e\u305b\u3093");
                this.put(Language.KO, "\ud50c\ub808\uc774\uc5b4 {player} \uac00 discordsrv.slientquit \ud37c\ubbf8\uc158\uc744 \uac00\uc9c0\uace0 \uc788\uc2b5\ub2c8\ub2e4. \ud1f4\uc7a5\uba54\uc138\uc9c0\ub97c \ubcf4\ub0b4\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Speler {speler} is weg gegaan met toestemming om stil weg te gaan, geen quit bericht wordt verstuurd.");
                this.put(Language.ES, "Jugador {player} sali\u00f3 con el permiso de salida silenciosa, no se ha enviado un mensaje de salida");
                this.put(Language.RU, "\u0418\u0433\u0440\u043e\u043a {player} \u043d\u0435\u0437\u0430\u043c\u0435\u0442\u043d\u043e \u0432\u044b\u0448\u0435\u043b, \u043d\u0435 \u043f\u043e\u043f\u0440\u043e\u0449\u0430\u0432\u0448\u0438\u0441\u044c, \u0431\u0435\u0437\u043e \u0432\u0441\u044f\u043a\u0438\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u0432 \u0447\u0430\u0442\u0435");
                this.put(Language.ET, "M\u00e4ngija {player} lahkus vaikse lahkumise \u00f5igusega, lahkumiss\u00f5numit ei saadeta");
                this.put(Language.ZH, "\u73a9\u5bb6 {player} \u4f7f\u7528\u975c\u9ed8\u767b\u51fa\u6b0a\u9650\u96e2\u958b\u4e86\u4f3a\u670d\u5668\uff0c\u4e26\u672a\u767c\u9001\u767b\u51fa\u8a0a\u606f\u3002");
                this.put(Language.PL, "Gracz {player} wyszed\u0142 z uprawnieniem do cichego wyj\u015bcia, bez wysy\u0142ania wiadomo\u015bci o wyj\u015bciu");
                this.put(Language.DA, "Spilleren {player} afsluttede med stille afslutning tilladelse, sender ikke afslutnings besked");
                this.put(Language.UK, "\u0433\u0440\u0430\u0432\u0435\u0446\u044c {player} \u043d\u0435\u043f\u043e\u043c\u0456\u0442\u043d\u043e \u0432\u0438\u0439\u0448\u043e\u0432, \u043d\u0435 \u043f\u043e\u043f\u0440\u043e\u0449\u0430\u0432\u0448\u0438\u0441\u044c, \u0431\u0435\u0437 \u0436\u043e\u0434\u043d\u0438\u0445 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u044c \u0432 \u0447\u0430\u0442\u0456");
                this.put(Language.NB, "Spiller {player} frakoblet med tillatelsen lydl\u00f8s frakobling, sender ikke en frakoblingsmelding");
            }
        }),
        LINKED_ACCOUNTS_SAVED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Saved linked accounts in {ms}ms");
                this.put(Language.FR, "Sauvegarde des comptes li\u00e9s en {ms}ms");
                this.put(Language.DE, "Speichern von verkn\u00fcpften Accounts in {ms}ms");
                this.put(Language.JA, "{ms}\u30df\u30ea\u79d2\u3067\u30ea\u30f3\u30af\u3055\u308c\u305f\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "{ms}ms \ub9cc\uc5d0 \uc5f0\ub3d9\uacc4\uc815 \uc800\uc7a5\uc644\ub8cc");
                this.put(Language.NL, "Gekoppelde accounts opgeslagen in {ms}ms");
                this.put(Language.ES, "Cuentas vinculadas guardadas en {ms}ms");
                this.put(Language.RU, "\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b \u0437\u0430 {ms}\u043c\u0441");
                this.put(Language.ET, "\u00dchendatud kontod salvestati {ms}ms jooksul");
                this.put(Language.ZH, "\u5df2\u5132\u5b58\u5df2\u9023\u7d50\u5e33\u865f\uff0c\u8017\u6642{ms}ms");
                this.put(Language.PL, "Zapisane po\u0142\u0105czone konta w {ms}ms");
                this.put(Language.DA, "Gemte linkede brugere det tog {ms}ms");
                this.put(Language.UK, "\u041f\u0440\u0438\u0432'\u044f\u0437\u0430\u043d\u0456 \u0430\u043a\u0430\u0443\u043d\u0442\u0438 \u0443\u0441\u043f\u0456\u0448\u043d\u043e \u0437\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u0456 \u0437\u0430 {ms}\u043c\u0441");
                this.put(Language.NB, "Lagret tilkoplede brukere p\u00e5 {ms}ms");
            }
        }),
        LINKED_ACCOUNTS_SAVE_FAILED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Failed saving linked accounts");
                this.put(Language.FR, "Erreur lors de la sauvegarde des comptes li\u00e9s");
                this.put(Language.DE, "Fehler beim Speichern von verkn\u00fcpften Accounts");
                this.put(Language.JA, "\u30ea\u30f3\u30af\u3055\u308c\u305f\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "\uc5f0\ub3d9\uacc4\uc815 \uc800\uc7a5 \uc2e4\ud328");
                this.put(Language.NL, "Opslaan van gekoppelde accounts is mislukt");
                this.put(Language.ES, "Fallo al guardar las cuentas vinculadas");
                this.put(Language.RU, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432");
                this.put(Language.ET, "\u00dchendatud kontode salvestamine eba\u00f5nnestus");
                this.put(Language.ZH, "\u5132\u5b58\u5df2\u9023\u7d50\u5e33\u865f\u5931\u6557");
                this.put(Language.PL, "Nie uda\u0142o si\u0119 zapisa\u0107 po\u0142\u0105czonych kont");
                this.put(Language.DA, "Fejlede at gemme linkede brugere");
                this.put(Language.UK, "\u0421\u0442\u0430\u043b\u0430\u0441\u044f \u043f\u043e\u043c\u0438\u043b\u043a\u0430 \u0437\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u0432'\u044f\u0437\u0430\u043d\u0438\u0445 \u0430\u043a\u0430\u0443\u043d\u0442\u0456\u0432");
                this.put(Language.NB, "Kunne ikke lagre tilkoplede brukere");
            }
        }),
        FAILED_LOADING_PLUGIN((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Failed loading plugin");
                this.put(Language.FR, "Erreur lors du chargement du plugin");
                this.put(Language.DE, "Fehler beim Laden des Plugins");
                this.put(Language.JA, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                this.put(Language.KO, "\ud50c\ub7ec\uadf8\uc778 \ub85c\ub4dc \uc2e4\ud328");
                this.put(Language.NL, "Gefaald om de plugin te laden.");
                this.put(Language.ES, "Fallo al cargar el plugin");
                this.put(Language.RU, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430");
                this.put(Language.ET, "Plugina laadimine eba\u00f5nnestus");
                this.put(Language.ZH, "\u8b80\u53d6\u63d2\u4ef6\u5931\u6557");
                this.put(Language.PL, "Nie uda\u0142o si\u0119 za\u0142adowa\u0107 wtyczki");
                this.put(Language.DA, "Fejlede at loade plugin");
                this.put(Language.UK, "\u041f\u043e\u043c\u0438\u043b\u043a\u0430 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f \u043f\u043b\u0430\u0433\u0456\u043d\u0430");
                this.put(Language.NB, "Kunne ikke laste utvidelse");
            }
        }),
        GROUP_SYNCHRONIZATION_COULD_NOT_FIND_ROLE((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Could not find role id {rolename} for use with group synchronization. Is the bot in the server?");
                this.put(Language.FR, "Impossible de trouver le r\u00f4le {rolename} lors de la synchronisation des groupes.Le bot est il sur le serveur ?");
                this.put(Language.DE, "Konnte keine Rolle mit id {rolename} f\u00fcr gruppensynchronisierung finden. Ist der Bot auf dem Server?");
                this.put(Language.JA, "\u30b0\u30eb\u30fc\u30d7\u3092\u540c\u671f\u3055\u305b\u308b\u305f\u3081\u306b\u3001ID\u300c{rolename}\u300d\u306e\u30ed\u30fc\u30eb\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 Bot\u306f\u30b5\u30fc\u30d0\u4e0a\u306b\u3042\u308a\u307e\u3059\u304b\uff1f");
                this.put(Language.KO, "\uadf8\ub8f9 \ub3d9\uae30\ud654\ub97c \ud560 Role ID\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ubd07\uc774 \ub514\uc2a4\ucf54\ub4dc \uc11c\ubc84\uc5d0 \uc788\ub098\uc694?");
                this.put(Language.NL, "Kon role id {rolename} niet vinden dit word gebruikt voor groep synchronisatie. Is de bot in de server?");
                this.put(Language.ES, "No se pudo encontrar el rol {rolename} para usar con sincronizaci\u00f3n de grupo. \u00bfEst\u00e1 el bot en el servidor?");
                this.put(Language.RU, "\u041d\u0435 \u043c\u043e\u0433\u0443 \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 ID \u0440\u043e\u043b\u0438 {rolename}, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044e. \u0411\u043e\u0442 \u0442\u043e\u0447\u043d\u043e \u0443\u0436\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443?");
                this.put(Language.ET, "Gruppide s\u00fcnkroonimiseks vajalikku rolli ID-d {rolename} ei leitud. Kas bot on serveris?");
                this.put(Language.ZH, "\u672a\u80fd\u627e\u5230\u8eab\u5206\u7d44 {rolename} \u4f86\u9032\u884c\u7fa4\u7d44\u540c\u6b65\u3002 \u8acb\u78ba\u8a8dBot\u662f\u5426\u6709\u5728\u4f3a\u670d\u5668\u4e2d\u3002");
                this.put(Language.PL, "Nie uda\u0142o si\u0119 znale\u017a\u0107 identyfikatora roli {rolename} do u\u017cytku z synchronizacj\u0105 grupow\u0105. Czy bot jest na serwerze?");
                this.put(Language.DA, "Kunne ikke finde rolle id {rolename} til brug af gruppe synkronisation. Er botten i serveren?");
                this.put(Language.UK, "\u041d\u0435 \u043c\u043e\u0436\u0443 \u0437\u043d\u0430\u0439\u0442\u0438 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u043d\u0438\u0439 ID \u0440\u043e\u043b\u0456 {rolename}, \u0449\u043e\u0431 \u0437\u0440\u043e\u0431\u0438\u0442\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0456\u0437\u0430\u0446\u0456\u044e. \u0411\u043e\u0442 \u0442\u043e\u0447\u043d\u043e \u0432\u0436\u0435 \u043f\u0456\u0434\u043a\u043b\u044e\u0447\u0438\u0432\u0441\u044f \u0434\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430?");
                this.put(Language.NB, "Kunne ikke finne rolle-ID {rolename} for bruk av gruppesynkronisering. Er boten med i serveren?");
            }
        }),
        NO_MESSAGE_GIVEN_TO_BROADCAST((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "No text given to broadcast");
                this.put(Language.FR, "Aucune langue donn\u00e9e \u00e0 diffuser");
                this.put(Language.DE, "Keine Sprache f\u00fcr Broadcast angegeben");
                this.put(Language.JA, "\u30d6\u30ed\u30fc\u30c9\u30ad\u30e3\u30b9\u30c8\u3059\u308b\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                this.put(Language.KO, "\ubc29\uc1a1\ud560 \uc5b8\uc5b4\uac00 \uc8fc\uc5b4\uc9c0\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Geen taal is opgegeven om uit te zenden.");
                this.put(Language.ES, "Ning\u00fan idioma dado para transmitir");
                this.put(Language.RU, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u044f\u0437\u044b\u043a \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439");
                this.put(Language.ET, "Teadaande saatmiseks ei m\u00e4\u00e4ratud keelt");
                this.put(Language.ZH, "\u672a\u7d66\u5ee3\u64ad\u6307\u5b9a\u8a9e\u8a00");
                this.put(Language.PL, "Brak tekstu do wys\u0142ania");
                this.put(Language.DA, "Ingen text givet til broadcast");
                this.put(Language.UK, "\u043d\u0435 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u043d\u043e\u0457 \u043c\u043e\u0432\u0438 \u0434\u043b\u044f \u043d\u0430\u0434\u0441\u0438\u043b\u0430\u043d\u043d\u044f \u0441\u043f\u043e\u0432\u0456\u0449\u0435\u043d\u044c");
                this.put(Language.NB, "Det er ikke gitt noen tekst til sending");
            }
        }),
        PLAYER_ONLY_COMMAND((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Only players can execute this command.");
                this.put(Language.FR, "Seuls les joueurs peuvent effectuer cette commande.");
                this.put(Language.DE, "Nur Spieler k\u00f6nnen diesen Befehl ausf\u00fchren.");
                this.put(Language.JA, "\u30b2\u30fc\u30e0\u5185\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u307f\u304c\u3053\u306e\u30b3\u30de\u30f3\u30c9\u3092\u5b9f\u884c\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002");
                this.put(Language.KO, "\ud50c\ub808\uc774\uc5b4\ub9cc \uc774 \uba85\ub839\uc5b4\ub97c \uc2e4\ud589 \ud560 \uc218 \uc788\uc2b5\uc774\ub2e4.");
                this.put(Language.NL, "Alleen spelers kunnen dit command gebruiken.");
                this.put(Language.ES, "Solo los jugadores pueden ejecutar este comando");
                this.put(Language.RU, "\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0442\u0430\u043a\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
                this.put(Language.ET, "Ainult m\u00e4ngijad saavad seda k\u00e4sklust teostada.");
                this.put(Language.ZH, "\u53ea\u6709\u73a9\u5bb6\u80fd\u57f7\u884c\u9019\u500b\u6307\u4ee4");
                this.put(Language.PL, "Tylko gracze mog\u0105 wykona\u0107 to polecenie.");
                this.put(Language.DA, "Kun spillere kan eksekvere denne kommando.");
                this.put(Language.UK, "\u0422\u0456\u043b\u044c\u043a\u0438 \u0433\u0440\u0430\u0432\u0446\u0456 \u043c\u043e\u0436\u0443\u0442\u044c \u0432\u0438\u043a\u043e\u043d\u0430\u0442\u0438 \u0442\u0430\u043a\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
                this.put(Language.NB, "Bare spillere kan utf\u00f8re denne kommandoen.");
            }
        }),
        RELOADED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "The DiscordSRV config & lang have been reloaded.");
                this.put(Language.FR, "La configuration et les fichiers de langage de DiscordSRV ont \u00e9t\u00e9 recharg\u00e9.");
                this.put(Language.DE, "Die DiscordSRV Konfiguration und Sprachdatei wurden neu eingelesen.");
                this.put(Language.JA, "DiscordSRV\u306e\u8a2d\u5b9a\u3068\u8a00\u8a9e\u304c\u518d\u8aad\u8fbc\u3055\u308c\u307e\u3057\u305f\u3002");
                this.put(Language.KO, "DiscordSRV \ucee8\ud53c\uadf8 \ubc0f \uc5b8\uc5b4 \uc124\uc815\uc774 \ub9ac\ub85c\ub4dc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "De DiscordSRV config & lang is herladen.");
                this.put(Language.ES, "La configuraci\u00f3n y el idioma de DiscordSRV han sido recargadas");
                this.put(Language.RU, "DiscordSRV \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0438 \u044f\u0437\u044b\u043a\u043e\u0432\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b.");
                this.put(Language.ET, "DiscordSRV seadistus ja keel on uuesti laaditud.");
                this.put(Language.ZH, "DiscordSRV\u7684\u8a2d\u5b9a\u6a94\u8207\u8a5e\u689d\u5df2\u91cd\u65b0\u8b80\u53d6\u3002");
                this.put(Language.PL, "Konfiguracja i j\u0119zyk DiscordSRV zosta\u0142y ponownie za\u0142adowane.");
                this.put(Language.DA, "DiscordSRV konfigurationen & sprog er blevet genstartet.");
                this.put(Language.UK, "DiscordSRV \u043a\u043e\u043d\u0444\u0456\u0433\u0443\u0440\u0430\u0446\u0456\u044f \u0442\u0430 \u043d\u0430\u043b\u0430\u0448\u0442\u0443\u0432\u0430\u043d\u043d\u044f \u043c\u043e\u0432\u0438 \u0443\u0441\u043f\u0456\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u0456.");
                this.put(Language.NB, "DiscordSRVs konfigurasjons- og spr\u00e5kfil har blitt lastet om p\u00e5 nytt");
            }
        }),
        NO_UNLINK_TARGET_SPECIFIED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "No player specified. It can be a player UUID, player name, or Discord ID.");
                this.put(Language.FR, "Aucune cible sp\u00e9cifi\u00e9e. Peut \u00eatre un UUID, un ID Discord ou un nom de joueur.");
                this.put(Language.DE, "Kein Spieler angegeben. Dies kann eine UUID, ein Spielername oder eine Discord-ID sein.");
                this.put(Language.JA, "\u30d7\u30ec\u30fc\u30e4\u30fc\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u3053\u308c\u306f\u3001UUID\u3001\u30d7\u30ec\u30fc\u30e4\u30fc\u540d\u3001\u307e\u305f\u306fDiscord ID\u3067\u3059\u3002");
                this.put(Language.KO, "\ub300\uc0c1\uc774 \uc9c0\uc815\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4. \ud50c\ub808\uc774\uc5b4 UUID, \ud50c\ub808\uc774\uc5b4 \uc774\ub984 \ub610\ub294 Discord ID \uc77c \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "U moet opgeven wie u wilt ontkoppelen. Het kan een UUID, een Discord-ID of een spelersnaam zijn.");
                this.put(Language.ES, "Ning\u00fan objetivo especificado. Puede ser un UUID, una ID de Discord o un nombre de jugador.");
                this.put(Language.RU, "\u041d\u0438 \u043e\u0434\u0438\u043d \u0438\u0433\u0440\u043e\u043a \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d. \u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c UUID, \u0438\u043c\u044f \u0438\u0433\u0440\u043e\u043a\u0430 \u0438\u043b\u0438 Discord ID.");
                this.put(Language.ET, "\u00dchtegi m\u00e4ngijat pole t\u00e4psustatud. See v\u00f5ib olla m\u00e4ngija UUID, m\u00e4ngija nimi v\u00f5i Discord ID.");
                this.put(Language.ZH, "\u6c92\u6709\u73a9\u5bb6\u6307\u5b9a\u3002\u9019\u53ef\u80fd\u662f\u73a9\u5bb6\u7684UUID\uff0c\u73a9\u5bb6\u540d\u7a31\u6216Discord ID\u3002");
                this.put(Language.PL, "Nie okre\u015blono gracza. Mo\u017ce to by\u0107 identyfikator UUID gracza, nazwa gracza lub identyfikator Discord.");
                this.put(Language.DA, "Ingen spiller specificeret. Det kan v\u00e6re en spillers UUID, spillernavn, eller Discord ID.");
                this.put(Language.UK, "\u0416\u043e\u0434\u0435\u043d \u0433\u0440\u0430\u0432\u0435\u0446\u044c \u043d\u0435 \u0432\u043a\u0430\u0437\u0430\u043d\u0438\u0439. \u0426\u0435 \u043c\u043e\u0436\u0435 \u0431\u0443\u0442\u0438 UUID, \u0456\u043c'\u044f \u0433\u0440\u0430\u0432\u0446\u044f \u0430\u0431\u043e Discord ID.");
                this.put(Language.NB, "Ingen spiller er spesifisert. Det kan v\u00e6re en spiller-UUID, spillernavn eller Discord-ID.");
            }
        }),
        COMMAND_EXCEPTION((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "An internal error occurred while while processing your command.");
                this.put(Language.FR, "Une erreur interne \u0161'est produite lors du traitement.");
                this.put(Language.DE, "W\u00e4hrend der Verarbeitung Ihres Befehls ist ein interner Fehler aufgetreten.");
                this.put(Language.JA, "\u30b3\u30de\u30f3\u30c9\u306e\u51e6\u7406\u4e2d\u306b\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                this.put(Language.KO, "\uba85\ub839\uc744 \ucc98\ub9ac\ud558\ub294 \uc911 \ub0b4\ubd80 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                this.put(Language.NL, "Een interne fout is opgetreden tijdens het uitvoeren van jouw opdracht.");
                this.put(Language.ES, "Se produjo un error interno al procesar su comando.");
                this.put(Language.RU, "\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0432\u0430\u0448\u0435\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430.");
                this.put(Language.ET, "K\u00e4skluse t\u00f6\u00f6tlemisel esines sisemine viga.");
                this.put(Language.ZH, "\u8655\u7406\u547d\u4ee4\u6642\u767c\u751f\u5167\u90e8\u932f\u8aa4\u3002");
                this.put(Language.PL, "Podczas przetwarzania polecenia wyst\u0105pi\u0142 b\u0142\u0105d wewn\u0119trzny.");
                this.put(Language.DA, "En intern fejl fandt sted imens den behandlede din kommando.");
                this.put(Language.UK, "\u043f\u0456\u0434 \u0447\u0430\u0441 \u043e\u0431\u0440\u043e\u0431\u043a\u0438 \u0432\u0430\u0448\u043e\u0457 \u043a\u043e\u043c\u0430\u043d\u0434\u0438 \u0441\u0442\u0430\u043b\u0430\u0441\u044f \u0412\u043d\u0443\u0442\u0440\u0456\u0448\u043d\u044f \u043f\u043e\u043c\u0438\u043b\u043a\u0430.");
                this.put(Language.NB, "En intern feil oppstod under behandlingen av kommandoen din.");
            }
        }),
        RESYNC_WHEN_GROUP_SYNC_DISABLED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "Group synchonization requires valid GroupRoleSynchronizationGroupsAndRolesToSync entries in synchronization.yml");
                this.put(Language.FR, "La synchronisation de groupe n\u00e9cessite des entr\u00e9es GroupRoleSynchronizationGroupsAndRolesToSync valides dans synchronization.yml");
                this.put(Language.DE, "F\u00fcr die Gruppensynchronisierung sind g\u00fcltige GroupRoleSynchronizationGroupsAndRolesToSync-Eintr\u00e4ge in synchronization.yml erforderlich");
                this.put(Language.JA, "\u30b0\u30eb\u30fc\u30d7\u306e\u540c\u671f\u306b\u306f\u3001synchronization.yml\u306e\u6709\u52b9\u306aGroupRoleSynchronizationGroupsAndRolesToSync\u30a8\u30f3\u30c8\u30ea\u304c\u5fc5\u8981\u3067\u3059\u3002");
                this.put(Language.KO, "\uadf8\ub8f9 \ub3d9\uae30\ud654\uc5d0\ub294 \ub3d9\uae30\ud654\uc5d0 \uc720\ud6a8\ud55c GroupRoleSynchronizationGroupsAndRolesToSync \ud56d\ubaa9\uc774 synchronization.yml \ud569\ub2c8\ub2e4.");
                this.put(Language.NL, "Groepsynchronisatie vereist geldige GroupRoleSynchronizationGroupsAndRolesToSync-vermeldingen in synchronization.yml");
                this.put(Language.ES, "La sincronizaci\u00f3n de grupo requiere entradas v\u00e1lidas de GroupRoleSynchronizationGroupsAndRolesToSync en synchronization.yml");
                this.put(Language.RU, "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0433\u0440\u0443\u043f\u043f\u044b \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 GroupRoleSynchronizationGroupsAndRolesToSync \u0432 synchronization.yml");
                this.put(Language.ET, "Grupi s\u00fcnkroonimiseks on vaja kehtivaid GroupRoleSynchronizationGroupsAndRolesToSync kirjeid failis synchronization.yml");
                this.put(Language.ZH, "\u7fa4\u7d44\u540c\u6b65\u9700\u8981\u5728synchronization.yml\u4e2d\u6709\u6548\u7684GroupRoleSynchronizationGroupsAndRolesToSync\u689d\u76ee");
                this.put(Language.PL, "Synchronizacja grupowa wymaga wa\u017cnego GroupRoleSynchronizationGroupsAndRolesToSync wpisu w synchronization.yml");
                this.put(Language.DA, "Gruppe synkronisation kr\u00e6ver valid GroupRoleSynchronizationGroupsAndRolesToSync entr\u00e9er i synchronization.yml");
                this.put(Language.UK, "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0456\u0437\u0430\u0446\u0456\u044f \u0433\u0440\u0443\u043f\u0438 \u0432\u0438\u043c\u0430\u0433\u0430\u0454 \u0434\u0456\u0439\u0441\u043d\u0438\u0445 \u0437\u0430\u043f\u0438\u0441\u0456\u0432 GroupRoleSynchronizationGroupsAndRolesToSync \u0443 synchronization.yml");
                this.put(Language.NB, "Gruppesynkronisering krever gyldig GroupRoleSynchronizationGroupsAndRolesToSync-oppf\u00f8ringer i synchronization.yml");
            }
        }),
        PLUGIN_RELOADED((Map<Language, String>)new HashMap<Language, String>(){
            {
                this.put(Language.EN, "DiscordSRV has been reloaded. This is NOT supported, and issues WILL occur! Restart your server before asking for support!");
                this.put(Language.FR, "DiscordSRV a \u00e9t\u00e9 recharg\u00e9. Ceci n'est PAS pris en charge et des probl\u00e8mes surviendront! Red\u00e9marrez votre serveur avant de demander de l'aide!");
                this.put(Language.DE, "DiscordSRV wurde neu geladen. Dies wird NICHT unterst\u00fctzt und es treten Probleme auf! Starten Sie Ihren Server neu, bevor Sie um Unterst\u00fctzung bitten!");
                this.put(Language.JA, "DiscordSRV\u304c\u30ea\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002 \u3053\u308c\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u304a\u3089\u305a\u3001\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3059\uff01 \u30b5\u30dd\u30fc\u30c8\u3092\u6c42\u3081\u308b\u524d\u306b\u30b5\u30fc\u30d0\u30fc\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\uff01");
                this.put(Language.KO, "DiscordSRV\uac00 \ub2e4\uc2dc\ub85c\ub4dc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc774\uac83\uc740 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc73c\uba70 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud569\ub2c8\ub2e4! \uc9c0\uc6d0\uc744 \uc694\uccad\ud558\uae30 \uc804\uc5d0 \uc11c\ubc84\ub97c \ub2e4\uc2dc \uc2dc\uc791\ud558\uc2ed\uc2dc\uc624!");
                this.put(Language.NL, "DiscordSRV is opnieuw geladen. Dit wordt NIET ondersteund en er ZULLEN problemen optreden! Start uw server opnieuw op voordat u om ondersteuning vraagt!");
                this.put(Language.ES, "DiscordSRV ha sido recargado. \u00a1Esto NO es compatible, y OCURRIR\u00c1N problemas! \u00a1Reinicie su servidor antes de solicitar asistencia!");
                this.put(Language.RU, "DiscordSRV \u0431\u044b\u043b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d. \u042d\u0442\u043e \u041d\u0415 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f, \u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0431\u0443\u0434\u0443\u0442 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442\u044c! \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440, \u043f\u0440\u0435\u0436\u0434\u0435 \u0447\u0435\u043c \u043e\u0431\u0440\u0430\u0449\u0430\u0442\u044c\u0441\u044f \u0437\u0430 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439!");
                this.put(Language.ET, "DiscordSRV on taaslaaditud. See EI OLE toetatud ning probleemid ESINEVAD kindlalt! Enne toe k\u00fcsimist taask\u00e4ivita oma server!");
                this.put(Language.ZH, "DiscordSRV\u5df2\u91cd\u65b0\u8f09\u5165\u3002 \u4e0d\u652f\u6301\u6b64\u529f\u80fd\uff0c\u4e26\u4e14\u6703\u767c\u751f\u554f\u984c\uff01 \u5728\u5c0b\u6c42\u652f\u6301\u4e4b\u524d\uff0c\u8acb\u91cd\u65b0\u555f\u52d5\u4f3a\u670d\u5668\uff01");
                this.put(Language.PL, "DiscordSRV zosta\u0142 ponownie za\u0142adowany. To NIE jest obs\u0142ugiwane i pojawi\u0105 si\u0119 problemy! Zrestartuj serwer, zanim poprosisz o wsparcie!");
                this.put(Language.DA, "DiscordSRV er blevet genladet. Dette er IKKE underst\u00f8ttet, og problemer VIL OPST\u00c5! Genstart din server f\u00f8r du sp\u00f8rger om hj\u00e6lp!");
                this.put(Language.UK, "DiscordSRV \u0431\u0443\u043b\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e. \u0426\u0435 \u043d\u0435 \u043f\u0456\u0434\u0442\u0440\u0438\u043c\u0443\u0454\u0442\u044c\u0441\u044f, \u0456 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0438 \u0431\u0443\u0434\u0443\u0442\u044c \u0432\u0456\u0434\u0431\u0443\u0432\u0430\u0442\u0438\u0441\u044f! \u041f\u0435\u0440\u0435\u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440, \u043f\u0435\u0440\u0448 \u043d\u0456\u0436 \u0437\u0432\u0435\u0440\u0442\u0430\u0442\u0438\u0441\u044f \u0437\u0430 \u043f\u0456\u0434\u0442\u0440\u0438\u043c\u043a\u043e\u044e!");
                this.put(Language.NB, "DiscordSRV har blitt lastet om. Dette er IKKE st\u00f8ttet og feil VIL oppst\u00e5! Restart serveren din f\u00f8r du ber om st\u00f8tte.");
            }
        });

        private final Map<Language, String> definitions;

        private InternalMessage(Map<Language, String> definitions) {
            this.definitions = definitions;
        }

        public String toString() {
            return this.definitions.getOrDefault((Object)DiscordSRV.config().getLanguage(), this.definitions.get((Object)Language.EN));
        }

        public Map<Language, String> getDefinitions() {
            return this.definitions;
        }
    }
}

