/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.configuralize.DynamicConfig;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.util.LangUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;

public class MessageFormatResolver {
    public static String getMessageFormat(List<Role> selectedRoles, String channel) {
        LangUtil.Message format = !selectedRoles.isEmpty() ? LangUtil.Message.CHAT_TO_MINECRAFT : LangUtil.Message.CHAT_TO_MINECRAFT_NO_ROLE;
        return DiscordSRV.config().getOptionalString(format.getKeyName() + "_" + channel).map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).orElseGet(format::toString);
    }

    public static MessageFormat getMessageFromConfiguration(DynamicConfig config, String key) {
        Optional<String> content;
        if (!config.getOptional(key).isPresent()) {
            return null;
        }
        Optional<Boolean> enabled = config.getOptionalBoolean(key + ".Enabled");
        if (enabled.isPresent() && !enabled.get().booleanValue()) {
            return null;
        }
        MessageFormat messageFormat = new MessageFormat();
        if (config.getOptional(key + ".Embed").isPresent() && config.getOptionalBoolean(key + ".Embed.Enabled").orElse(true).booleanValue()) {
            Optional<Boolean> timestampOptional;
            Optional<String> hexColor = config.getOptionalString(key + ".Embed.Color");
            if (hexColor.isPresent()) {
                String hex = hexColor.get().trim();
                if (!hex.startsWith("#")) {
                    hex = "#" + hex;
                }
                if (hex.length() == 7) {
                    messageFormat.setColorRaw(Integer.valueOf(hex.substring(1, 7), 16));
                } else {
                    DiscordSRV.debug("Invalid color hex: " + hex + " (in " + key + ".Embed.Color)");
                }
            } else {
                config.getOptionalInt(key + ".Embed.Color").ifPresent(messageFormat::setColorRaw);
            }
            if (config.getOptional(key + ".Embed.Author").isPresent()) {
                config.getOptionalString(key + ".Embed.Author.Name").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setAuthorName);
                config.getOptionalString(key + ".Embed.Author.Url").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setAuthorUrl);
                config.getOptionalString(key + ".Embed.Author.ImageUrl").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setAuthorImageUrl);
            }
            config.getOptionalString(key + ".Embed.ThumbnailUrl").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setThumbnailUrl);
            config.getOptionalString(key + ".Embed.Title.Text").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setTitle);
            config.getOptionalString(key + ".Embed.Title.Url").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setTitleUrl);
            config.getOptionalString(key + ".Embed.Description").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setDescription);
            Optional<List<String>> fieldsOptional = config.getOptionalStringList(key + ".Embed.Fields");
            if (fieldsOptional.isPresent()) {
                ArrayList<MessageEmbed.Field> fields = new ArrayList<MessageEmbed.Field>();
                for (String s : fieldsOptional.get()) {
                    if (s.contains(";")) {
                        String[] parts = s.split(";");
                        if (parts.length < 2) continue;
                        boolean inline = parts.length < 3 || Boolean.parseBoolean(parts[2]);
                        fields.add(new MessageEmbed.Field(parts[0], parts[1], inline, true));
                        continue;
                    }
                    boolean inline = Boolean.parseBoolean(s);
                    fields.add(new MessageEmbed.Field("\u200e", "\u200e", inline, true));
                }
                messageFormat.setFields(fields);
            }
            config.getOptionalString(key + ".Embed.ImageUrl").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setImageUrl);
            if (config.getOptional(key + ".Embed.Footer").isPresent()) {
                config.getOptionalString(key + ".Embed.Footer.Text").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setFooterText);
                config.getOptionalString(key + ".Embed.Footer.IconUrl").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setFooterIconUrl);
            }
            if ((timestampOptional = config.getOptionalBoolean(key + ".Embed.Timestamp")).isPresent()) {
                if (timestampOptional.get().booleanValue()) {
                    messageFormat.setTimestamp(new Date().toInstant());
                }
            } else {
                Optional<Long> epochOptional = config.getOptionalLong(key + ".Embed.Timestamp");
                epochOptional.ifPresent(timestamp -> messageFormat.setTimestamp(new Date((long)timestamp).toInstant()));
            }
        }
        if (config.getOptional(key + ".Webhook").isPresent() && config.getOptionalBoolean(key + ".Webhook.Enabled").orElse(config.getOptionalBoolean(key + ".Webhook.Enable").orElse(false)).booleanValue()) {
            messageFormat.setUseWebhooks(true);
            config.getOptionalString(key + ".Webhook.AvatarUrl").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setWebhookAvatarUrl);
            config.getOptionalString(key + ".Webhook.Name").filter(StringUtils::isNotBlank).ifPresent(messageFormat::setWebhookName);
        }
        if ((content = config.getOptionalString(key + ".Content")).isPresent() && StringUtils.isNotBlank(content.get())) {
            messageFormat.setContent(content.get());
        }
        return messageFormat.isAnyContent() ? messageFormat : null;
    }
}

