/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.kyori.adventure.audience.Audience;
import github.scarsz.discordsrv.dependencies.kyori.adventure.platform.bukkit.BukkitAudiences;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.TextComponent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.TextReplacementConfig;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.event.ClickEvent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.minimessage.MiniMessage;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import github.scarsz.discordsrv.dependencies.mcdiscordreserializer.discord.DiscordSerializer;
import github.scarsz.discordsrv.dependencies.mcdiscordreserializer.minecraft.MinecraftSerializer;
import github.scarsz.discordsrv.dependencies.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import github.scarsz.discordsrv.dependencies.mcdiscordreserializer.rules.DiscordMarkdownRules;
import github.scarsz.discordsrv.dependencies.simpleast.core.node.Node;
import github.scarsz.discordsrv.dependencies.simpleast.core.parser.Rule;
import github.scarsz.discordsrv.dependencies.simpleast.core.simple.SimpleMarkdownRules;
import github.scarsz.discordsrv.objects.DiscordSRVMinecraftRenderer;
import github.scarsz.discordsrv.util.PluginUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MessageUtil {
    public static final Pattern DEFAULT_URL_PATTERN = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.\\w{2,})(/\\S*)?");
    public static final Pattern MINIMESSAGE_PATTERN = Pattern.compile("(?!<@)((?<start><)(?<token>[^<>]+(:(?<inner>['\"]?([^'\"](\\\\\\\\['\"])?)+['\"]?))*)(?<end>>))+?");
    public static final Character LEGACY_SECTION = Character.valueOf('\u00a7');
    public static final Pattern MESSAGE_PLACEHOLDER = Pattern.compile("%message%.*");
    public static final Pattern STRIP_PATTERN = Pattern.compile("(?:(?<!<@)&|[\u00a7\u007f])(?i)[0-9a-fklmnorx]");
    public static final Pattern STRIP_SECTION_ONLY_PATTERN = Pattern.compile("(?<!<@)\u00a7(?i)[0-9a-fklmnorx]");
    public static final Pattern TRANSLATE_PATTERN = Pattern.compile("(?<!<@)(&)(?i)(?:[0-9a-fklmnorx]|#[0-9a-f]{6})");
    public static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.builder().extractUrls().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    public static final MinecraftSerializer MINECRAFT_SERIALIZER;
    public static final MinecraftSerializer LIMITED_MINECRAFT_SERIALIZER;
    private static BukkitAudiences BUKKIT_AUDIENCES;
    private static final boolean MC_1_16;

    private static BukkitAudiences getAudiences() {
        return BUKKIT_AUDIENCES != null ? BUKKIT_AUDIENCES : (BUKKIT_AUDIENCES = BukkitAudiences.create((Plugin)DiscordSRV.getPlugin()));
    }

    private MessageUtil() {
    }

    public static boolean isLegacy(String plainMessage) {
        return plainMessage.indexOf(LEGACY_SECTION.charValue()) != -1;
    }

    public static Component toComponent(String message) {
        return MessageUtil.toComponent(message, MessageUtil.isLegacy(message));
    }

    public static Component toComponent(String message, boolean useLegacy) {
        if (useLegacy) {
            return LEGACY_SERIALIZER.deserialize(message);
        }
        Object component = MiniMessage.miniMessage().deserialize(message);
        component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(DEFAULT_URL_PATTERN).replacement(url -> url.clickEvent(ClickEvent.openUrl(url.content()))).build());
        return component;
    }

    public static Component reserializeToMinecraftBasedOnConfig(String discordMessage) {
        boolean enabled = DiscordSRV.config().getBoolean("Experiment_MCDiscordReserializer_ToMinecraft");
        if (enabled) {
            return MessageUtil.reserializeToMinecraft(discordMessage);
        }
        return LIMITED_MINECRAFT_SERIALIZER.serialize(discordMessage);
    }

    public static Component reserializeToMinecraft(String discordMessage) {
        return MINECRAFT_SERIALIZER.serialize(discordMessage);
    }

    public static String reserializeToDiscord(Component component) {
        return DiscordSerializer.INSTANCE.serialize(component);
    }

    public static String toMiniMessage(Component component) {
        return (String)MiniMessage.miniMessage().serialize(component);
    }

    public static String toLegacy(Component component) {
        if (!MC_1_16 && !PluginUtil.checkIfPluginEnabled("ViaVersion")) {
            GsonComponentSerializer serializer = GsonComponentSerializer.colorDownsamplingGson();
            component = serializer.deserialize((String)serializer.serialize(component));
        }
        return LEGACY_SERIALIZER.serialize(component);
    }

    public static String toPlain(Component component, boolean isLegacy) {
        return isLegacy ? MessageUtil.toLegacy(component) : MessageUtil.toMiniMessage(component);
    }

    public static String escapeMiniTokens(String plainMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = MINIMESSAGE_PATTERN.matcher(plainMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(plainMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
            String start = matcher.group("start");
            String token = matcher.group("token");
            String inner = matcher.group("inner");
            String end = matcher.group("end");
            if (inner != null) {
                token = token.replace(inner, MessageUtil.escapeMiniTokens(inner));
            }
            sb.append("\\").append(start).append(token).append(end);
        }
        if (plainMessage.length() > lastEnd) {
            sb.append(plainMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    public static void sendMessage(CommandSender commandSender, String plainMessage) {
        MessageUtil.sendMessage(Collections.singleton(commandSender), plainMessage);
    }

    public static void sendMessage(CommandSender commandSender, Component adventureMessage) {
        MessageUtil.sendMessage(Collections.singleton(commandSender), adventureMessage);
    }

    public static void sendMessage(Iterable<? extends CommandSender> commandSenders, String plainMessage) {
        MessageUtil.sendMessage(commandSenders, MessageUtil.toComponent(plainMessage));
    }

    public static void sendMessage(Iterable<? extends CommandSender> commandSenders, Component adventureMessage) {
        HashSet audiences = new HashSet();
        HashSet degradedAudiences = new HashSet();
        commandSenders.forEach(sender -> {
            Audience audience = MessageUtil.getAudiences().sender((CommandSender)sender);
            if (sender instanceof Player && DiscordSRV.getPlugin().getIncompatibleClientManager().isIncompatible((Player)sender)) {
                degradedAudiences.add(audience);
            } else {
                audiences.add(audience);
            }
        });
        try {
            if (!audiences.isEmpty()) {
                Audience.audience(audiences).sendMessage(adventureMessage);
            }
            if (!degradedAudiences.isEmpty()) {
                TextComponent degraded = LEGACY_SERIALIZER.deserialize(LEGACY_SERIALIZER.serialize(adventureMessage));
                Audience.audience(degradedAudiences).sendMessage(degraded);
            }
        }
        catch (NoClassDefFoundError e) {
            if (e.getMessage().equals("org/bukkit/command/ProxiedCommandSender")) {
                String legacy = MessageUtil.toLegacy(adventureMessage);
                commandSenders.forEach(sender -> sender.sendMessage(legacy));
                DiscordSRV.debug(e);
                return;
            }
            DiscordSRV.error(e);
        }
        catch (Throwable t) {
            DiscordSRV.error(t);
        }
    }

    public static String strip(String text) {
        return MessageUtil.stripLegacy(text);
    }

    public static String stripMiniTokens(String text) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = MINIMESSAGE_PATTERN.matcher(text);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(text, lastEnd, startIndex);
            }
            lastEnd = endIndex;
        }
        if (text.length() > lastEnd) {
            sb.append(text.substring(lastEnd));
        }
        return sb.toString();
    }

    public static String stripLegacy(String text) {
        if (StringUtils.isBlank(text)) {
            DiscordSRV.debug("Tried stripping blank message");
            return "";
        }
        return STRIP_PATTERN.matcher(text).replaceAll("");
    }

    public static String stripLegacySectionOnly(String text) {
        return STRIP_SECTION_ONLY_PATTERN.matcher(text).replaceAll("");
    }

    public static String translateLegacy(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = TRANSLATE_PATTERN.matcher(text);
        StringBuilder stringBuilder = new StringBuilder(text);
        while (matcher.find()) {
            stringBuilder.setCharAt(matcher.start(1), LEGACY_SECTION.charValue());
        }
        return stringBuilder.toString();
    }

    static {
        ArrayList<Rule<Object, Node<Object>, Object>> rules = new ArrayList<Rule<Object, Node<Object>, Object>>();
        rules.add(SimpleMarkdownRules.createEscapeRule());
        rules.addAll(DiscordMarkdownRules.createMentionRules());
        rules.add(DiscordMarkdownRules.createSpecialTextRule());
        MinecraftSerializerOptions<Component> options = MinecraftSerializerOptions.defaults().addRenderer(new DiscordSRVMinecraftRenderer());
        MinecraftSerializerOptions<String> escapeOptions = MinecraftSerializerOptions.escapeDefaults();
        MINECRAFT_SERIALIZER = new MinecraftSerializer(options, escapeOptions);
        LIMITED_MINECRAFT_SERIALIZER = new MinecraftSerializer(options.withRules(rules), escapeOptions);
        boolean available = false;
        try {
            Material.valueOf((String)"NETHERITE_PICKAXE").getKey();
            available = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MC_1_16 = available;
    }
}

