/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.codec.binary.Base64;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NMSUtil {
    private static final Pattern TEXTURE_URL_PATTERN = Pattern.compile("https?://.+?(?<texture>\\w{60,64})\"");
    protected static String versionPrefix = "";
    protected static boolean failed = false;
    protected static Class<?> class_CraftPlayer;
    protected static Class<?> class_GameProfile;
    protected static Class<?> class_GameProfileProperty;
    protected static Class<?> class_EntityPlayer;
    protected static Class<?> class_Advancement;
    protected static Method method_CraftPlayer_getHandle;
    protected static Method method_EntityPlayer_getGameProfile;
    protected static Method method_GameProfile_getProperties;
    protected static Method method_Advancement_getHandle;
    protected static Field field_PropertyMap_properties;
    protected static Field field_GameProfileProperty_value;

    public static Class<?> getClass(String className) {
        Class<?> result = null;
        try {
            result = NMSUtil.class.getClassLoader().loadClass(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Method getMethod(Class<?> methodClass, String methodName) {
        Method result = null;
        try {
            result = methodClass.getMethod(methodName, new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Class<?> fixBukkitClass(String className, String ... alternateClassNames) throws ClassNotFoundException {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add(className);
        classNames.addAll(Arrays.asList(alternateClassNames));
        for (String name : classNames) {
            try {
                return NMSUtil.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!versionPrefix.isEmpty()) {
                    name = name.replace("org.bukkit.craftbukkit.", "org.bukkit.craftbukkit." + versionPrefix);
                    name = name.replace("net.minecraft.server.", "net.minecraft.server." + versionPrefix);
                }
                try {
                    return NMSUtil.class.getClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
        }
        throw new ClassNotFoundException("Could not find " + className);
    }

    public static Object getHandle(Player player) {
        if (failed) {
            return null;
        }
        try {
            return method_CraftPlayer_getHandle.invoke((Object)player, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getGameProfile(Player player) {
        if (failed) {
            return null;
        }
        Object handle = NMSUtil.getHandle(player);
        if (handle != null) {
            try {
                return method_EntityPlayer_getGameProfile.invoke(handle, new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Object getTextureProperty(Object propertyMap) {
        if (failed) {
            return null;
        }
        try {
            Object multi = field_PropertyMap_properties.get(propertyMap);
            Iterator it = ((Iterable)multi.getClass().getMethod("get", Object.class).invoke(multi, "textures")).iterator();
            if (it.hasNext()) {
                return it.next();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getTexture(Player player) {
        if (failed) {
            return null;
        }
        try {
            String textureB64;
            String textureData;
            Matcher matcher;
            Object profile = NMSUtil.getGameProfile(player);
            if (profile == null) {
                return null;
            }
            Object propertyMap = method_GameProfile_getProperties.invoke(profile, new Object[0]);
            Object textureProperty = NMSUtil.getTextureProperty(propertyMap);
            if (textureProperty != null && (matcher = TEXTURE_URL_PATTERN.matcher(textureData = new String(Base64.decodeBase64(textureB64 = (String)field_GameProfileProperty_value.get(textureProperty))))).find()) {
                return matcher.group("texture");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getHandle(Object advancement) {
        if (failed || method_Advancement_getHandle == null) {
            return null;
        }
        try {
            return method_Advancement_getHandle.invoke(advancement, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        String className = Bukkit.getServer().getClass().getName();
        String[] packages = className.split("\\.");
        if (packages.length == 5) {
            versionPrefix = packages[3] + ".";
        }
        try {
            class_EntityPlayer = NMSUtil.fixBukkitClass("net.minecraft.server.EntityPlayer", "net.minecraft.server.level.EntityPlayer", "net.minecraft.server.level.ServerPlayer");
            try {
                method_EntityPlayer_getGameProfile = class_EntityPlayer.getMethod("getProfile", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    method_EntityPlayer_getGameProfile = class_EntityPlayer.getMethod("getGameProfile", new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    method_EntityPlayer_getGameProfile = Arrays.stream(class_EntityPlayer.getMethods()).filter(method -> method.getReturnType().getSimpleName().equals("GameProfile")).findFirst().orElseThrow(() -> new RuntimeException("Couldn't find the GameProfile method"));
                }
            }
            try {
                class_Advancement = NMSUtil.fixBukkitClass("org.bukkit.craftbukkit.advancement.CraftAdvancement", new String[0]);
                method_Advancement_getHandle = class_Advancement.getMethod("getHandle", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            class_CraftPlayer = NMSUtil.fixBukkitClass("org.bukkit.craftbukkit.entity.CraftPlayer", new String[0]);
            method_CraftPlayer_getHandle = class_CraftPlayer.getMethod("getHandle", new Class[0]);
            class_GameProfile = NMSUtil.getClass("com.mojang.authlib.GameProfile");
            class_GameProfileProperty = NMSUtil.getClass("com.mojang.authlib.properties.Property");
            if (class_GameProfile == null) {
                class_GameProfile = NMSUtil.getClass("net.minecraft.util.com.mojang.authlib.GameProfile");
                class_GameProfileProperty = NMSUtil.getClass("net.minecraft.util.com.mojang.authlib.properties.Property");
            }
            if ((method_GameProfile_getProperties = NMSUtil.getMethod(class_GameProfile, "getProperties")) == null) {
                method_GameProfile_getProperties = NMSUtil.getMethod(class_GameProfile, "properties");
            }
            field_GameProfileProperty_value = class_GameProfileProperty.getDeclaredField("value");
            field_GameProfileProperty_value.setAccessible(true);
            field_PropertyMap_properties = method_GameProfile_getProperties.getReturnType().getDeclaredField("properties");
            field_PropertyMap_properties.setAccessible(true);
        }
        catch (Throwable e) {
            DiscordSRV.debug(Debug.UNCATEGORIZED, "Failed to generate NMS classes, methods, and fields.");
            e.printStackTrace();
            failed = true;
        }
    }
}

