/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.SpELExpressionBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public abstract class NamedValueFormatter {
    private static final Pattern PATTERN = Pattern.compile("\\\\([^\\\\])|\\{(.+?)}");
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\\\([^\\\\])|\\$\\{(.+?)}");

    public static String format(String format, Pattern pattern, Function<String, Object> replacer) {
        Matcher matcher = pattern.matcher(format);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(2);
            matcher.appendReplacement(result, key != null ? Objects.toString(replacer.apply(key)) : matcher.group(1));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String format(String format, Function<String, Object> replacer) {
        return NamedValueFormatter.format(format, PATTERN, replacer);
    }

    public static String formatExpressions(String format, Object root) {
        return NamedValueFormatter.format(format, EXPRESSION_PATTERN, (String expression) -> new SpELExpressionBuilder((String)expression).withPluginVariables().withVariable("server", Bukkit.getServer()).withVariable("discordsrv", (Object)DiscordSRV.getPlugin()).withVariable("jda", DiscordUtil.getJda()).evaluate(root));
    }

    public static String formatExpressions(String format, Object root, Map<String, Object> variables) {
        return NamedValueFormatter.format(format, EXPRESSION_PATTERN, (String expression) -> new SpELExpressionBuilder((String)expression).withPluginVariables().withVariable("server", Bukkit.getServer()).withVariable("discordsrv", (Object)DiscordSRV.getPlugin()).withVariable("jda", DiscordUtil.getJda()).withVariables(variables).evaluate(root));
    }

    public static String format(String format, Map<String, Object> values) {
        return NamedValueFormatter.format(format, (String key) -> values.getOrDefault(key, "{" + key + "}"));
    }

    public static String format(String format, Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("Non-even number of objects supplied");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i].toString(), objects[i + 1]);
        }
        return NamedValueFormatter.format(format, map);
    }
}

