/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.util.DiscordChatChannelCommandFeedbackForwarder;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;

public class PaperForwardingCommandSender {
    private final DiscordSRV plugin = DiscordSRV.getPlugin();
    private final CommandSender feedbackSender = this.createCommandSender();
    private final DiscordChatChannelCommandFeedbackForwarder sendUtil;

    public static boolean isSenderExists() {
        try {
            Class.forName("io.papermc.paper.commands.FeedbackForwardingSender");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public PaperForwardingCommandSender(GuildMessageReceivedEvent event) {
        this.sendUtil = new DiscordChatChannelCommandFeedbackForwarder(event);
    }

    private CommandSender createCommandSender() {
        try {
            Class serverClass = this.plugin.getServer().getClass();
            Method createCommandSenderMethod = serverClass.getMethod("createCommandSender", Consumer.class);
            Consumer<Object> serializerFunction = this::processComponent;
            return (CommandSender)createCommandSenderMethod.invoke((Object)this.plugin.getServer(), serializerFunction);
        }
        catch (Throwable e) {
            DiscordSRV.error("Error creating commandSender", e);
            return null;
        }
    }

    private void processComponent(Object component) {
        try {
            Class<?> serializerInterface = Class.forName(this.dot("net{}kyori{}adventure{}text{}serializer{}plain{}PlainTextComponentSerializer"));
            Class<?> componentInterface = Class.forName(this.dot("net{}kyori{}adventure{}text{}Component"));
            Method plainTextMethod = serializerInterface.getMethod("plainText", new Class[0]);
            Method serializeMethod = serializerInterface.getMethod("serialize", componentInterface);
            Object serializerInstance = plainTextMethod.invoke(null, new Object[0]);
            this.sendUtil.send((String)serializeMethod.invoke(serializerInstance, component));
        }
        catch (Throwable e) {
            DiscordSRV.error("Error serializing non-relocated component to String", e);
        }
    }

    private String dot(String str) {
        return str.replace("{}", ".");
    }

    public CommandSender getFeedbackSender() {
        return this.feedbackSender;
    }
}

