/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.objects.Lag;
import github.scarsz.discordsrv.util.MemUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderUtil {
    private PlaceholderUtil() {
    }

    public static String replacePlaceholders(String input) {
        return PlaceholderUtil.replacePlaceholders(input, null);
    }

    public static String replacePlaceholders(String input, OfflinePlayer player) {
        if (input == null) {
            return null;
        }
        if (PluginUtil.pluginHookIsEnabled("placeholderapi")) {
            Player onlinePlayer = player != null ? player.getPlayer() : null;
            input = PlaceholderAPI.setPlaceholders((OfflinePlayer)(onlinePlayer != null ? onlinePlayer : player), (String)input);
        }
        return input;
    }

    public static String replacePlaceholdersToDiscord(String input) {
        return PlaceholderUtil.replacePlaceholdersToDiscord(input, null);
    }

    public static String replacePlaceholdersToDiscord(String input, OfflinePlayer player) {
        boolean placeholderapi = PluginUtil.pluginHookIsEnabled("placeholderapi");
        if (placeholderapi) {
            input = input.replace("&", "&\u200b");
        }
        input = PlaceholderUtil.replacePlaceholders(input, player);
        if (placeholderapi) {
            input = MessageUtil.stripLegacy(input);
            input = input.replace("&\u200b", "&");
        }
        return input;
    }

    public static String replaceChannelUpdaterPlaceholders(String input) {
        if (StringUtils.isBlank(input)) {
            return "";
        }
        input = PlaceholderUtil.replacePlaceholdersToDiscord(input);
        HashMap<String, String> mem = MemUtil.get();
        input = input.replaceAll("%time%|%date%", PlaceholderUtil.notNull(TimeUtil.timeStamp())).replace("%playercount%", PlaceholderUtil.notNull(Integer.toString(PlayerUtil.getOnlinePlayers(true).size()))).replace("%playermax%", PlaceholderUtil.notNull(Integer.toString(Bukkit.getMaxPlayers()))).replace("%totalplayers%", PlaceholderUtil.notNull(Integer.toString(DiscordSRV.getTotalPlayerCount()))).replace("%uptimemins%", PlaceholderUtil.notNull(Long.toString(TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - DiscordSRV.getPlugin().getStartTime())))).replace("%uptimehours%", PlaceholderUtil.notNull(Long.toString(TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - DiscordSRV.getPlugin().getStartTime())))).replace("%uptimedays%", PlaceholderUtil.notNull(Long.toString(TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - DiscordSRV.getPlugin().getStartTime())))).replace("%timestamp%", PlaceholderUtil.notNull(Long.toString(System.currentTimeMillis() / 1000L))).replace("%starttimestamp%", PlaceholderUtil.notNull(Long.toString(TimeUnit.MILLISECONDS.toSeconds(DiscordSRV.getPlugin().getStartTime())))).replace("%motd%", PlaceholderUtil.notNull(StringUtils.isNotBlank(Bukkit.getMotd()) ? MessageUtil.strip(Bukkit.getMotd()) : "")).replace("%serverversion%", PlaceholderUtil.notNull(Bukkit.getBukkitVersion())).replace("%freememory%", PlaceholderUtil.notNull(mem.get("freeMB"))).replace("%usedmemory%", PlaceholderUtil.notNull(mem.get("usedMB"))).replace("%totalmemory%", PlaceholderUtil.notNull(mem.get("totalMB"))).replace("%maxmemory%", PlaceholderUtil.notNull(mem.get("maxMB"))).replace("%freememorygb%", PlaceholderUtil.notNull(mem.get("freeGB"))).replace("%usedmemorygb%", PlaceholderUtil.notNull(mem.get("usedGB"))).replace("%totalmemorygb%", PlaceholderUtil.notNull(mem.get("totalGB"))).replace("%maxmemorygb%", PlaceholderUtil.notNull(mem.get("maxGB"))).replace("%tps%", PlaceholderUtil.notNull(Lag.getTPSString()));
        return input;
    }

    public static String notNull(Object object) {
        return object != null ? object.toString() : "";
    }
}

