/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.hooks.PluginHook;
import github.scarsz.discordsrv.hooks.vanish.VanishHook;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerUtil {
    private static Sound notificationSound = null;
    private static final List<Character> VANILLA_TARGET_SELECTORS;

    public static List<Player> getOnlinePlayers() {
        return PlayerUtil.getOnlinePlayers(false);
    }

    public static List<Player> getOnlinePlayers(boolean filterVanishedPlayers) {
        ArrayList<Player> onlinePlayers = new ArrayList<Player>();
        try {
            Method onlinePlayerMethod = Server.class.getMethod("getOnlinePlayers", new Class[0]);
            if (onlinePlayerMethod.getReturnType().equals(Collection.class)) {
                for (Object o : (Collection)onlinePlayerMethod.invoke((Object)Bukkit.getServer(), new Object[0])) {
                    onlinePlayers.add((Player)o);
                }
            } else {
                Collections.addAll(onlinePlayers, (Player[])onlinePlayerMethod.invoke((Object)Bukkit.getServer(), new Object[0]));
            }
        }
        catch (Exception e) {
            DiscordSRV.error(e);
        }
        if (!filterVanishedPlayers) {
            return onlinePlayers;
        }
        return onlinePlayers.stream().filter(player -> !PlayerUtil.isVanished(player)).collect(Collectors.toList());
    }

    private static Sound getNotificationSound_modern() throws Throwable {
        Object key = Class.forName("org.bukkit.NamespacedKey").getMethod("minecraft", String.class).invoke(null, "block.note_block.pling");
        Object soundRegistry = Class.forName("org.bukkit.Registry").getField("SOUNDS").get(null);
        Object sound = soundRegistry.getClass().getMethod("get", key.getClass()).invoke(soundRegistry, key);
        return (Sound)sound;
    }

    private static Sound getNotificationSound_legacy() throws Throwable {
        Class<?> soundClass = Class.forName("org.bukkit.Sound");
        if (!soundClass.isEnum()) {
            throw new IllegalStateException("Sound is not an enum");
        }
        for (Object s : soundClass.getEnumConstants()) {
            Sound sound = (Sound)s;
            if (!sound.name().contains("_PLING")) continue;
            return sound;
        }
        return null;
    }

    public static void notifyPlayersOfMentions(Predicate<? super Player> predicate, String message) {
        if (notificationSound == null) {
            return;
        }
        if (predicate == null) {
            predicate = Objects::nonNull;
        }
        if (!DiscordSRV.config().getBoolean("MinecraftMentionSound")) {
            return;
        }
        if (StringUtils.isBlank(message)) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Tried notifying players with null or blank message");
            return;
        }
        List splitMessage = Arrays.stream(MessageUtil.strip(message).replaceAll("[^a-zA-Z0-9_@]", " ").split(" ")).filter(StringUtils::isNotBlank).map(String::toLowerCase).map(s -> {
            String possibleId = s.replace("<@", "").replace(">", "");
            if (StringUtils.isNotBlank(possibleId) && StringUtils.isNumeric(possibleId) && s.startsWith("<@") && s.endsWith(">")) {
                User possibleUser = DiscordUtil.getUserById(possibleId);
                if (possibleUser == null) {
                    return s;
                }
                return "@" + DiscordSRV.getPlugin().getMainGuild().getMember(possibleUser).getEffectiveName();
            }
            return s;
        }).collect(Collectors.toList());
        PlayerUtil.getOnlinePlayers().stream().filter(predicate).filter(player -> splitMessage.contains("@" + player.getName().toLowerCase()) || splitMessage.contains("@" + MessageUtil.strip(player.getDisplayName().toLowerCase()))).forEach(player -> player.playSound(player.getLocation(), notificationSound, 1.0f, 1.0f));
    }

    public static boolean isVanished(Player player) {
        for (PluginHook pluginHook : DiscordSRV.getPlugin().getPluginHooks()) {
            if (!(pluginHook instanceof VanishHook) || !((VanishHook)pluginHook).isVanished(player)) continue;
            return true;
        }
        return false;
    }

    public static int getPing(Player player) {
        try {
            Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            return (Integer)entityPlayer.getClass().getField("ping").get(entityPlayer);
        }
        catch (Exception e) {
            DiscordSRV.error(e);
            return -1;
        }
    }

    public static String convertTargetSelectors(String message, CommandSender sender) {
        for (int i = 0; i < message.length(); ++i) {
            int end;
            if (message.charAt(i) != '@' || (end = PlayerUtil.getSelectorEnd(message, i)) < 0 || end + 1 < message.length() && !PlayerUtil.canSeparateSelectors(message.charAt(end + 1))) continue;
            String selector = message.substring(i, end + 1);
            try {
                String target = sender == null ? "{TARGET}" : sender.getServer().selectEntities(sender, selector).stream().map(CommandSender::getName).collect(Collectors.joining(" "));
                message = message.substring(0, i) + target + message.substring(end + 1);
                i += target.length() - 1;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return message;
    }

    private static int getSelectorEnd(String message, int start) {
        int end = start + 1;
        if (end >= message.length() || !VANILLA_TARGET_SELECTORS.contains(Character.valueOf(message.charAt(end)))) {
            return -1;
        }
        int argsPos = start + 2;
        if (argsPos < message.length() && message.charAt(argsPos) == '[') {
            for (int i = argsPos + 1; i < message.length(); ++i) {
                char current = message.charAt(i);
                if (current == '[' || Character.isWhitespace(current)) {
                    return -1;
                }
                if (current != ']') continue;
                return i;
            }
            return -1;
        }
        return end;
    }

    private static boolean canSeparateSelectors(char character) {
        return Character.isWhitespace(character) || character == '@';
    }

    public static boolean uuidIsOffline(UUID uuid) {
        return uuid.version() == 3;
    }

    static {
        try {
            notificationSound = PlayerUtil.getNotificationSound_modern();
        }
        catch (Throwable e) {
            try {
                notificationSound = PlayerUtil.getNotificationSound_legacy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (notificationSound == null) {
            System.err.println("Failed to get notification sound, chat notification sounds will not function properly");
        }
        VANILLA_TARGET_SELECTORS = Arrays.asList(Character.valueOf('p'), Character.valueOf('r'), Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('s'));
    }
}

