/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PluginUtil {
    public static void unloadPlugin(Plugin plugin) {
        ClassLoader cl;
        String name = plugin.getName();
        PluginManager pluginManager = Bukkit.getPluginManager();
        SimpleCommandMap commandMap = null;
        List plugins = null;
        Map names = null;
        Map commands = null;
        Map listeners = null;
        boolean reloadListeners = true;
        pluginManager.disablePlugin(plugin);
        try {
            Field pluginsField = Bukkit.getPluginManager().getClass().getDeclaredField("plugins");
            pluginsField.setAccessible(true);
            plugins = (List)pluginsField.get(pluginManager);
            Field lookupNamesField = Bukkit.getPluginManager().getClass().getDeclaredField("lookupNames");
            lookupNamesField.setAccessible(true);
            names = (Map)lookupNamesField.get(pluginManager);
            try {
                Field listenersField = Bukkit.getPluginManager().getClass().getDeclaredField("listeners");
                listenersField.setAccessible(true);
                listeners = (Map)listenersField.get(pluginManager);
            }
            catch (Exception e) {
                reloadListeners = false;
            }
            Field commandMapField = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            commandMap = (SimpleCommandMap)commandMapField.get(pluginManager);
            Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            commands = (Map)knownCommandsField.get(commandMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            DiscordSRV.error(e);
        }
        pluginManager.disablePlugin(plugin);
        if (plugins != null && plugins.contains(plugin)) {
            plugins.remove(plugin);
        }
        if (names != null && names.containsKey(name)) {
            names.remove(name);
        }
        if (listeners != null && reloadListeners) {
            for (SortedSet set : listeners.values()) {
                set.removeIf(value -> value.getPlugin() == plugin);
            }
        }
        if (commandMap != null) {
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                PluginCommand c;
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof PluginCommand) || (c = (PluginCommand)entry.getValue()).getPlugin() != plugin) continue;
                c.unregister(commandMap);
                it.remove();
            }
        }
        if ((cl = plugin.getClass().getClassLoader()) instanceof URLClassLoader) {
            try {
                ((URLClassLoader)cl).close();
            }
            catch (IOException ex) {
                Logger.getLogger(PluginUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.gc();
    }

    public static boolean checkIfPluginEnabled(String pluginName) {
        Plugin plugin = PluginUtil.getPlugin(pluginName);
        if (plugin == null) {
            return false;
        }
        if (plugin.isEnabled()) {
            return true;
        }
        DiscordSRV.debug("Plugin " + plugin.getName() + " found but wasn't enabled. Returning false");
        return false;
    }

    @Deprecated
    public static boolean checkIfPluginEnabled(String pluginName, boolean startsWith) {
        return PluginUtil.checkIfPluginEnabled(pluginName);
    }

    public static boolean pluginHookIsEnabled(String pluginName) {
        boolean enabled = PluginUtil.checkIfPluginEnabled(pluginName);
        for (String pluginHookName : DiscordSRV.config().getStringList("DisabledPluginHooks")) {
            if (!pluginName.toLowerCase().startsWith(pluginHookName.toLowerCase())) continue;
            enabled = false;
            break;
        }
        return enabled;
    }

    @Deprecated
    public static boolean pluginHookIsEnabled(String pluginName, boolean startsWith) {
        return PluginUtil.pluginHookIsEnabled(pluginName);
    }

    public static Plugin getPlugin(String pluginName) {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!plugin.getName().equalsIgnoreCase(pluginName)) continue;
            return plugin;
        }
        return null;
    }
}

