/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.util.MessageUtil;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PrettyUtil {
    public static String beautify(User user) {
        return PrettyUtil.beautify(user, "<Unknown>", true);
    }

    public static String beautify(User user, String noUsernameFormat, boolean includeId) {
        if (user == null) {
            return noUsernameFormat;
        }
        Member member = DiscordSRV.getPlugin().getMainGuild().getMember(user);
        return member != null ? member.getEffectiveName() + (includeId ? " (#" + user.getId() + ")" : "") : user.getName() + (includeId ? " (#" + user.getId() + ")" : "");
    }

    public static String beautifyUsername(OfflinePlayer player) {
        return PrettyUtil.beautifyUsername(player, "<Unknown>", true);
    }

    public static String beautifyUsername(OfflinePlayer player, String noUsernameFormat, boolean includeUuid) {
        Player onlinePlayer;
        if (player == null) {
            return noUsernameFormat;
        }
        String name = player.getName();
        if (name == null && player.isOnline() && (onlinePlayer = player.getPlayer()) != null) {
            name = onlinePlayer.getName();
        }
        return (name != null ? name : noUsernameFormat) + (includeUuid ? " (" + player.getUniqueId() + ")" : "");
    }

    public static String beautifyNickname(OfflinePlayer player) {
        return PrettyUtil.beautifyNickname(player, "<Unknown>", true);
    }

    public static String beautifyNickname(OfflinePlayer player, String noUsernameFormat, boolean includeUuid) {
        if (player == null || player.getName() == null) {
            return noUsernameFormat;
        }
        if (player.isOnline()) {
            if (player.getPlayer() == null) {
                return PrettyUtil.beautifyUsername(player);
            }
            String displayName = player.getPlayer().getDisplayName();
            if (StringUtils.isBlank(displayName)) {
                return PrettyUtil.beautifyUsername(player);
            }
            return MessageUtil.strip(displayName) + (includeUuid ? " (" + player.getUniqueId() + ")" : "");
        }
        return PrettyUtil.beautifyUsername(player);
    }

    public static String beautify(Enum<?> achievement) {
        if (achievement == null) {
            return "<\u2717>";
        }
        return Arrays.stream(achievement.name().toLowerCase().split("_")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
    }

    public static String beautify(StackTraceElement[] stackTraceElements) {
        return Arrays.stream(stackTraceElements).map(stackTraceElement -> "\t" + stackTraceElement.toString()).skip(1L).collect(Collectors.joining("\n"));
    }
}

