/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SQLUtil {
    public static void createDatabaseIfNotExists(Connection connection, String database) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("CREATE DATABASE IF NOT EXISTS `" + database + "`");){
            statement.executeUpdate();
        }
    }

    public static boolean checkIfTableExists(Connection connection, String table) {
        boolean tableExists;
        block8: {
            tableExists = false;
            try (PreparedStatement statement = connection.prepareStatement("SELECT 1 FROM " + table + " LIMIT 1");){
                statement.executeQuery();
                tableExists = true;
            }
            catch (SQLException e) {
                if (e.getMessage().contains("doesn't exist")) break block8;
                DiscordSRV.error(e);
            }
        }
        return tableExists;
    }

    public static Map<String, String> getTableColumns(Connection connection, String table) throws SQLException {
        HashMap<String, String> columns = new HashMap<String, String>();
        try (PreparedStatement statement = connection.prepareStatement("SHOW COLUMNS FROM " + table);){
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                columns.put(result.getString("Field"), result.getString("Type"));
            }
        }
        return columns;
    }

    public static boolean checkIfTableMatchesStructure(Connection connection, String table, Map<String, String> expectedColumns) throws SQLException {
        return SQLUtil.checkIfTableMatchesStructure(connection, table, expectedColumns, true);
    }

    public static boolean checkIfTableMatchesStructure(Connection connection, String table, Map<String, String> expectedColumns, boolean showErrors) throws SQLException {
        LinkedList<String> found = new LinkedList<String>();
        for (Map.Entry<String, String> entry : SQLUtil.getTableColumns(connection, table).entrySet()) {
            String actualType;
            if (!expectedColumns.containsKey(entry.getKey())) continue;
            String expectedType = expectedColumns.get(entry.getKey());
            if (!expectedType.equals(actualType = entry.getValue())) {
                if (showErrors) {
                    DiscordSRV.error("Expected type " + expectedType + " for column " + entry.getKey() + ", got " + actualType);
                }
                return false;
            }
            found.add(entry.getKey());
        }
        return found.containsAll(expectedColumns.keySet());
    }
}

