/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SchedulerUtil {
    private static Boolean IS_FOLIA = null;
    private static Object GLOBAL_REGION_SCHEDULER = null;
    private static Object ASYNC_SCHEDULER = null;

    public static <T> T callMethod(Class<?> clazz, Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            return (T)clazz.getDeclaredMethod(methodName, parameterTypes).invoke(object, args);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public static <T> T callMethod(Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        return SchedulerUtil.callMethod(object.getClass(), object, methodName, parameterTypes, args);
    }

    public static <T> T callMethod(Object object, String methodName) {
        return SchedulerUtil.callMethod(object.getClass(), null, methodName, new Class[0], new Object[0]);
    }

    public static <T> T callMethod(Class<?> clazz, String methodName) {
        return SchedulerUtil.callMethod(clazz, null, methodName, new Class[0], new Object[0]);
    }

    private static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Boolean isFolia() {
        if (IS_FOLIA == null) {
            IS_FOLIA = SchedulerUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer");
        }
        return IS_FOLIA;
    }

    public static Object getGlobalRegionScheduler() {
        if (GLOBAL_REGION_SCHEDULER == null) {
            GLOBAL_REGION_SCHEDULER = SchedulerUtil.callMethod(Bukkit.class, "getGlobalRegionScheduler");
        }
        return GLOBAL_REGION_SCHEDULER;
    }

    public static Object getAsyncScheduler() {
        if (ASYNC_SCHEDULER == null) {
            ASYNC_SCHEDULER = SchedulerUtil.callMethod(Bukkit.class, "getAsyncScheduler");
        }
        return ASYNC_SCHEDULER;
    }

    public static void runTask(Plugin plugin, Runnable runnable) {
        if (SchedulerUtil.isFolia().booleanValue()) {
            Object globalRegionScheduler = SchedulerUtil.getGlobalRegionScheduler();
            SchedulerUtil.callMethod(globalRegionScheduler, "run", new Class[]{Plugin.class, Consumer.class}, plugin, task -> runnable.run());
            return;
        }
        Bukkit.getScheduler().runTask(plugin, runnable);
    }

    public static void runTaskAsynchronously(Plugin plugin, Runnable runnable) {
        if (SchedulerUtil.isFolia().booleanValue()) {
            Object asyncScheduler = SchedulerUtil.getAsyncScheduler();
            SchedulerUtil.callMethod(asyncScheduler, "runNow", new Class[]{Plugin.class, Consumer.class}, plugin, task -> runnable.run());
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(plugin, runnable);
    }

    public static void runTaskTimerAsynchronously(Plugin plugin, Runnable runnable, long initialDelayTicks, long periodTicks) {
        if (SchedulerUtil.isFolia().booleanValue()) {
            Object asyncScheduler = SchedulerUtil.getAsyncScheduler();
            SchedulerUtil.callMethod(asyncScheduler, "runAtFixedRate", new Class[]{Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class}, new Object[]{plugin, task -> runnable.run(), initialDelayTicks, periodTicks * 50L, TimeUnit.MILLISECONDS});
            return;
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, runnable, initialDelayTicks, periodTicks);
    }

    public static void runTaskLater(Plugin plugin, Runnable runnable, long delayedTicks) {
        if (SchedulerUtil.isFolia().booleanValue()) {
            Object globalRegionScheduler = SchedulerUtil.getGlobalRegionScheduler();
            SchedulerUtil.callMethod(globalRegionScheduler, "runDelayed", new Class[]{Plugin.class, Consumer.class, Long.TYPE}, plugin, task -> runnable.run(), delayedTicks);
            return;
        }
        Bukkit.getScheduler().runTaskLater(plugin, runnable, delayedTicks);
    }

    public static void runTaskLaterAsynchronously(Plugin plugin, Runnable runnable, long delayedTicks) {
        if (SchedulerUtil.isFolia().booleanValue()) {
            Object asyncScheduler = SchedulerUtil.callMethod(Bukkit.class, "getAsyncScheduler");
            SchedulerUtil.callMethod(asyncScheduler, "runDelayed", new Class[]{Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class}, new Object[]{plugin, task -> runnable.run(), delayedTicks * 50L, TimeUnit.MILLISECONDS});
            return;
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, runnable, delayedTicks);
    }

    public static void runTaskForPlayer(Plugin plugin, Player player, Runnable runnable) {
        if (SchedulerUtil.isFolia().booleanValue()) {
            Object entityScheduler = SchedulerUtil.callMethod(player, "getScheduler");
            SchedulerUtil.callMethod(entityScheduler, "run", new Class[]{Plugin.class, Consumer.class, Runnable.class}, plugin, task -> runnable.run(), null);
            return;
        }
        Bukkit.getScheduler().runTask(plugin, runnable);
    }

    public static void cancelTasks(Plugin plugin) {
        if (SchedulerUtil.isFolia().booleanValue()) {
            Object asyncScheduler = SchedulerUtil.getAsyncScheduler();
            Object globalRegionScheduler = SchedulerUtil.getGlobalRegionScheduler();
            SchedulerUtil.callMethod(asyncScheduler, "cancelTasks", new Class[]{Plugin.class}, plugin);
            SchedulerUtil.callMethod(globalRegionScheduler, "cancelTasks", new Class[]{Plugin.class}, plugin);
            return;
        }
        Bukkit.getScheduler().cancelTasks(plugin);
    }
}

