/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpELExpressionBuilder {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final String expression;
    private final Map<String, Object> variables = new HashMap<String, Object>();

    public SpELExpressionBuilder(String expression) {
        this.expression = expression;
    }

    public SpELExpressionBuilder withVariable(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public SpELExpressionBuilder withVariables(Map<String, Object> variables) {
        this.variables.putAll(variables);
        return this;
    }

    public SpELExpressionBuilder withPluginVariables() {
        this.variables.put("plugins", Arrays.stream(Bukkit.getPluginManager().getPlugins()).collect(Collectors.toMap(Plugin::getName, plugin -> plugin)));
        return this;
    }

    public <T> T evaluate(Object root) {
        return (T)this.evaluate(root, Object.class);
    }

    public <T> T evaluate(Object root, Class<T> desiredType) throws ParseException, SpelEvaluationException {
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.setVariables(this.variables);
        return PARSER.parseExpression(this.expression).getValue((EvaluationContext)context, desiredType);
    }
}

