/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    private static final Date date = new Date();
    private static final SimpleDateFormat timestampFormat = new SimpleDateFormat(DiscordSRV.config().getOptionalString("TimestampFormat").orElse("EEE, d. MMM yyyy HH:mm:ss z"));
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat(DiscordSRV.config().getOptionalString("DateFormat").orElse("yyyy-MM-dd"));
    private static final SimpleDateFormat consoleTimeFormat = new SimpleDateFormat(DiscordSRV.config().getOptionalString("DiscordConsoleChannelTimestampFormat").orElse("EEE HH:mm:ss"));
    private static final TimeZone zone;

    public static String format(String format) {
        return TimeUtil.format(new SimpleDateFormat(format));
    }

    public static String format(long time) {
        return TimeUtil.format(time, timestampFormat);
    }

    public static String format(SimpleDateFormat format) {
        return TimeUtil.format(System.currentTimeMillis(), format);
    }

    public static String format(long timestamp, SimpleDateFormat format) {
        date.setTime(timestamp);
        return format.format(date);
    }

    public static String date() {
        return TimeUtil.format(dateFormat);
    }

    public static String timeStamp() {
        return TimeUtil.format(timestampFormat);
    }

    public static String consoleTimeStamp() {
        return TimeUtil.format(System.currentTimeMillis());
    }

    public static String consoleTimeStamp(long timestamp) {
        return TimeUtil.format(timestamp, consoleTimeFormat);
    }

    static {
        String timezone = DiscordSRV.config().getOptionalString("Timezone").orElse("default");
        zone = timezone.equalsIgnoreCase("default") ? TimeZone.getDefault() : TimeZone.getTimeZone(timezone);
        timestampFormat.setTimeZone(zone);
        dateFormat.setTimeZone(zone);
        consoleTimeFormat.setTimeZone(zone);
    }
}

