/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.google.gson.JsonElement;
import github.scarsz.discordsrv.dependencies.google.gson.JsonObject;
import github.scarsz.discordsrv.util.HttpUtil;
import github.scarsz.discordsrv.util.ManifestUtil;

public class UpdateUtil {
    public static boolean checkForUpdates() {
        return UpdateUtil.checkForUpdates(true);
    }

    public static boolean checkForUpdates(boolean verbose) {
        JsonObject jsonObject = null;
        try {
            String buildHash = ManifestUtil.getManifestValue("Git-Revision");
            if (buildHash == null || buildHash.equalsIgnoreCase("unknown") || buildHash.length() != 40) {
                DiscordSRV.warning("Git-Revision wasn't available, plugin is a dev build");
                DiscordSRV.warning("You will receive no support for this plugin version.");
                return false;
            }
            String minimumHash = HttpUtil.requestHttp("https://raw.githubusercontent.com/DiscordSRV/DiscordSRV/randomaccessfiles/minimumbuild").trim();
            if (minimumHash.length() == 40) {
                jsonObject = DiscordSRV.getPlugin().getGson().fromJson(HttpUtil.requestHttp("https://api.github.com/repos/DiscordSRV/DiscordSRV/compare/" + minimumHash + "..." + buildHash + "?per_page=1"), JsonObject.class);
                JsonObject minimumComparisonResult = jsonObject;
                JsonElement status = minimumComparisonResult.get("status");
                if (status == null) {
                    return false;
                }
                boolean minimumAhead = status.getAsString().equalsIgnoreCase("behind");
                if (minimumAhead) {
                    UpdateUtil.printUpdateMessage("The current build of DiscordSRV does not meet the minimum required to be secure! DiscordSRV will not start.");
                    DiscordSRV.getPlugin().disablePlugin();
                    return true;
                }
            } else {
                DiscordSRV.warning("Failed to check against minimum version of DiscordSRV: received minimum build was not 40 characters long & thus not a commit hash");
            }
            JsonObject masterComparisonResult = jsonObject = DiscordSRV.getPlugin().getGson().fromJson(HttpUtil.requestHttp("https://api.github.com/repos/DiscordSRV/DiscordSRV/compare/master..." + buildHash + "?per_page=1"), JsonObject.class);
            String masterStatus = masterComparisonResult.get("status").getAsString();
            switch (masterStatus.toLowerCase()) {
                case "ahead": 
                case "diverged": {
                    if (!verbose) {
                        return false;
                    }
                    JsonObject developComparisonResult = jsonObject = DiscordSRV.getPlugin().getGson().fromJson(HttpUtil.requestHttp("https://api.github.com/repos/DiscordSRV/DiscordSRV/compare/develop..." + buildHash + "?per_page=1"), JsonObject.class);
                    String developStatus = developComparisonResult.get("status").getAsString();
                    switch (developStatus.toLowerCase()) {
                        case "ahead": {
                            DiscordSRV.info("This build of DiscordSRV is ahead of master and develop. [latest private dev build]");
                            return false;
                        }
                        case "identical": {
                            DiscordSRV.info("This build of DiscordSRV is identical to develop. [latest public dev build]");
                            return false;
                        }
                        case "behind": {
                            DiscordSRV.warning("This build of DiscordSRV is ahead of master but behind develop. Update your development build!");
                            return true;
                        }
                    }
                    return false;
                }
                case "behind": {
                    jsonObject = masterComparisonResult;
                    UpdateUtil.printUpdateMessage("The current build of DiscordSRV is outdated by " + masterComparisonResult.get("behind_by").getAsInt() + " commits!");
                    return true;
                }
                case "identical": {
                    if (verbose) {
                        DiscordSRV.info("DiscordSRV is up-to-date. (" + buildHash + ")");
                    }
                    return false;
                }
            }
            DiscordSRV.warning("Got weird build comparison status from GitHub: " + masterStatus + ". Assuming plugin is up-to-date.");
            return false;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                if (e.getMessage().contains("google.gson") && jsonObject != null) {
                    try {
                        jsonObject.remove("files");
                        jsonObject.remove("commits");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    DiscordSRV.warning("Update check failed due to unexpected json response: " + e.getMessage() + " (" + jsonObject + ")");
                } else {
                    DiscordSRV.warning("Update check failed: " + e.getMessage());
                }
            } else {
                DiscordSRV.warning("Update check failed: " + e.getClass().getName());
            }
            DiscordSRV.debug(e);
            return false;
        }
    }

    private static void printUpdateMessage(String explanation) {
        DiscordSRV.warning("\n\n" + explanation + " Get the latest build at your favorite distribution center.\n\nModrinth: https://modrinth.com/plugin/discordsrv/\nGithub: https://github.com/DiscordSRV/DiscordSRV/releases/\nDirect Download: https://get.discordsrv.com/\n");
    }
}

