/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Webhook;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ActionRow;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.MessageAction;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.BufferedRequestBody;
import github.scarsz.discordsrv.dependencies.json.JSONArray;
import github.scarsz.discordsrv.dependencies.json.JSONObject;
import github.scarsz.discordsrv.dependencies.okhttp3.MediaType;
import github.scarsz.discordsrv.dependencies.okhttp3.MultipartBody;
import github.scarsz.discordsrv.dependencies.okhttp3.OkHttpClient;
import github.scarsz.discordsrv.dependencies.okhttp3.Request;
import github.scarsz.discordsrv.dependencies.okhttp3.RequestBody;
import github.scarsz.discordsrv.dependencies.okhttp3.Response;
import github.scarsz.discordsrv.dependencies.okio.Okio;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WebhookUtil {
    private static final Predicate<Webhook> LEGACY = hook -> hook.getName().endsWith("#1") || hook.getName().endsWith("#2");
    private static boolean loggedBannedWords = false;
    private static final Map<String, String> channelWebhookUrls;

    public static void deliverMessage(TextChannel channel, Player player, String message) {
        WebhookUtil.deliverMessage(channel, player, message, (Collection<? extends MessageEmbed>)null);
    }

    public static void deliverMessage(TextChannel channel, Player player, String message, MessageEmbed embed) {
        WebhookUtil.deliverMessage(channel, (OfflinePlayer)player, player.getDisplayName(), message, embed);
    }

    public static void deliverMessage(TextChannel channel, Player player, String message, Collection<? extends MessageEmbed> embeds) {
        WebhookUtil.deliverMessage(channel, (OfflinePlayer)player, player.getDisplayName(), message, embeds);
    }

    public static void deliverMessage(TextChannel channel, Player player, String message, MessageEmbed embed, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        WebhookUtil.deliverMessage(channel, (OfflinePlayer)player, player.getDisplayName(), message, embed, attachments, interactions);
    }

    public static void deliverMessage(TextChannel channel, Player player, String message, Collection<? extends MessageEmbed> embeds, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        WebhookUtil.deliverMessage(channel, (OfflinePlayer)player, player.getDisplayName(), message, embeds, attachments, interactions);
    }

    public static void deliverMessage(TextChannel channel, OfflinePlayer player, String displayName, String message, MessageEmbed embed) {
        WebhookUtil.deliverMessage(channel, player, displayName, message, embed, null, null);
    }

    public static void deliverMessage(TextChannel channel, OfflinePlayer player, String displayName, String message, Collection<? extends MessageEmbed> embeds) {
        WebhookUtil.deliverMessage(channel, player, displayName, message, embeds, null, null);
    }

    public static void deliverMessage(TextChannel channel, OfflinePlayer player, String displayName, String message, MessageEmbed embed, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        WebhookUtil.deliverMessage(channel, player, displayName, message, Collections.singletonList(embed), null, null);
    }

    public static void deliverMessage(TextChannel channel, OfflinePlayer player, String displayName, String message, Collection<? extends MessageEmbed> embeds, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> {
            String avatarUrl = player instanceof Player ? DiscordSRV.getAvatarUrl((Player)player) : DiscordSRV.getAvatarUrl(player.getName(), player.getUniqueId());
            String username = DiscordSRV.config().getString("Experiment_WebhookChatMessageUsernameFormat").replace("%displayname%", displayName).replace("%username%", String.valueOf(player.getName()));
            String chatMessage = DiscordSRV.config().getString("Experiment_WebhookChatMessageFormat").replace("%displayname%", displayName).replace("%username%", player.getName()).replace("%message%", message.replace("[", "\\["));
            chatMessage = PlaceholderUtil.replacePlaceholdersToDiscord(chatMessage, player);
            chatMessage = DiscordUtil.translateEmotes(chatMessage, channel.getGuild());
            username = PlaceholderUtil.replacePlaceholdersToDiscord(username, player);
            username = MessageUtil.strip(username);
            for (Map.Entry<Pattern, String> entry : DiscordSRV.getPlugin().getGameRegexes().entrySet()) {
                username = entry.getKey().matcher(username).replaceAll(entry.getValue());
                chatMessage = entry.getKey().matcher(chatMessage).replaceAll(entry.getValue());
                if (StringUtils.isBlank(username)) {
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not processing Minecraft message because the webhook username was cleared by a filter: " + entry.getKey().pattern());
                    return;
                }
                if (!StringUtils.isBlank(chatMessage)) continue;
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not processing Minecraft message because the webhook content was cleared by a filter: " + entry.getKey().pattern());
                return;
            }
            String userId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId());
            if (userId != null) {
                Member member = DiscordUtil.getMemberById(userId);
                username = username.replace("%discordname%", member != null ? member.getEffectiveName() : "").replace("%discordusername%", member != null ? member.getUser().getName() : "");
                if (member != null) {
                    if (DiscordSRV.config().getBoolean("Experiment_WebhookChatMessageAvatarFromDiscord")) {
                        avatarUrl = member.getUser().getEffectiveAvatarUrl();
                    }
                    if (DiscordSRV.config().getBoolean("Experiment_WebhookChatMessageUsernameFromDiscord")) {
                        username = member.getEffectiveName();
                    }
                }
            } else {
                username = username.replace("%discordname%", "").replace("%discordusername%", "");
            }
            if (username.length() > 80) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "The webhook username in " + player.getName() + "'s message was too long! Reducing to 80 characters");
                username = username.substring(0, 80);
            }
            WebhookUtil.deliverMessage(channel, username, avatarUrl, chatMessage, embeds, attachments, interactions);
        });
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, MessageEmbed embed) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, Collections.singletonList(embed), null, null, true, true);
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, MessageEmbed embed, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, Collections.singletonList(embed), null, null, true, scheduleAsync);
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, Collection<? extends MessageEmbed> embeds) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, embeds, null, null, true, true);
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, Collection<? extends MessageEmbed> embeds, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, embeds, null, null, true, scheduleAsync);
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, MessageEmbed embed, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, Collections.singletonList(embed), attachments, interactions, true, true);
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, MessageEmbed embed, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, Collections.singletonList(embed), attachments, interactions, true, scheduleAsync);
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, Collection<? extends MessageEmbed> embeds, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, embeds, attachments, interactions, true, true);
    }

    public static void deliverMessage(TextChannel channel, String webhookName, String webhookAvatarUrl, String message, Collection<? extends MessageEmbed> embeds, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, null, message, embeds, attachments, interactions, true, scheduleAsync);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, MessageEmbed embed) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, Collections.singletonList(embed), null, null, true, true);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, MessageEmbed embed, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, Collections.singletonList(embed), null, null, true, scheduleAsync);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, Collection<? extends MessageEmbed> embeds) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, embeds, null, null, true, true);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, Collection<? extends MessageEmbed> embeds, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, embeds, null, null, true, scheduleAsync);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, MessageEmbed embed, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, Collections.singletonList(embed), attachments, interactions, true, true);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, MessageEmbed embed, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, Collections.singletonList(embed), attachments, interactions, true, scheduleAsync);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, Collection<? extends MessageEmbed> embeds, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, embeds, attachments, interactions, true, true);
    }

    public static void editMessage(TextChannel channel, String editMessageId, String message, Collection<? extends MessageEmbed> embeds, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions, boolean scheduleAsync) {
        WebhookUtil.executeWebhook(channel, null, null, editMessageId, message, embeds, attachments, interactions, true, scheduleAsync);
    }

    private static void executeWebhook(TextChannel channel, String webhookName, String webhookAvatarUrl, String editMessageId, String message, Collection<? extends MessageEmbed> embeds, Map<String, InputStream> attachments, Collection<? extends ActionRow> interactions, boolean allowSecondAttempt, boolean scheduleAsync) {
        if (channel == null) {
            if (attachments != null) {
                attachments.values().forEach(inputStream -> {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            return;
        }
        String webhookUrlForChannel = WebhookUtil.getWebhookUrlToUseForChannel(channel);
        if (webhookUrlForChannel == null) {
            if (attachments != null) {
                attachments.values().forEach(inputStream -> {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            return;
        }
        if (editMessageId != null) {
            webhookUrlForChannel = webhookUrlForChannel + "/messages/" + editMessageId;
        }
        String webhookUrl = webhookUrlForChannel;
        Runnable task = () -> {
            block32: {
                try {
                    JSONArray jsonArray;
                    JSONObject jsonObject = new JSONObject();
                    if (editMessageId == null) {
                        String webName = webhookName;
                        for (Map.Entry<Pattern, String> entry : DiscordSRV.getPlugin().getWebhookUsernameRegexes().entrySet()) {
                            webName = entry.getKey().matcher(webName).replaceAll(entry.getValue());
                        }
                        Object username = webName;
                        if (!((String)(username = ((String)username).replaceAll("(?i)(cly)d(e)", "$1*$2").replaceAll("(?i)(d)i(scord)", "$1*$2"))).equals(webName) && loggedBannedWords) {
                            DiscordSRV.info("Some webhook usernames are being altered to remove blocked words (eg. Clyde and Discord)");
                            loggedBannedWords = true;
                        }
                        jsonObject.put("username", username);
                        jsonObject.put("avatar_url", webhookAvatarUrl);
                    }
                    if (StringUtils.isNotBlank(message)) {
                        jsonObject.put("content", message);
                    }
                    if (embeds != null) {
                        jsonArray = new JSONArray();
                        for (MessageEmbed embed : embeds) {
                            if (embed == null) continue;
                            jsonArray.put(embed.toData().toMap());
                        }
                        jsonObject.put("embeds", jsonArray);
                    }
                    if (interactions != null) {
                        jsonArray = new JSONArray();
                        for (ActionRow actionRow : interactions) {
                            jsonArray.put(actionRow.toData().toMap());
                        }
                        jsonObject.put("components", jsonArray);
                    }
                    ArrayList<String> attachmentIndex = null;
                    if (attachments != null) {
                        attachmentIndex = new ArrayList<String>(attachments.size());
                        JSONArray jsonArray2 = new JSONArray();
                        int i = 0;
                        for (String name : attachments.keySet()) {
                            attachmentIndex.add(name);
                            JSONObject attachmentObject = new JSONObject();
                            attachmentObject.put("id", i);
                            attachmentObject.put("filename", name);
                            jsonArray2.put(attachmentObject);
                            ++i;
                        }
                        jsonObject.put("attachments", jsonArray2);
                    }
                    JSONObject allowedMentions = new JSONObject();
                    Set parse = MessageAction.getDefaultMentions().stream().filter(Objects::nonNull).map(Message.MentionType::getParseKey).collect(Collectors.toSet());
                    allowedMentions.put("parse", parse);
                    jsonObject.put("allowed_mentions", allowedMentions);
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Sending webhook payload: " + jsonObject);
                    MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    bodyBuilder.addFormDataPart("payload_json", null, RequestBody.create(MediaType.get("application/json"), jsonObject.toString()));
                    if (attachmentIndex != null) {
                        for (int i = 0; i < attachmentIndex.size(); ++i) {
                            String name = (String)attachmentIndex.get(i);
                            InputStream data = (InputStream)attachments.get(name);
                            if (data == null) continue;
                            bodyBuilder.addFormDataPart("files[" + i + "]", name, new BufferedRequestBody(Okio.source(data), null));
                            data.close();
                        }
                    }
                    Request.Builder requestBuilder = new Request.Builder().url(webhookUrl).header("User-Agent", "DiscordSRV/" + DiscordSRV.getPlugin().getDescription().getVersion());
                    if (editMessageId == null) {
                        requestBuilder.post(bodyBuilder.build());
                    } else {
                        requestBuilder.patch(bodyBuilder.build());
                    }
                    OkHttpClient httpClient = DiscordSRV.getPlugin().getJda().getHttpClient();
                    try (Response response = httpClient.newCall(requestBuilder.build()).execute();){
                        int status = response.code();
                        if (status == 404) {
                            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Webhook delivery returned 404, marking webhooks URLs as invalid to let them regenerate" + (allowSecondAttempt ? " & trying again" : ""));
                            WebhookUtil.invalidWebhookUrlForChannel(channel);
                            if (allowSecondAttempt) {
                                WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, editMessageId, message, embeds, attachments, interactions, false, scheduleAsync);
                            }
                            return;
                        }
                        String body = response.body().string();
                        try {
                            JSONObject jsonObj = new JSONObject(body);
                            if (jsonObj.has("code") && jsonObj.getInt("code") == 10015) {
                                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Webhook delivery returned 10015 (Unknown Webhook), marking webhooks url's as invalid to let them regenerate" + (allowSecondAttempt ? " & trying again" : ""));
                                WebhookUtil.invalidWebhookUrlForChannel(channel);
                                if (allowSecondAttempt) {
                                    WebhookUtil.executeWebhook(channel, webhookName, webhookAvatarUrl, editMessageId, message, embeds, attachments, interactions, false, scheduleAsync);
                                }
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (editMessageId == null ? status == 204 : status == 200) {
                            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received API response for webhook message delivery: " + status);
                        } else {
                            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received unexpected API response for webhook message delivery: " + status + " for request: " + jsonObject.toString() + ", response: " + body);
                        }
                    }
                }
                catch (Exception e) {
                    DiscordSRV.error("Failed to deliver webhook message to Discord: " + e.getMessage());
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, e);
                    if (attachments == null) break block32;
                    attachments.values().forEach(inputStream -> {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
            }
        };
        if (scheduleAsync) {
            SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), task);
        } else {
            task.run();
        }
    }

    public static void invalidWebhookUrlForChannel(TextChannel textChannel) {
        String channelId = textChannel.getId();
        channelWebhookUrls.remove(channelId);
    }

    public static String getWebhookUrlToUseForChannel(TextChannel channel) {
        String channelId = channel.getId();
        return channelWebhookUrls.computeIfAbsent(channelId, cid -> {
            ArrayList<Webhook> hooks = new ArrayList<Webhook>();
            Guild guild = channel.getGuild();
            Member selfMember = guild.getSelfMember();
            String bannedWebhookFormat = "DiscordSRV " + cid;
            String webhookFormat = "DSRV " + cid;
            List<Webhook> result = guild.getSelfMember().hasPermission(Permission.MANAGE_WEBHOOKS) ? guild.retrieveWebhooks().complete() : channel.retrieveWebhooks().complete();
            result.stream().filter(webhook -> webhook.getName().startsWith(webhookFormat) || webhook.getName().startsWith(bannedWebhookFormat)).filter(webhook -> {
                Member owner = webhook.getOwner();
                return owner != null && selfMember.getId().equals(owner.getId());
            }).filter(webhook -> {
                if (!webhook.getChannel().equals(channel)) {
                    webhook.delete().reason("DiscordSRV: Purging lost webhook").queue();
                    return false;
                }
                return true;
            }).filter(webhook -> {
                if (LEGACY.test((Webhook)webhook)) {
                    webhook.delete().reason("DiscordSRV: Purging legacy formatted webhook").queue();
                    return false;
                }
                return true;
            }).forEach(hooks::add);
            if (hooks.isEmpty()) {
                hooks.add(WebhookUtil.createWebhook(channel, webhookFormat));
            } else if (hooks.size() > 1) {
                for (int index = 1; index < hooks.size(); ++index) {
                    ((Webhook)hooks.get(index)).delete().reason("DiscordSRV: Purging duplicate webhook").queue();
                }
            }
            return hooks.stream().map(Webhook::getUrl).findAny().orElse(null);
        });
    }

    public static Webhook createWebhook(TextChannel channel, String name) {
        try {
            Webhook webhook = (Webhook)channel.createWebhook(name).reason("DiscordSRV: Creating webhook").complete();
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Created webhook " + webhook.getName() + " to deliver messages to text channel #" + channel.getName());
            return webhook;
        }
        catch (Exception e) {
            DiscordSRV.error("Failed to create webhook " + name + " for message delivery: " + e.getMessage());
            return null;
        }
    }

    public static String getWebhookUrlFromCache(TextChannel channel) {
        return channelWebhookUrls.get(channel.getId());
    }

    static {
        try {
            for (Guild guild : DiscordSRV.getPlugin().getJda().getGuilds()) {
                Member selfMember = guild.getSelfMember();
                if (!selfMember.hasPermission(Permission.MANAGE_WEBHOOKS)) {
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Unable to manage webhooks guild-wide in " + guild);
                    continue;
                }
                guild.retrieveWebhooks().queue(webhooks -> {
                    for (Webhook webhook : webhooks) {
                        Member owner = webhook.getOwner();
                        if (owner == null || !owner.getId().equals(selfMember.getId()) || !webhook.getName().startsWith("DiscordSRV")) continue;
                        if (DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(webhook.getChannel()) == null) {
                            webhook.delete().reason("DiscordSRV: Purging webhook for unlinked channel").queue();
                            continue;
                        }
                        if (!LEGACY.test(webhook)) continue;
                        webhook.delete().reason("DiscordSRV: Purging legacy formatted webhook").queue();
                    }
                });
            }
        }
        catch (Exception e) {
            DiscordSRV.warning("Failed to purge already existing webhooks: " + e.getMessage());
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, e);
        }
        channelWebhookUrls = new ConcurrentHashMap<String, String>();
    }
}

