/*
 * Decompiled with CFR 0.152.
 */
package me.scarsz.jdaappender;

import ch.qos.logback.classic.LoggerContext;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ErrorResponseException;
import github.scarsz.discordsrv.dependencies.jda.api.requests.ErrorResponse;
import github.scarsz.discordsrv.dependencies.jda.api.utils.MarkdownSanitizer;
import java.io.Flushable;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import lombok.Generated;
import me.scarsz.jdaappender.HandlerConfig;
import me.scarsz.jdaappender.IChannelLoggingHandler;
import me.scarsz.jdaappender.LogItem;
import me.scarsz.jdaappender.LogLevel;
import me.scarsz.jdaappender.adapter.JavaLoggingAdapter;
import me.scarsz.jdaappender.adapter.SystemLoggingAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class ChannelLoggingHandler
implements IChannelLoggingHandler,
Flushable {
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> scheduledFuture;
    private static final Pattern URL_PATTERN = Pattern.compile("https?:\\/\\/((?:[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9]:?\\d*\\/?[a-zA-Z0-9_\\/\\-#.]*\\??[a-zA-Z0-9\\-_~:\\/?#\\[\\]@!$&'()*+,;=%.]*)");
    private static final int MESSAGE_BLOCKED_BY_HARMFUL_LINK_FILTER_ERROR_CODE = 240000;
    private final HandlerConfig config = new HandlerConfig();
    private final Deque<LogItem> messageQueue = new LinkedList<LogItem>();
    private final Deque<LogItem> unprocessedQueue = new ConcurrentLinkedDeque<LogItem>();
    private final Set<LogItem> stack = new LinkedHashSet<LogItem>();
    private final AtomicBoolean dirtyBit = new AtomicBoolean();
    private Supplier<MessageChannel> channelSupplier;
    private final Set<Runnable> detachRunnables = new HashSet<Runnable>();
    private Message currentMessage = null;

    public ChannelLoggingHandler schedule() {
        return this.schedule(1500L, TimeUnit.MILLISECONDS);
    }

    public ChannelLoggingHandler schedule(long period, @NotNull TimeUnit unit) {
        this.shutdownExecutor();
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        if (this.scheduledFuture == null) {
            this.scheduledFuture = this.executor.scheduleAtFixedRate(() -> {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, period, period, unit);
        }
        return this;
    }

    public ChannelLoggingHandler(@NotNull Supplier<MessageChannel> channelSupplier) {
        this(channelSupplier, null);
    }

    public ChannelLoggingHandler(@NotNull Supplier<MessageChannel> channelSupplier, @Nullable Consumer<HandlerConfig> configConsumer) {
        this.channelSupplier = channelSupplier;
        if (configConsumer != null) {
            configConsumer.accept(this.config);
        }
    }

    @Override
    public void enqueue(LogItem item) {
        this.unprocessedQueue.add(item);
    }

    private void process(LogItem item) {
        if (!this.config.getLogLevels().contains((Object)item.getLevel())) {
            return;
        }
        if (this.config.resolveLoggerName(item.getLogger()) == null) {
            return;
        }
        for (Map.Entry<Predicate<LogItem>, Function<String, String>> entry : this.config.getMessageTransformers().entrySet()) {
            if (!entry.getKey().test(item) || entry.getValue().apply(item.getMessage()) != null) continue;
            return;
        }
        for (Map.Entry<Predicate<LogItem>, Function<String, String>> entry : this.config.getMessageTransformers().entrySet()) {
            if (!entry.getKey().test(item)) continue;
            item.setMessage(entry.getValue().apply(item.getMessage()));
        }
        Set<LogItem> clipped = item.clip(this.config, (int)Math.ceil(4.0));
        this.messageQueue.add(item);
        this.messageQueue.addAll(clipped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        LogItem currentItem;
        while ((currentItem = this.unprocessedQueue.poll()) != null) {
            this.process(currentItem);
        }
        MessageChannel loggingChannel = this.channelSupplier.get();
        if (loggingChannel != null && loggingChannel.getJDA().getStatus() == JDA.Status.CONNECTED) {
            Set<LogItem> set = this.stack;
            synchronized (set) {
                LogItem logItem;
                while ((logItem = this.messageQueue.poll()) != null) {
                    if (logItem.getMessage() == null && logItem.getThrowable() == null) continue;
                    if (logItem.getFormattedLength(this.config) > 1980) {
                        throw new IllegalStateException("Log item longer than Discord's max content length: " + logItem);
                    }
                    if (!this.canFit(logItem)) {
                        if (this.stack.isEmpty()) {
                            throw new IllegalStateException("Can't fit LogItem into empty stack: " + logItem);
                        }
                        this.dumpStack();
                    }
                    this.stack.add(logItem);
                    this.dirtyBit.set(true);
                }
                if (this.dirtyBit.get() && !this.stack.isEmpty()) {
                    this.currentMessage = this.updateMessage();
                    this.dirtyBit.set(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStack() {
        Set<LogItem> set = this.stack;
        synchronized (set) {
            try {
                if (!this.stack.isEmpty()) {
                    this.updateMessage();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.stack.clear();
            this.currentMessage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canFit(LogItem logItem) {
        Set<LogItem> set = this.stack;
        synchronized (set) {
            int lengthSum = 0;
            for (LogItem item : this.stack) {
                String formatted = item.format(this.config);
                int length = formatted.length();
                lengthSum += length;
            }
            boolean codeBlocks = this.config.isUseCodeBlocks();
            if (codeBlocks) {
                lengthSum += "```".length() * 2;
            }
            lengthSum += "\n".length() * (this.stack.size() + (codeBlocks ? 1 : -1));
            if (this.config.isColored()) {
                lengthSum += "diff".length();
                lengthSum += "- ".length() * this.stack.size();
            }
            if (this.config.isSplitCodeBlockForLinks()) {
                lengthSum += "```".length() * 2;
                lengthSum += "\n".length() * 2;
                if (this.config.isColored()) {
                    lengthSum += "diff".length();
                }
            }
            return lengthSum + logItem.format(this.config).length() + 5 <= 2000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message updateMessage() throws IllegalStateException {
        String full;
        StringJoiner joiner;
        MessageChannel channel;
        Set<LogItem> set = this.stack;
        synchronized (set) {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("No messages on stack");
            }
            channel = this.channelSupplier.get();
            if (channel == null) {
                throw new IllegalStateException("Channel unavailable");
            }
            joiner = new StringJoiner("\n");
            for (LogItem item : this.stack) {
                boolean willSplit = this.config.isSplitCodeBlockForLinks() && item.getMessage() != null && URL_PATTERN.matcher(item.getMessage()).find();
                String formatted = item.format(this.config);
                if (!willSplit && this.config.isColored()) {
                    formatted = item.getLevel().getLevelSymbol() + " " + formatted;
                }
                if (willSplit) {
                    joiner.add("```\n" + formatted + "\n```" + (this.config.isColored() ? "diff" : ""));
                    continue;
                }
                joiner.add(formatted);
            }
        }
        boolean codeBlock = this.config.isUseCodeBlocks();
        String string = codeBlock ? "```" + (this.config.isColored() ? "diff" : "") + "\n" + joiner + "```" : (full = joiner.toString());
        if (codeBlock) {
            full = full.replace("```" + (this.config.isColored() ? "diff" : "") + "```", "");
            full = full.replace("```" + (this.config.isColored() ? "diff" : "") + "\n```", "");
        }
        while (full.contains("\n\n")) {
            full = full.replace("\n\n", "\n");
        }
        try {
            for (int i = 0; i < 2; ++i) {
                try {
                    return this.sendOrEditMessage(full, channel);
                }
                catch (ErrorResponseException ex) {
                    if (i != 0 || ex.getErrorResponse() != ErrorResponse.UNKNOWN_MESSAGE) {
                        throw ex;
                    }
                    this.currentMessage = null;
                    continue;
                }
            }
            throw new RuntimeException("Unexpected error: Failed to update message for unknown reason.");
        }
        catch (ErrorResponseException ex) {
            if (ex.getErrorCode() == 240000) {
                full = URL_PATTERN.matcher(full).replaceAll("$1");
                return this.sendOrEditMessage(full, channel);
            }
            throw ex;
        }
    }

    private Message sendOrEditMessage(String full, MessageChannel channel) throws ErrorResponseException {
        try {
            if (this.currentMessage != null) {
                return (Message)this.currentMessage.editMessage(full).submit().get();
            }
            return (Message)channel.sendMessage(full).submit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (this.isInterruptedException(e)) {
                return this.currentMessage;
            }
            Throwable cause = e.getCause();
            if (cause instanceof ErrorResponseException) {
                throw (ErrorResponseException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    public void recreateChannel(@Nullable String reason) {
        MessageChannel uncheckedChannel = this.channelSupplier.get();
        if (!(uncheckedChannel instanceof TextChannel)) {
            throw new IllegalStateException("recreateChannel is only implemented for instances of TextChannel");
        }
        TextChannel channel = (TextChannel)uncheckedChannel;
        channel.createCopy().setPosition(channel.getPositionRaw()).flatMap(textChannel -> {
            this.channelSupplier = () -> textChannel;
            return channel.delete().reason(reason);
        }).complete();
    }

    public void shutdownExecutor() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executor = null;
        }
    }

    public void shutdown() {
        this.detach();
        this.shutdownExecutor();
    }

    public ChannelLoggingHandler attach() {
        try {
            Class.forName("org.apache.logging.log4j.core.Logger");
            return this.attachLog4jLogging();
        }
        catch (Throwable throwable) {
            try {
                Class.forName("ch.qos.logback.core.Appender");
                return this.attachLogbackLogging();
            }
            catch (Throwable throwable2) {
                try {
                    Class<?> logFactoryClass = Class.forName(StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr());
                    switch (logFactoryClass.getSimpleName()) {
                        case "JDK14LoggerFactory": {
                            return this.attachJavaLogging();
                        }
                        case "ContextSelectorStaticBinder": {
                            return this.attachLogbackLogging();
                        }
                    }
                    System.err.println("SLF4J Logger factory " + logFactoryClass.getName() + " is not supported");
                    this.enqueue(new LogItem(this, "Appender", LogLevel.ERROR, "SLF4J Logger factory " + logFactoryClass.getName() + " is not supported"));
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                return this.attachSystemLogging();
            }
        }
    }

    public void detach() {
        Iterator<Runnable> iterator = this.detachRunnables.iterator();
        while (iterator.hasNext()) {
            Runnable runnable = iterator.next();
            runnable.run();
            iterator.remove();
        }
    }

    public ChannelLoggingHandler attachSystemLogging() {
        SystemLoggingAdapter adapter = new SystemLoggingAdapter(this);
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        System.setOut(adapter.getOutStream());
        System.setErr(adapter.getErrStream());
        this.detachRunnables.add(() -> {
            System.setOut(originalOut);
            System.setErr(originalErr);
        });
        return this;
    }

    public ChannelLoggingHandler attachJavaLogging() {
        JavaLoggingAdapter adapter = new JavaLoggingAdapter(this);
        java.util.logging.Logger.getLogger("").addHandler(adapter);
        this.detachRunnables.add(() -> java.util.logging.Logger.getLogger("").removeHandler(adapter));
        return this;
    }

    public ChannelLoggingHandler attachLog4jLogging() {
        org.apache.logging.log4j.Logger rootLogger = LogManager.getRootLogger();
        Method addAppenderMethod = rootLogger.getClass().getMethod("addAppender", Appender.class);
        Method removeAppenderMethod = rootLogger.getClass().getMethod("removeAppender", Appender.class);
        Object adapter = Class.forName("me.scarsz.jdaappender.adapter.Log4JLoggingAdapter").getConstructor(IChannelLoggingHandler.class).newInstance(this);
        addAppenderMethod.invoke((Object)rootLogger, adapter);
        this.detachRunnables.add(() -> {
            try {
                removeAppenderMethod.invoke((Object)rootLogger, adapter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return this;
    }

    public ChannelLoggingHandler attachLogbackLogging() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = loggerContext.getLogger("ROOT");
        Method addAppenderMethod = rootLogger.getClass().getMethod("addAppender", ch.qos.logback.core.Appender.class);
        Method detachAppenderMethod = rootLogger.getClass().getMethod("detachAppender", ch.qos.logback.core.Appender.class);
        Object adapter = Class.forName("me.scarsz.jdaappender.adapter.LogbackLoggingAdapter").getConstructor(ChannelLoggingHandler.class, LoggerContext.class).newInstance(this, loggerContext);
        addAppenderMethod.invoke((Object)rootLogger, adapter);
        this.detachRunnables.add(() -> ChannelLoggingHandler.lambda$attachLogbackLogging$6(detachAppenderMethod, (Logger)rootLogger, adapter));
        return this;
    }

    @Override
    public String escapeMarkdown(String message) {
        return MarkdownSanitizer.escape(message);
    }

    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    @Generated
    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    @Generated
    public HandlerConfig getConfig() {
        return this.config;
    }

    @Generated
    public Deque<LogItem> getMessageQueue() {
        return this.messageQueue;
    }

    @Generated
    public Set<LogItem> getStack() {
        return this.stack;
    }

    @Generated
    public AtomicBoolean getDirtyBit() {
        return this.dirtyBit;
    }

    @Generated
    public Supplier<MessageChannel> getChannelSupplier() {
        return this.channelSupplier;
    }

    private static /* synthetic */ void lambda$attachLogbackLogging$6(Method detachAppenderMethod, Logger rootLogger, Object adapter) {
        try {
            detachAppenderMethod.invoke((Object)rootLogger, adapter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

