/*
 * Decompiled with CFR 0.152.
 */
package me.scarsz.jdaappender;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import me.scarsz.jdaappender.LogItem;
import me.scarsz.jdaappender.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandlerConfig {
    private final Map<Predicate<LogItem>, Function<String, String>> messageTransformers = new LinkedHashMap<Predicate<LogItem>, Function<String, String>>();
    private int loggerNamePadding = 0;
    private final Map<Predicate<String>, Function<String, String>> loggerMappings = new LinkedHashMap<Predicate<String>, Function<String, String>>();
    private static final Function<String, String> friendlyMapper = s -> s.substring(s.lastIndexOf(".") + 1);
    @Nullable
    private Function<LogItem, String> prefixer = item -> {
        String name = this.padLoggerName(this.resolveLoggerName(item.getLogger()));
        return "[" + this.padLevelName(item.getLevel().name()) + (name != null && !name.isEmpty() ? " " + name : "") + "] ";
    };
    @Nullable
    private Function<LogItem, String> suffixer;
    private EnumSet<LogLevel> logLevels = EnumSet.complementOf(EnumSet.of(LogLevel.DEBUG));
    private boolean useCodeBlocks = true;
    private boolean splitCodeBlockForLinks = false;
    private boolean allowLinkEmbeds = true;
    private boolean colored = true;
    private boolean truncateLongItems = true;

    public void addFilter(Predicate<LogItem> filter) {
        this.messageTransformers.put(filter, s -> null);
    }

    public void addTransformer(Predicate<LogItem> filter, Function<String, String> transformer) {
        this.messageTransformers.put(filter, transformer);
    }

    public void mapLogger(Predicate<String> predicate, Function<String, String> function) {
        this.loggerMappings.put(predicate, function);
    }

    public void mapLoggerType(Class<?> superclass, Function<String, String> function) {
        this.loggerMappings.put(s -> {
            try {
                return superclass.isAssignableFrom(Class.forName(s));
            }
            catch (Throwable ignored) {
                return false;
            }
        }, function);
    }

    public void mapLoggerTypeFriendly(Class<?> superclass) {
        this.mapLoggerType(superclass, friendlyMapper);
    }

    public void mapLoggerName(String prefix, String friendlyName) {
        this.loggerMappings.put(s -> s.startsWith(prefix), s -> friendlyName);
    }

    public void mapLoggerName(String prefix, Function<String, String> function) {
        this.loggerMappings.put(s -> s.startsWith(prefix), function);
    }

    public void mapLoggerNameFriendly(String prefix) {
        this.loggerMappings.put(s -> s.startsWith(prefix), friendlyMapper);
    }

    public void mapLoggerNameFriendly(String prefix, Function<String, String> function) {
        this.loggerMappings.put(s -> s.startsWith(prefix), s -> (String)function.apply(friendlyMapper.apply((String)s)));
    }

    public void ignoreLoggerName(String prefix) {
        this.loggerMappings.put(s -> s.startsWith(prefix), s -> null);
    }

    @Nullable
    public String resolveLoggerName(@NotNull String name) {
        for (Map.Entry<Predicate<String>, Function<String, String>> entry : this.loggerMappings.entrySet()) {
            if (!entry.getKey().test(name)) continue;
            return entry.getValue().apply(name);
        }
        return name;
    }

    public boolean isSplitCodeBlockForLinks() {
        return this.splitCodeBlockForLinks && this.useCodeBlocks;
    }

    public boolean isAllowLinkEmbeds() {
        return this.allowLinkEmbeds && this.useCodeBlocks;
    }

    public boolean isColored() {
        return this.colored && this.useCodeBlocks;
    }

    int getFormattingLength(LogItem logItem) {
        int length = 0;
        if (this.prefixer != null) {
            length += this.prefixer.apply(logItem).length();
        }
        if (this.suffixer != null) {
            length += this.suffixer.apply(logItem).length();
        }
        return length;
    }

    public String pad(String string, int to) {
        if (string == null) {
            string = "";
        }
        if (to == 0 || string.length() >= Math.abs(to)) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        if (to > 0) {
            builder.append(string);
            while (builder.length() < Math.abs(to)) {
                builder.append(' ');
            }
        } else {
            while (builder.length() < Math.abs(to) - string.length()) {
                builder.append(' ');
            }
            builder.append(string);
        }
        return builder.toString();
    }

    public String padLoggerName(String loggerName) {
        return this.useCodeBlocks ? this.pad(loggerName, this.loggerNamePadding) : loggerName;
    }

    public String padLevelName(String levelName) {
        return this.useCodeBlocks ? this.pad(levelName, LogLevel.MAX_NAME_LENGTH) : levelName;
    }

    @Generated
    public Map<Predicate<LogItem>, Function<String, String>> getMessageTransformers() {
        return this.messageTransformers;
    }

    @Generated
    public int getLoggerNamePadding() {
        return this.loggerNamePadding;
    }

    @Generated
    public void setLoggerNamePadding(int loggerNamePadding) {
        this.loggerNamePadding = loggerNamePadding;
    }

    @Generated
    public Map<Predicate<String>, Function<String, String>> getLoggerMappings() {
        return this.loggerMappings;
    }

    @Generated
    public static Function<String, String> getFriendlyMapper() {
        return friendlyMapper;
    }

    @Nullable
    @Generated
    public Function<LogItem, String> getPrefixer() {
        return this.prefixer;
    }

    @Generated
    public void setPrefixer(@Nullable Function<LogItem, String> prefixer) {
        this.prefixer = prefixer;
    }

    @Nullable
    @Generated
    public Function<LogItem, String> getSuffixer() {
        return this.suffixer;
    }

    @Generated
    public void setSuffixer(@Nullable Function<LogItem, String> suffixer) {
        this.suffixer = suffixer;
    }

    @Generated
    public EnumSet<LogLevel> getLogLevels() {
        return this.logLevels;
    }

    @Generated
    public void setLogLevels(EnumSet<LogLevel> logLevels) {
        this.logLevels = logLevels;
    }

    @Generated
    public boolean isUseCodeBlocks() {
        return this.useCodeBlocks;
    }

    @Generated
    public void setUseCodeBlocks(boolean useCodeBlocks) {
        this.useCodeBlocks = useCodeBlocks;
    }

    @Generated
    public void setSplitCodeBlockForLinks(boolean splitCodeBlockForLinks) {
        this.splitCodeBlockForLinks = splitCodeBlockForLinks;
    }

    @Generated
    public void setAllowLinkEmbeds(boolean allowLinkEmbeds) {
        this.allowLinkEmbeds = allowLinkEmbeds;
    }

    @Generated
    public void setColored(boolean colored) {
        this.colored = colored;
    }

    @Generated
    public boolean isTruncateLongItems() {
        return this.truncateLongItems;
    }

    @Generated
    public void setTruncateLongItems(boolean truncateLongItems) {
        this.truncateLongItems = truncateLongItems;
    }
}

