/*
 * Decompiled with CFR 0.152.
 */
package me.scarsz.jdaappender.adapter;

import java.io.PrintStream;
import lombok.Generated;
import me.scarsz.jdaappender.IChannelLoggingHandler;
import me.scarsz.jdaappender.LogItem;
import me.scarsz.jdaappender.LogLevel;
import org.jetbrains.annotations.NotNull;

public class SystemLoggingAdapter {
    private final LogStream outStream;
    private final LogStream errStream;

    public SystemLoggingAdapter(IChannelLoggingHandler handler) {
        this.outStream = new LogStream(System.out, "SOUT", LogLevel.INFO, handler);
        this.errStream = new LogStream(System.err, "SERR", LogLevel.ERROR, handler);
    }

    @Generated
    public LogStream getOutStream() {
        return this.outStream;
    }

    @Generated
    public LogStream getErrStream() {
        return this.errStream;
    }

    static class LogStream
    extends PrintStream {
        private final String loggerName;
        private final LogLevel level;
        private final IChannelLoggingHandler handler;

        public LogStream(PrintStream standardStream, String loggerName, LogLevel level, IChannelLoggingHandler handler) {
            super(standardStream, true);
            this.loggerName = loggerName;
            this.level = level;
            this.handler = handler;
        }

        @Override
        public void println(Object o) {
            super.println(o);
            this.println(o.toString());
        }

        @Override
        public void println(String str) {
            super.println(str);
            this.handler.enqueue(new LogItem(this.handler, this.loggerName, System.currentTimeMillis(), this.level, str, null));
        }

        @Override
        public PrintStream printf(@NotNull String format, Object ... variables) {
            super.printf(format, variables);
            this.println(String.format(format, variables));
            return this;
        }
    }
}

