package net.trique.mythiclib.datagen;

import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MythicSmithingRecipeProvider implements class_2405 {
    private final FabricDataOutput output;

    private static final List<String> MATERIALS = List.of(
            "netherite", "ametrine", "ruby", "topaz", "sapphire", "aquamarine", "jade", "peridot"
    );

    private static final List<String> EQUIPMENT = List.of(
            "sword", "pickaxe", "axe", "shovel", "hoe",
            "helmet", "chestplate", "leggings", "boots"
    );

    public MythicSmithingRecipeProvider(FabricDataOutput output) {
        this.output = output;
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        List<CompletableFuture<?>> futures = new ArrayList<>();

        for (String from : MATERIALS) {
            for (String to : MATERIALS) {
                if (from.equals(to)) continue;

                for (String eq : EQUIPMENT) {
                    class_2960 id = class_2960.method_60655("mythiclib", from + "_to_" + to + "_" + eq + "_smithing");

                    JsonObject json = smithingTransformJson(
                            "mythicupgrades:" + to + "_upgrade_smithing_template",
                            "mythicupgrades:" + from + "_" + eq,
                            "mythicupgrades:" + to + "_ingot",
                            "mythicupgrades:" + to + "_" + eq
                    );

                    Path path = output.method_45973(class_7784.class_7490.field_39367, "recipes").method_44107(id);
                    futures.add(class_2405.method_10320(writer, json, path));
                }
            }
        }

        return CompletableFuture.allOf(futures.toArray(CompletableFuture[]::new));
    }

    @Override
    public String method_10321() {
        return "MythicLib — Full Smithing Recipe Generator (1.21/1.21.1 format)";
    }

    private static JsonObject smithingTransformJson(String templateItem, String baseItem, String additionItem, String resultItem) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:smithing_transform");

        JsonObject addition = new JsonObject();
        addition.addProperty("item", additionItem);
        root.add("addition", addition);

        JsonObject base = new JsonObject();
        base.addProperty("item", baseItem);
        root.add("base", base);

        JsonObject result = new JsonObject();
        result.addProperty("id", resultItem);
        result.addProperty("count", 1);
        root.add("result", result);

        JsonObject template = new JsonObject();
        template.addProperty("item", templateItem);
        root.add("template", template);

        return root;
    }
}
