/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.EntitySelectionButton;
import com.burnedkirby.TurnBasedMinecraft.client.ItemSelectionButton;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.Combatant;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.PacketDistributor;

public class BattleGui
extends Screen {
    private AtomicInteger timeRemaining = new AtomicInteger(15);
    private int timerMax = this.timeRemaining.get();
    private boolean turnTimerEnabled;
    private long lastInstant = System.nanoTime();
    private long elapsedTime = 0L;
    private MenuState state = MenuState.MAIN_MENU;
    private boolean stateChanged = true;
    private String info;
    private Long waitMissingBattleTicks = null;
    private boolean showingEntities = false;

    public BattleGui() {
        super((Component)Component.literal((String)"Battle Gui"));
    }

    private void setState(MenuState state) {
        this.state = state;
        this.stateChanged = true;
    }

    public void turnBegin() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.ACTION);
        }
        this.setState(MenuState.WAITING);
    }

    public void turnEnd() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.DECISION);
        }
        this.timeRemaining.set(this.timerMax);
        this.elapsedTime = 0L;
        this.lastInstant = System.nanoTime();
        this.setState(MenuState.MAIN_MENU);
    }

    public void battleChanged() {
        this.stateChanged = true;
    }

    public void updateState() {
        if (!this.stateChanged) {
            return;
        }
        this.stateChanged = false;
        this.showingEntities = false;
        this.clearWidgets();
        switch (this.state.ordinal()) {
            case 0: {
                this.info = "What will you do?";
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Attack"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.ATTACK)).bounds(this.width * 3 / 7 - 25, 40, 50, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Defend"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.DEFEND)).bounds(this.width * 4 / 7 - 25, 40, 50, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Item"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.ITEM)).bounds(this.width * 3 / 7 - 25, 60, 50, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Flee"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.FLEE)).bounds(this.width * 4 / 7 - 25, 60, 50, 20).build());
                break;
            }
            case 1: {
                this.info = "Who will you attack?";
                int y = 30;
                this.showingEntities = true;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideAEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.addRenderableWidget(new EntitySelectionButton(this.width / 4 - 60, y, 120, 20, e.getValue().entity.getDisplayName(), (int)e.getKey(), true, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.addRenderableWidget(new EntitySelectionButton(this.width / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), true, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                y = 30;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideBEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.addRenderableWidget(new EntitySelectionButton(this.width * 3 / 4 - 60, y, 120, 20, e.getValue().entity.getDisplayName(), (int)e.getKey(), false, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.addRenderableWidget(new EntitySelectionButton(this.width * 3 / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), false, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width / 2 - 30, this.height - 120, 60, 20).build());
                break;
            }
            case 2: {
                this.info = "What will you do with an item?";
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Switch Held"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.SWITCH_HELD_ITEM)).bounds(this.width / 4 - 40, this.height - 120, 80, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Use"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.DECIDE_USE_ITEM)).bounds(this.width * 2 / 4 - 40, this.height - 120, 80, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width * 3 / 4 - 40, this.height - 120, 80, 20).build());
                break;
            }
            case 3: {
                this.info = "Waiting...";
                break;
            }
            case 4: {
                this.info = "To which item will you switch to?";
                for (int i = 0; i < 9; ++i) {
                    this.addRenderableWidget(new ItemSelectionButton(this.width / 2 - 88 + i * 20, this.height - 19, 16, 16, i, button -> this.itemButtonActionEvent(button, ButtonAction.DO_ITEM_SWITCH)));
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width / 2 - 40, this.height - 120, 80, 20).build());
                break;
            }
            case 5: {
                this.info = "Which item will you use?";
                for (int i = 0; i < 9; ++i) {
                    this.addRenderableWidget(new ItemSelectionButton(this.width / 2 - 88 + i * 20, this.height - 19, 16, 16, i, button -> this.itemButtonActionEvent(button, ButtonAction.DO_USE_ITEM)));
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).bounds(this.width / 2 - 40, this.height - 120, 80, 20).build());
            }
        }
    }

    private int colorFromTicks(Long ticks) {
        if (ticks < 200L) {
            double value = (double)(200 - ticks.intValue()) / 200.0;
            return 0xFF0000FF | (int)(value * 255.0) << 8 | (int)(value * 255.0) << 16;
        }
        return -16776961;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
            this.waitMissingBattleTicks = this.waitMissingBattleTicks == null ? Long.valueOf(0L) : Long.valueOf(this.waitMissingBattleTicks + 1L);
            this.drawString(guiGraphics, "Waiting...", this.width / 2 - 50, this.height / 2, this.colorFromTicks(this.waitMissingBattleTicks));
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            return;
        }
        this.waitMissingBattleTicks = null;
        if (TurnBasedMinecraftMod.proxy.getLocalBattle().getState() == Battle.State.DECISION && this.timeRemaining.get() > 0) {
            long nextInstant = System.nanoTime();
            this.elapsedTime += nextInstant - this.lastInstant;
            this.lastInstant = nextInstant;
            while (this.elapsedTime > 1000000000L) {
                this.elapsedTime -= 1000000000L;
                this.timeRemaining.decrementAndGet();
            }
        }
        this.updateState();
        if (this.showingEntities) {
            LivingEntity lEntity;
            Entity entity;
            int y = 30;
            try {
                for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideAEntrySet()) {
                    entity = e.getValue().entity;
                    if (entity instanceof LivingEntity) {
                        lEntity = (LivingEntity)entity;
                        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.width / 4 - 60 - 20), (int)y, (int)(this.width / 4 - 60), (int)(y + 20), (int)7, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)lEntity);
                    }
                    y += 20;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            y = 30;
            try {
                for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideBEntrySet()) {
                    entity = e.getValue().entity;
                    if (entity instanceof LivingEntity) {
                        lEntity = (LivingEntity)entity;
                        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.width * 3 / 4 - 60 + 120), (int)y, (int)(this.width * 3 / 4 - 60 + 140), (int)(y + 20), (int)7, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)lEntity);
                    }
                    y += 20;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Object timeRemainingString = "Time remaining: ";
        int timeRemainingInt = this.timeRemaining.get();
        timeRemainingString = timeRemainingInt > 8 || !this.turnTimerEnabled ? (String)timeRemainingString + "\u00a7a" : (timeRemainingInt > 4 ? (String)timeRemainingString + "\u00a7e" : (String)timeRemainingString + "\u00a7c");
        timeRemainingString = !this.turnTimerEnabled ? (String)timeRemainingString + "Infinity" : (String)timeRemainingString + Integer.toString(timeRemainingInt);
        int stringWidth = this.font.width((String)timeRemainingString);
        guiGraphics.fill(this.width / 2 - stringWidth / 2, 5, this.width / 2 + stringWidth / 2, 15, 0x70000000);
        this.drawString(guiGraphics, (String)timeRemainingString, this.width / 2 - stringWidth / 2, 5, -1);
        stringWidth = this.font.width(this.info);
        guiGraphics.fill(this.width / 2 - stringWidth / 2, 20, this.width / 2 + stringWidth / 2, 30, 0x70000000);
        this.drawString(guiGraphics, this.info, this.width / 2 - stringWidth / 2, 20, -1);
    }

    protected void buttonActionEvent(AbstractButton button, ButtonAction action) {
        switch (action.ordinal()) {
            case 0: {
                this.setState(MenuState.ATTACK_TARGET);
                break;
            }
            case 1: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.DEFEND.getValue(), 0), PacketDistributor.SERVER.noArg());
                this.setState(MenuState.WAITING);
                break;
            }
            case 2: {
                this.setState(MenuState.ITEM_ACTION);
                break;
            }
            case 3: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.FLEE.getValue(), 0), PacketDistributor.SERVER.noArg());
                this.setState(MenuState.WAITING);
                break;
            }
            case 4: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case 5: {
                this.setState(MenuState.SWITCH_ITEM);
                break;
            }
            case 6: {
                this.setState(MenuState.USE_ITEM);
                break;
            }
            case 7: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case 8: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case 9: {
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    protected void entityButtonActionEvent(EntitySelectionButton button, ButtonAction action) {
        if (action.equals((Object)ButtonAction.ATTACK_TARGET)) {
            TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.ATTACK.getValue(), button.getID()), PacketDistributor.SERVER.noArg());
            this.setState(MenuState.WAITING);
        } else {
            this.setState(MenuState.MAIN_MENU);
        }
    }

    protected void itemButtonActionEvent(ItemSelectionButton button, ButtonAction action) {
        switch (action.ordinal()) {
            case 8: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.SWITCH_ITEM.getValue(), button.getID()), PacketDistributor.SERVER.noArg());
                if (button.getID() >= 0 && button.getID() < 9) {
                    Minecraft.getInstance().player.getInventory().setSelectedSlot(button.getID());
                }
                this.setState(MenuState.WAITING);
                break;
            }
            case 9: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.USE_ITEM.getValue(), button.getID()), PacketDistributor.SERVER.noArg());
                this.setState(MenuState.WAITING);
                break;
            }
            default: {
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int b, int c) {
        if (this.getMinecraft().player.isCreative()) {
            return super.keyPressed(keyCode, b, c);
        }
        if (keyCode == 256) {
            TurnBasedMinecraftMod.proxy.displayString("Leaving GUI, but the battle continues!");
            this.getMinecraft().setScreen(null);
            return true;
        }
        return false;
    }

    public void renderBackground(GuiGraphics p_283688_, int p_299421_, int p_298679_, float p_297268_) {
    }

    public boolean keyReleased(int a, int b, int c) {
        if (this.getMinecraft().player.isCreative()) {
            return super.keyReleased(a, b, c);
        }
        return false;
    }

    public void setTimeRemaining(int remaining) {
        this.timeRemaining.set(remaining);
    }

    private void drawString(GuiGraphics guiGraphics, String string, int x, int y, int color) {
        guiGraphics.drawString(this.font, string, x, y, color);
    }

    public void setTurnTimerEnabled(boolean enabled) {
        this.turnTimerEnabled = enabled;
    }

    public void setTurnTimerMax(int timerMax) {
        this.timerMax = timerMax;
    }

    private static enum MenuState {
        MAIN_MENU(0),
        ATTACK_TARGET(1),
        ITEM_ACTION(2),
        WAITING(3),
        SWITCH_ITEM(4),
        USE_ITEM(5);

        private int value;
        private static Map<Integer, MenuState> map;

        private MenuState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MenuState valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MenuState>();
            for (MenuState state : MenuState.values()) {
                map.put(state.getValue(), state);
            }
        }
    }

    private static enum ButtonAction {
        ATTACK(0),
        DEFEND(1),
        ITEM(2),
        FLEE(3),
        ATTACK_TARGET(4),
        SWITCH_HELD_ITEM(5),
        DECIDE_USE_ITEM(6),
        CANCEL(7),
        DO_ITEM_SWITCH(8),
        DO_USE_ITEM(9);

        private int value;
        private static Map<Integer, ButtonAction> map;

        private ButtonAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ButtonAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, ButtonAction>();
            for (ButtonAction action : ButtonAction.values()) {
                map.put(action.getValue(), action);
            }
        }
    }
}

