/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.TBMEntityButtonPress;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntitySelectionButton
implements Renderable,
GuiEventListener,
NarratableEntry {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean focused;
    private Button nestedButton;
    TBMEntityButtonPress onPress;
    private int entityID;
    private boolean isSideA;

    public EntitySelectionButton(int x, int y, int widthIn, int heightIn, String buttonText, int entityID, boolean isSideA, TBMEntityButtonPress onPress) {
        this.x = x;
        this.y = y;
        this.width = widthIn;
        this.height = heightIn;
        this.onPress = onPress;
        this.entityID = entityID;
        this.isSideA = isSideA;
        this.nestedButton = Button.builder((Component)Component.literal((String)buttonText), unused -> {}).pos(x, y).size(widthIn, heightIn).build();
    }

    public EntitySelectionButton(int x, int y, int widthIn, int heightIn, Component buttonTextComponent, int entityID, boolean isSideA, TBMEntityButtonPress onPress) {
        this.x = x;
        this.y = y;
        this.width = widthIn;
        this.height = heightIn;
        this.onPress = onPress;
        this.entityID = entityID;
        this.isSideA = isSideA;
        this.nestedButton = Button.builder((Component)buttonTextComponent, unused -> {}).pos(x, y).size(widthIn, heightIn).build();
    }

    public int getID() {
        return this.entityID;
    }

    public boolean getIsSideA() {
        return this.isSideA;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.nestedButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity e = Minecraft.getInstance().level.getEntity(this.entityID);
        if (e != null && e instanceof LivingEntity && ((LivingEntity)e).isAlive()) {
            int xoffset;
            int health = (int)(((LivingEntity)e).getHealth() + 0.5f);
            int xpos = this.x;
            if (this.isSideA) {
                xpos += this.width + 4;
                xoffset = 4;
            } else {
                xpos -= 6;
                xoffset = -4;
            }
            if (health > 200) {
                guiGraphics.fill(xpos, this.y + this.height * 4 / 5, xpos + 2, this.y + this.height, -65536);
                guiGraphics.fill(xpos, this.y + this.height * 3 / 5, xpos + 2, this.y + this.height * 4 / 5, -256);
                guiGraphics.fill(xpos, this.y + this.height * 2 / 5, xpos + 2, this.y + this.height * 3 / 5, -16711936);
                guiGraphics.fill(xpos, this.y + this.height / 5, xpos + 2, this.y + this.height * 2 / 5, -16711681);
                guiGraphics.fill(xpos, this.y, xpos + 2, this.y + this.height / 5, -16776961);
                int healthHeight = (health - 200) * this.height / 100;
                guiGraphics.fill(xpos + xoffset, this.y + this.height - healthHeight, xpos + xoffset + 2, this.y + this.height, -1);
            } else if (health > 100) {
                guiGraphics.fill(xpos, this.y + this.height * 4 / 5, xpos + 2, this.y + this.height, -65536);
                guiGraphics.fill(xpos, this.y + this.height * 3 / 5, xpos + 2, this.y + this.height * 4 / 5, -256);
                guiGraphics.fill(xpos, this.y + this.height * 2 / 5, xpos + 2, this.y + this.height * 3 / 5, -16711936);
                guiGraphics.fill(xpos, this.y + this.height / 5, xpos + 2, this.y + this.height * 2 / 5, -16711681);
                int healthHeight = (health - 100) * this.height / 100;
                guiGraphics.fill(xpos + xoffset, this.y + this.height - healthHeight, xpos + xoffset + 2, this.y + this.height, -16776961);
            } else if (health > 50) {
                guiGraphics.fill(xpos, this.y + this.height * 4 / 5, xpos + 2, this.y + this.height, -65536);
                guiGraphics.fill(xpos, this.y + this.height * 3 / 5, xpos + 2, this.y + this.height * 4 / 5, -256);
                guiGraphics.fill(xpos, this.y + this.height * 2 / 5, xpos + 2, this.y + this.height * 3 / 5, -16711936);
                int healthHeight = (health - 50) * this.height / 50;
                guiGraphics.fill(xpos + xoffset, this.y + this.height - healthHeight, xpos + xoffset + 2, this.y + this.height, -16711681);
            } else if (health > 20) {
                guiGraphics.fill(xpos, this.y + this.height * 4 / 5, xpos + 2, this.y + this.height, -65536);
                guiGraphics.fill(xpos, this.y + this.height * 3 / 5, xpos + 2, this.y + this.height * 4 / 5, -256);
                int healthHeight = (health - 20) * this.height / 30;
                guiGraphics.fill(xpos + xoffset, this.y + this.height - healthHeight, xpos + xoffset + 2, this.y + this.height, -16711936);
            } else if (health > 10) {
                guiGraphics.fill(xpos, this.y + this.height * 4 / 5, xpos + 2, this.y + this.height, -65536);
                int healthHeight = (health - 10) * this.height / 10;
                guiGraphics.fill(xpos + xoffset, this.y + this.height - healthHeight, xpos + xoffset + 2, this.y + this.height, -256);
            } else {
                int healthHeight = health * this.height / 10;
                guiGraphics.fill(xpos + xoffset, this.y + this.height - healthHeight, xpos + xoffset + 2, this.y + this.height, -65536);
            }
        }
    }

    public void onPress() {
        this.onPress.onPress(this);
    }

    public void setFocused(boolean b) {
        this.focused = b;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.FOCUSED;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.HINT, TurnBasedMinecraftMod.proxy.getEntity(this.entityID, (ResourceKey<Level>)Minecraft.getInstance().level.dimension()).getName());
    }

    public boolean mouseClicked(double x, double y, int unknown) {
        if (unknown == 0 && this.isMouseOver(x, y)) {
            this.onPress();
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }
}

