/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Utility {
    public static float yawDirection(double posX, double posZ, double targetX, double targetZ) {
        double radians = Math.atan2(targetZ - posZ, targetX - posX);
        if ((radians -= 1.5707963267948966) < 0.0) {
            radians += Math.PI * 2;
        }
        return (float)(radians * 180.0 / Math.PI);
    }

    public static float pitchDirection(double posX, double posY, double posZ, double targetX, double targetY, double targetZ) {
        double diffX = targetX - posX;
        double diffY = targetY - posY;
        double diffZ = targetZ - posZ;
        double distance = Math.sqrt(diffX * diffX + diffZ * diffZ);
        if (Math.abs(diffY) < 0.1) {
            return 0.0f;
        }
        return (float)(-Math.atan(diffY / distance) * 180.0 / Math.PI);
    }

    public static boolean doesPlayerHaveArrows(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!(player.getInventory().getItem(i).getItem() instanceof ArrowItem)) continue;
            return true;
        }
        return false;
    }

    public static double distanceBetweenEntities(Entity a, Entity b) {
        return Math.sqrt(Math.pow(a.getX() - b.getX(), 2.0) + Math.pow(a.getY() - b.getY(), 2.0) + Math.pow(a.getZ() - b.getZ(), 2.0));
    }

    public static String serializeDimension(ResourceKey<Level> dimObject) {
        return dimObject.registry().toString();
    }

    public static ResourceKey<Level> deserializeDimension(String dimString) {
        ResourceLocation dimRes = ResourceLocation.parse((String)dimString);
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimRes);
    }

    public static boolean isItemEdible(ItemStack itemStack) {
        return itemStack.get(DataComponents.FOOD) != null;
    }
}

