/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.function.BiConsumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.jetbrains.annotations.NotNull;

public record PacketBattlePing(int battleID, int decisionSeconds) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketBattlePing> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"com_burnedkirby_turnbasedminecraft", (String)"network_packetbattleping"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketBattlePing> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketBattlePing::battleID, (StreamCodec)ByteBufCodecs.VAR_INT, PacketBattlePing::decisionSeconds, PacketBattlePing::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Consumer
    implements BiConsumer<PacketBattlePing, CustomPayloadEvent.Context> {
        @Override
        public void accept(PacketBattlePing pkt, CustomPayloadEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
                    TurnBasedMinecraftMod.proxy.setBattleGuiAsGui();
                    TurnBasedMinecraftMod.proxy.setBattleGuiBattleChanged();
                    TurnBasedMinecraftMod.proxy.setBattleGuiTime(pkt.decisionSeconds);
                    TurnBasedMinecraftMod.proxy.pauseMCMusic();
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

