/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final ClientConfig CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    public final ModConfigSpec.ConfigValue<List<? extends String>> battleMusicList;
    public final ModConfigSpec.ConfigValue<List<? extends String>> sillyMusicList;
    public final ModConfigSpec.DoubleValue sillyMusicThreshold;
    public final ModConfigSpec.BooleanValue volumeAffectedByMasterVolume;
    public final ModConfigSpec.BooleanValue volumeAffectedByMusicVolume;
    public final ModConfigSpec.DoubleValue musicVolume;

    ClientConfig(ModConfigSpec.Builder builder) {
        ArrayList<String> battleMusicList = new ArrayList<String>(8);
        battleMusicList.add("monster");
        battleMusicList.add("animal");
        battleMusicList.add("boss");
        battleMusicList.add("player");
        this.battleMusicList = builder.comment("What categories of mobs that play \"battle\" music").translation("com_burnedkirby_turnbasedminecraft.clientconfig.battle_music_list").defineList("battleMusicList", battleMusicList, v -> v instanceof String);
        ArrayList<String> sillyMusicList = new ArrayList<String>(4);
        sillyMusicList.add("passive");
        this.sillyMusicList = builder.comment("What categories of mobs that play \"silly\" music").translation("com_burnedkirby_turnbasedminecraft.clientconfig.silly_music_list").defineList("sillyMusicList", sillyMusicList, v -> true);
        this.sillyMusicThreshold = builder.comment("Minimum percentage of silly entities in battle to use silly music").translation("com_burnedkirby_turnbasedminecraft.clientconfig.silly_percentage").defineInRange("sillyMusicThreshold", 0.4, 0.0, 1.0);
        this.volumeAffectedByMasterVolume = builder.comment("If \"true\", music volume will be affected by global Master volume setting").translation("com_burnedkirby_turnbasedminecraft.clientconfig.volume_affected_by_master").define("volumeAffectedByMasterVolume", true);
        this.volumeAffectedByMusicVolume = builder.comment("If \"true\", music volume will be affected by global Music volume setting").translation("com_burnedkirby_turnbasedminecraft.clientconfig.volume_affected_by_volume").define("volumeAffectedByMusicVolume", true);
        this.musicVolume = builder.comment("Volume of battle/silly music as a percentage between 0.0 and 1.0").translation("com_burnedkirby_turnbasedminecraft.clientconfig.music_volume").defineInRange("musicVolume", 0.7, 0.0, 1.0);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getKey();
        CLIENT_SPEC = (ModConfigSpec)pair.getValue();
    }
}

