/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.Comparator;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class Combatant {
    public Entity entity;
    public Battle.Decision decision;
    public int itemToUse;
    public EntityInfo entityInfo;
    public boolean recalcSpeedOnCompare;
    public int targetEntityID;
    public boolean isSideA;
    public int remainingDefenses;
    public int battleID;
    public double x;
    public double z;
    public float yaw;
    public float pitch;
    public long time;
    public int creeperTurns;
    public boolean willCreeperExplode;

    public Combatant() {
        this.decision = Battle.Decision.UNDECIDED;
        this.recalcSpeedOnCompare = false;
        this.remainingDefenses = 0;
        this.creeperTurns = 1;
        this.willCreeperExplode = false;
    }

    public Combatant(Entity e, EntityInfo entityInfo) {
        this.entity = e;
        this.decision = Battle.Decision.UNDECIDED;
        this.entityInfo = entityInfo;
        this.recalcSpeedOnCompare = false;
        this.remainingDefenses = 0;
        this.creeperTurns = 1;
        this.willCreeperExplode = false;
    }

    public void setWillCreeperExplode(boolean willExplode) {
        this.willCreeperExplode = willExplode;
    }

    public static class CombatantComparator
    implements Comparator<Combatant> {
        @Override
        public int compare(Combatant c0, Combatant c1) {
            boolean isSlow;
            boolean isHaste;
            if (c0.entity instanceof Player && c0.recalcSpeedOnCompare) {
                LivingEntity c0Entity = (LivingEntity)c0.entity;
                isHaste = false;
                isSlow = false;
                for (MobEffectInstance e : c0Entity.getActiveEffects()) {
                    if (e.getEffect().equals((Object)MobEffects.SPEED) || e.getEffect().equals((Object)MobEffects.HASTE)) {
                        isHaste = true;
                        continue;
                    }
                    if (!e.getEffect().equals((Object)MobEffects.SLOWNESS) && !e.getEffect().equals((Object)MobEffects.MINING_FATIGUE)) continue;
                    isSlow = true;
                }
                if (c0.entityInfo == null) {
                    c0.entityInfo = new EntityInfo();
                }
                c0.entityInfo.speed = isHaste && !isSlow ? TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed() : (isSlow && !isHaste ? TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed() : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed());
            }
            if (c1.entity instanceof Player && c1.recalcSpeedOnCompare) {
                LivingEntity c1Entity = (LivingEntity)c1.entity;
                isHaste = false;
                isSlow = false;
                for (MobEffectInstance e : c1Entity.getActiveEffects()) {
                    if (e.getEffect().equals((Object)MobEffects.SPEED)) {
                        isHaste = true;
                        continue;
                    }
                    if (!e.getEffect().equals((Object)MobEffects.SLOWNESS)) continue;
                    isSlow = true;
                }
                if (c1.entityInfo == null) {
                    c1.entityInfo = new EntityInfo();
                }
                c1.entityInfo.speed = isHaste && !isSlow ? TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed() : (isSlow && !isHaste ? TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed() : TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed());
            }
            if (c0.entityInfo.speed > c1.entityInfo.speed) {
                return -1;
            }
            if (c0.entityInfo.speed < c1.entityInfo.speed) {
                return 1;
            }
            return 0;
        }
    }
}

