/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.levelSystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lol.ysmu.levelSystem.LevelSystem;
import lol.ysmu.levelSystem.api.LevelSystemAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LevelManager
implements Listener,
CommandExecutor,
LevelSystemAPI {
    private final HashMap<UUID, Integer> xp = new HashMap();
    private final HashMap<UUID, Integer> level = new HashMap();
    private final HashMap<UUID, Integer> blocksMined = new HashMap();
    private final HashMap<UUID, Integer> killstreak = new HashMap();
    private final HashMap<UUID, Integer> playtimeSeconds = new HashMap();
    private final FileConfiguration config = LevelSystem.getInstance().getPluginConfig();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public LevelManager() {
        this.startPlaytimeTask();
    }

    public void addXP(Player player, int amount) {
        int currentXP;
        UUID uuid = player.getUniqueId();
        int currentLevel = this.level.getOrDefault(uuid, 1);
        int neededXP = currentLevel * 10;
        for (currentXP = this.xp.getOrDefault(uuid, 0) + amount; currentXP >= neededXP; currentXP -= neededXP) {
            neededXP = ++currentLevel * 10;
            this.sendMessage((CommandSender)player, this.config.getString("messages.level-up", ""), Map.of("%level%", String.valueOf(currentLevel)));
        }
        this.xp.put(uuid, currentXP);
        this.level.put(uuid, currentLevel);
        this.sendMessage((CommandSender)player, this.config.getString("messages.xp-gain", ""), Map.of("%xp%", String.valueOf(amount)));
    }

    @Override
    public int getXP(UUID uuid) {
        return this.xp.getOrDefault(uuid, 0);
    }

    @Override
    public int getLevel(UUID uuid) {
        return this.level.getOrDefault(uuid, 1);
    }

    @EventHandler
    public void onEntityKill(EntityDeathEvent event) {
        Monster monster;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Monster && (monster = (Monster)livingEntity).getKiller() != null) {
            this.addXP(monster.getKiller(), 3);
        }
    }

    @EventHandler
    public void onBowKill(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof Player) && !(event.getEntity() instanceof Monster)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingEntity) {
            Player shooter;
            Arrow arrow;
            EntityDamageByEntityEvent arrowEvent;
            Entity entity;
            LivingEntity livingEntity2 = livingEntity;
            Player killer = livingEntity2.getKiller();
            if (killer == null) {
                return;
            }
            EntityDamageEvent lastDamage = event.getEntity().getLastDamageCause();
            if (lastDamage instanceof EntityDamageByEntityEvent && (entity = (arrowEvent = (EntityDamageByEntityEvent)lastDamage).getDamager()) instanceof Arrow && (entity = (arrow = (Arrow)entity).getShooter()) instanceof Player && (shooter = (Player)entity).equals((Object)killer)) {
                this.addXP(killer, 4);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        this.blocksMined.put(player.getUniqueId(), this.blocksMined.getOrDefault(player.getUniqueId(), 0) + 1);
        this.addXP(player, 1);
    }

    @EventHandler
    public void onPlayerKill(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer != null && !killer.equals((Object)victim)) {
            this.killstreak.put(killer.getUniqueId(), this.killstreak.getOrDefault(killer.getUniqueId(), 0) + 1);
            this.addXP(killer, 5);
        }
        this.killstreak.put(victim.getUniqueId(), 0);
    }

    @EventHandler
    public void onFish(PlayerFishEvent event) {
        if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH) {
            this.addXP(event.getPlayer(), 2);
        }
    }

    @EventHandler
    public void onSmelt(FurnaceExtractEvent event) {
        if (event.getPlayer() != null) {
            this.addXP(event.getPlayer(), 1);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        FileConfiguration data = LevelSystem.getInstance().getDataFile();
        this.xp.put(uuid, data.getInt(String.valueOf(uuid) + ".xp", 0));
        this.level.put(uuid, data.getInt(String.valueOf(uuid) + ".level", 1));
        this.blocksMined.put(uuid, data.getInt(String.valueOf(uuid) + ".blocks-mined", 0));
        this.killstreak.put(uuid, data.getInt(String.valueOf(uuid) + ".killstreak", 0));
        this.playtimeSeconds.put(uuid, data.getInt(String.valueOf(uuid) + ".playtime-seconds", 0));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.saveAllData();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("level")) {
            if (!(sender instanceof Player)) {
                this.sendMessage(sender, this.config.getString("messages.only-players", ""), Map.of());
                return true;
            }
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            int currentXP = this.getXP(uuid);
            int currentLevel = this.getLevel(uuid);
            int neededXP = currentLevel * 10;
            this.sendMessage((CommandSender)player, this.config.getString("messages.level-display", ""), Map.of("%level%", String.valueOf(currentLevel)));
            this.sendMessage((CommandSender)player, this.config.getString("messages.xp-display", ""), Map.of("%xp%", String.valueOf(currentXP), "%needed%", String.valueOf(neededXP)));
            return true;
        }
        return false;
    }

    private void sendMessage(CommandSender sender, String raw, Map<String, String> placeholders) {
        if (raw == null || raw.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            raw = raw.replace(entry.getKey(), entry.getValue());
        }
        Component component = this.miniMessage.deserialize((Object)this.convertLegacyToMini(raw));
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.sendMessage(component);
        } else {
            Bukkit.getConsoleSender().sendMessage(component);
        }
    }

    private String convertLegacyToMini(String text) {
        return text.replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("&l", "<bold>").replace("&n", "<underlined>").replace("&o", "<italic>").replace("&m", "<strikethrough>").replace("&r", "<reset>");
    }

    private void startPlaytimeTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)LevelSystem.getInstance(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                UUID uuid = player.getUniqueId();
                int seconds = this.playtimeSeconds.getOrDefault(uuid, 0) + 60;
                this.playtimeSeconds.put(uuid, seconds);
                List rewards = this.config.getMapList("playtime.rewards");
                if (rewards == null) continue;
                for (Map rewardData : rewards) {
                    int interval = (Integer)rewardData.get("interval");
                    int reward = (Integer)rewardData.get("reward");
                    String message = (String)rewardData.get("message");
                    if (seconds < interval) continue;
                    this.playtimeSeconds.put(uuid, seconds - interval);
                    this.addXP(player, reward);
                    this.sendMessage((CommandSender)player, message, Map.of("%xp%", String.valueOf(reward)));
                }
            }
        }, 0L, 1200L);
    }

    public void saveAllData() {
        FileConfiguration data = LevelSystem.getInstance().getDataFile();
        for (UUID uuid : this.xp.keySet()) {
            data.set(String.valueOf(uuid) + ".xp", (Object)this.xp.get(uuid));
            data.set(String.valueOf(uuid) + ".level", (Object)this.level.getOrDefault(uuid, 1));
            data.set(String.valueOf(uuid) + ".blocks-mined", (Object)this.blocksMined.getOrDefault(uuid, 0));
            data.set(String.valueOf(uuid) + ".killstreak", (Object)this.killstreak.getOrDefault(uuid, 0));
            data.set(String.valueOf(uuid) + ".playtime-seconds", (Object)this.playtimeSeconds.getOrDefault(uuid, 0));
        }
        LevelSystem.getInstance().saveDataFile();
    }
}

