/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.levelSystem;

import java.util.UUID;
import lol.ysmu.levelSystem.LevelManager;
import lol.ysmu.levelSystem.LevelSystem;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class LevelPlaceholders
extends PlaceholderExpansion {
    private final LevelSystem plugin;

    public LevelPlaceholders(LevelSystem plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "levelsystem";
    }

    @NotNull
    public String getAuthor() {
        return "Nest";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer player, @NotNull String identifier) {
        if (!player.isOnline()) {
            return null;
        }
        LevelManager manager = this.plugin.getLevelManager();
        UUID uuid = player.getUniqueId();
        int xp = manager.getXP(uuid);
        int level = manager.getLevel(uuid);
        int neededXP = level * 10;
        return switch (identifier.toLowerCase()) {
            case "level" -> String.valueOf(level);
            case "xp" -> String.valueOf(xp);
            case "needed_xp" -> String.valueOf(neededXP);
            case "xp_display" -> "XP: " + xp + " / " + neededXP;
            default -> null;
        };
    }
}

