/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.levelSystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lol.ysmu.levelSystem.LevelSystem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LevelManager
implements Listener,
CommandExecutor {
    private final HashMap<UUID, Integer> xp = new HashMap();
    private final HashMap<UUID, Integer> level = new HashMap();
    private final HashMap<UUID, Integer> blocksMined = new HashMap();
    private final HashMap<UUID, Integer> killstreak = new HashMap();
    private final HashMap<UUID, Integer> playtimeSeconds = new HashMap();
    private final FileConfiguration config = LevelSystem.getInstance().getPluginConfig();

    public LevelManager() {
        this.startPlaytimeTask();
    }

    public void addXP(Player player, int amount) {
        int currentXP;
        UUID uuid = player.getUniqueId();
        int currentLevel = this.level.getOrDefault(uuid, 1);
        int neededXP = currentLevel * 10;
        for (currentXP = this.xp.getOrDefault(uuid, 0) + amount; currentXP >= neededXP; currentXP -= neededXP) {
            neededXP = ++currentLevel * 10;
            this.sendMessage((CommandSender)player, "messages.level-up", Map.of("%level%", String.valueOf(currentLevel)));
        }
        this.xp.put(uuid, currentXP);
        this.level.put(uuid, currentLevel);
        this.sendMessage((CommandSender)player, "messages.xp-gain", Map.of("%xp%", String.valueOf(amount)));
    }

    public int getXP(UUID uuid) {
        return this.xp.getOrDefault(uuid, 0);
    }

    public int getLevel(UUID uuid) {
        return this.level.getOrDefault(uuid, 1);
    }

    @EventHandler
    public void onPlayerKill(PlayerDeathEvent event) {
        Player killed = event.getEntity();
        Player killer = killed.getKiller();
        if (killer != null && !killer.equals((Object)killed)) {
            UUID killerId = killer.getUniqueId();
            this.addXP(killer, 5);
            int streak = this.killstreak.getOrDefault(killerId, 0) + 1;
            this.killstreak.put(killerId, streak);
            if (streak % 5 == 0) {
                int bonusXP = streak * 10;
                this.addXP(killer, bonusXP);
                this.sendMessage((CommandSender)killer, "messages.killstreak-bonus", Map.of("%xp%", String.valueOf(bonusXP), "%streak%", String.valueOf(streak)));
            }
            this.killstreak.put(killed.getUniqueId(), 0);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        int mined = this.blocksMined.getOrDefault(uuid, 0) + 1;
        this.blocksMined.put(uuid, mined);
        if (mined % 100 == 0) {
            this.addXP(player, 5);
            this.sendMessage((CommandSender)player, "messages.block-milestone", Map.of("%blocks%", String.valueOf(mined)));
        }
        if (mined % 500 == 0) {
            this.addXP(player, 20);
            this.sendMessage((CommandSender)player, "messages.block-milestone-500", Map.of("%blocks%", String.valueOf(mined)));
        }
    }

    @EventHandler
    public void onEntityKill(EntityDeathEvent event) {
        Monster monster;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Monster && (monster = (Monster)livingEntity).getKiller() != null) {
            this.addXP(monster.getKiller(), 3);
        }
    }

    @EventHandler
    public void onBowKill(EntityDeathEvent event) {
        Player shooter;
        Arrow arrow;
        EntityDamageByEntityEvent arrowEvent;
        Entity entity;
        if (!(event.getEntity() instanceof Player) && !(event.getEntity() instanceof Monster)) {
            return;
        }
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        EntityDamageEvent lastDamage = event.getEntity().getLastDamageCause();
        if (lastDamage instanceof EntityDamageByEntityEvent && (entity = (arrowEvent = (EntityDamageByEntityEvent)lastDamage).getDamager()) instanceof Arrow && (entity = (arrow = (Arrow)entity).getShooter()) instanceof Player && (shooter = (Player)entity).equals((Object)killer)) {
            this.addXP(killer, 4);
        }
    }

    @EventHandler
    public void onFish(PlayerFishEvent event) {
        if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH) {
            this.addXP(event.getPlayer(), 2);
        }
    }

    @EventHandler
    public void onSmelt(FurnaceExtractEvent event) {
        this.addXP(event.getPlayer(), event.getExpToDrop());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        FileConfiguration data = LevelSystem.getInstance().getDataFile();
        this.xp.put(uuid, data.getInt(String.valueOf(uuid) + ".xp", 0));
        this.level.put(uuid, data.getInt(String.valueOf(uuid) + ".level", 1));
        this.blocksMined.put(uuid, data.getInt(String.valueOf(uuid) + ".blocks-mined", 0));
        this.killstreak.put(uuid, data.getInt(String.valueOf(uuid) + ".killstreak", 0));
        this.playtimeSeconds.put(uuid, data.getInt(String.valueOf(uuid) + ".playtime-seconds", 0));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        FileConfiguration data = LevelSystem.getInstance().getDataFile();
        data.set(String.valueOf(uuid) + ".xp", (Object)this.xp.getOrDefault(uuid, 0));
        data.set(String.valueOf(uuid) + ".level", (Object)this.level.getOrDefault(uuid, 1));
        data.set(String.valueOf(uuid) + ".blocks-mined", (Object)this.blocksMined.getOrDefault(uuid, 0));
        data.set(String.valueOf(uuid) + ".killstreak", (Object)this.killstreak.getOrDefault(uuid, 0));
        data.set(String.valueOf(uuid) + ".playtime-seconds", (Object)this.playtimeSeconds.getOrDefault(uuid, 0));
        LevelSystem.getInstance().saveDataFile();
    }

    public void saveAllData() {
        FileConfiguration data = LevelSystem.getInstance().getDataFile();
        for (UUID uuid : this.xp.keySet()) {
            data.set(String.valueOf(uuid) + ".xp", (Object)this.xp.get(uuid));
            data.set(String.valueOf(uuid) + ".level", (Object)this.level.getOrDefault(uuid, 1));
            data.set(String.valueOf(uuid) + ".blocks-mined", (Object)this.blocksMined.getOrDefault(uuid, 0));
            data.set(String.valueOf(uuid) + ".killstreak", (Object)this.killstreak.getOrDefault(uuid, 0));
            data.set(String.valueOf(uuid) + ".playtime-seconds", (Object)this.playtimeSeconds.getOrDefault(uuid, 0));
        }
        LevelSystem.getInstance().saveDataFile();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("level")) {
            if (!(sender instanceof Player)) {
                this.sendMessage(sender, "messages.only-players", Map.of());
                return true;
            }
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            int currentXP = this.getXP(uuid);
            int currentLevel = this.getLevel(uuid);
            int neededXP = currentLevel * 10;
            this.sendMessage((CommandSender)player, "messages.level-display", Map.of("%level%", String.valueOf(currentLevel)));
            this.sendMessage((CommandSender)player, "messages.xp-display", Map.of("%xp%", String.valueOf(currentXP), "%needed%", String.valueOf(neededXP)));
            return true;
        }
        if (label.equalsIgnoreCase("adminlevel")) {
            if (args.length < 2) {
                this.sendMessage(sender, "messages.usage-adminlevel", Map.of());
                return true;
            }
            String sub = args[0];
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                this.sendMessage(sender, "messages.not-found", Map.of());
                return true;
            }
            UUID uuid = target.getUniqueId();
            try {
                switch (sub.toLowerCase()) {
                    case "add": {
                        if (args.length < 3) {
                            this.sendMessage(sender, "messages.usage-adminlevel", Map.of());
                            return true;
                        }
                        int amt = Integer.parseInt(args[2]);
                        this.addXP(target, amt);
                        this.sendMessage(sender, "messages.admin-updated", Map.of("%player%", target.getName(), "%xp%", String.valueOf(this.getXP(uuid))));
                        break;
                    }
                    case "set": {
                        if (args.length < 3) {
                            this.sendMessage(sender, "messages.usage-adminlevel", Map.of());
                            return true;
                        }
                        int amt = Integer.parseInt(args[2]);
                        this.xp.put(uuid, amt);
                        this.sendMessage(sender, "messages.admin-updated", Map.of("%player%", target.getName(), "%xp%", String.valueOf(amt)));
                        break;
                    }
                    case "remove": {
                        if (args.length < 3) {
                            this.sendMessage(sender, "messages.usage-adminlevel", Map.of());
                            return true;
                        }
                        int amt = Integer.parseInt(args[2]);
                        this.xp.put(uuid, Math.max(0, this.getXP(uuid) - amt));
                        this.sendMessage(sender, "messages.admin-updated", Map.of("%player%", target.getName(), "%xp%", String.valueOf(this.getXP(uuid))));
                        break;
                    }
                    case "reset": {
                        this.xp.put(uuid, 0);
                        this.level.put(uuid, 1);
                        this.killstreak.put(uuid, 0);
                        this.blocksMined.put(uuid, 0);
                        this.playtimeSeconds.put(uuid, 0);
                        this.sendMessage(sender, "messages.admin-updated", Map.of("%player%", target.getName(), "%xp%", "0"));
                        break;
                    }
                    default: {
                        this.sendMessage(sender, "messages.usage-adminlevel", Map.of());
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be a number.");
            }
            return true;
        }
        return false;
    }

    private void sendMessage(CommandSender sender, String path, Map<String, String> placeholders) {
        String msg = this.config.getString(path, "");
        if (msg == null || msg.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            msg = msg.replace(entry.getKey(), entry.getValue());
        }
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    private void startPlaytimeTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)LevelSystem.getInstance(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                UUID uuid = player.getUniqueId();
                int seconds = this.playtimeSeconds.getOrDefault(uuid, 0) + 60;
                this.playtimeSeconds.put(uuid, seconds);
                List rewards = this.config.getMapList("playtime.rewards");
                if (rewards == null) continue;
                for (Map rewardData : rewards) {
                    int interval = (Integer)rewardData.get("interval");
                    int reward = (Integer)rewardData.get("reward");
                    String message = (String)rewardData.get("message");
                    if (seconds < interval) continue;
                    this.playtimeSeconds.put(uuid, seconds - interval);
                    this.addXP(player, reward);
                    this.sendMessage((CommandSender)player, message, Map.of("%xp%", String.valueOf(reward)));
                }
            }
        }, 0L, 1200L);
    }
}

