/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.levelSystem;

import java.io.File;
import java.io.IOException;
import lol.ysmu.levelSystem.LevelManager;
import lol.ysmu.levelSystem.LevelPlaceholders;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LevelSystem
extends JavaPlugin {
    private static LevelSystem instance;
    private LevelManager levelManager;
    private FileConfiguration config;
    private FileConfiguration data;
    private File dataFile;

    public LevelManager getLevelManager() {
        return this.levelManager;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadDataFile();
        this.levelManager = new LevelManager();
        this.getServer().getPluginManager().registerEvents((Listener)this.levelManager, (Plugin)this);
        this.getCommand("level").setExecutor((CommandExecutor)this.levelManager);
        this.getCommand("adminlevel").setExecutor((CommandExecutor)this.levelManager);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new LevelPlaceholders(this).register();
        }
        this.getLogger().info("LevelSystem enabled.");
    }

    public void onDisable() {
        this.levelManager.saveAllData();
        this.saveDataFile();
        this.getLogger().info("LevelSystem disabled.");
    }

    private void loadDataFile() {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.getParentFile().mkdirs();
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void saveDataFile() {
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LevelSystem getInstance() {
        return instance;
    }

    public FileConfiguration getDataFile() {
        return this.data;
    }

    public FileConfiguration getPluginConfig() {
        return this.config;
    }
}

