/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class MushroomTVBlock
extends SmallFurnitureBlock {
    public static final IntegerProperty CHANNEL = IntegerProperty.m_61631_((String)"channel", (int)0, (int)4);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)7.0, (double)12.0), (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0));
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)7.0, (double)10.0), (VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0));
    private static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)10.0, (double)7.0, (double)14.0), (VoxelShape)Block.m_49796_((double)4.0, (double)7.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)12.0, (double)7.0, (double)14.0), (VoxelShape)Block.m_49796_((double)4.0, (double)7.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));

    public MushroomTVBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CHANNEL, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean isWaterlogged = pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged))).m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)CHANNEL) == 0 ? 0 : 6;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Integer)pState.m_61143_((Property)CHANNEL) * 3;
    }

    private void updateNeighbors(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46672_(pPos, (Block)this);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_) {
            int channel = (Integer)pState.m_61143_((Property)CHANNEL);
            channel = channel < 4 ? ++channel : 0;
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)CHANNEL, (Comparable)Integer.valueOf(channel)), 10);
            pLevel.m_247517_(null, pPos, SoundEvents.f_12444_, SoundSource.BLOCKS);
            this.updateNeighbors(pState, pLevel, pPos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.m_60713_(pNewState.m_60734_())) {
            this.updateNeighbors(pState, pLevel, pPos);
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{CHANNEL});
    }
}

