/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.entity.CustomStorageBlockEntity;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class CottageBookcaseBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_N_1 = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_S_1 = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E_1 = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W_1 = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N_2 = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0));
    private static final VoxelShape SHAPE_S_2 = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)6.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_E_2 = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_W_2 = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0));
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.m_61631_((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}}, new int[][]{{2}}};

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if ((Integer)pState.m_61143_((Property)MULTIBLOCK_PART) != 1) {
            return InteractionResult.FAIL;
        }
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos1 = this.findBlockState1(pPos, (LevelAccessor)pLevel);
        BlockEntity blockEntity = pLevel.m_7702_(pos1);
        if (blockEntity instanceof CustomStorageBlockEntity) {
            pPlayer.m_5893_((MenuProvider)((CustomStorageBlockEntity)blockEntity));
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.m_61143_((Property)MULTIBLOCK_PART);
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (part == 1) {
                    yield SHAPE_S_1;
                }
                yield SHAPE_S_2;
            }
            case Direction.EAST -> {
                if (part == 1) {
                    yield SHAPE_E_1;
                }
                yield SHAPE_E_2;
            }
            case Direction.WEST -> {
                if (part == 1) {
                    yield SHAPE_W_1;
                }
                yield SHAPE_W_2;
            }
            default -> part == 1 ? SHAPE_N_1 : SHAPE_N_2;
        };
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.m_61143_((Property)MULTIBLOCK_PART) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.THREE_ROWS_BE.get()).m_155264_(blockPos, blockState);
    }

    public CottageBookcaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }
}

