/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class BlueMushroomFoliagePlacer
extends FoliagePlacer {
    public static final Codec<BlueMushroomFoliagePlacer> CODEC = RecordCodecBuilder.create(blueMushroomFoliagePlacerInstance -> BlueMushroomFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)blueMushroomFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)blueMushroomFoliagePlacerInstance, BlueMushroomFoliagePlacer::new));
    private final int height;

    public BlueMushroomFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.BLUE_MUSHROOM_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        for (int i = 0; i < this.height; ++i) {
            this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_(), 3 + i, -i, pAttachment.m_68590_());
        }
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        double distance = Math.sqrt(Math.pow(pLocalX, 2.0) + Math.pow(pLocalZ, 2.0));
        if (pLocalY < 0) {
            if (-pLocalY == this.height - 1) {
                // empty if block
            }
            return distance > (double)((float)this.height + 0.3f - (float)pLocalY) || distance < (double)(this.height - pLocalY) - 1.7;
        }
        return distance > (double)this.height - 0.4 - (double)pLocalY;
    }
}

