/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class PoplarFoliagePlacer
extends FoliagePlacer {
    public static final Codec<PoplarFoliagePlacer> CODEC = RecordCodecBuilder.create(poplarFoliagePlacerInstance -> PoplarFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)poplarFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)poplarFoliagePlacerInstance, PoplarFoliagePlacer::new));
    private final int height;

    public PoplarFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.POPLAR_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int i, FoliagePlacer.FoliageAttachment foliageAttachment, int i1, int i2, int i3) {
        BlockPos nextPos = foliageAttachment.m_161451_();
        int maxHeight = this.height + randomSource.m_216339_(-1, 1);
        int topHeight = randomSource.m_216339_(1, 3);
        for (int j = 0; j < maxHeight; ++j) {
            if (j == 0) {
                PoplarFoliagePlacer.m_272253_((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)nextPos.m_7494_());
            }
            int radius = 2;
            if (j < topHeight) {
                radius = 1;
            }
            if (maxHeight - j < 3) {
                radius = 1;
            }
            this.m_225628_(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, nextPos, radius, 0, foliageAttachment.m_68590_());
            nextPos = nextPos.m_7495_();
        }
    }

    public int m_214116_(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean b) {
        return pLocalX == pRange && pLocalZ == pRange && (pRandom.m_216339_(0, 2) == 0 || pLocalY == 0);
    }
}

