/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class RedMushroomFoliagePlacer
extends FoliagePlacer {
    public static final Codec<RedMushroomFoliagePlacer> CODEC = RecordCodecBuilder.create(redMushroomFoliagePlacerInstance -> RedMushroomFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)redMushroomFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)redMushroomFoliagePlacerInstance, RedMushroomFoliagePlacer::new));
    private final int height;

    public RedMushroomFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.RED_MUSHROOM_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        float layerSize = (float)(this.height / 5) - 0.001f;
        for (int i = 0; i < this.height; ++i) {
            if ((float)i < 2.0f * layerSize) {
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_(), 1, -i, pAttachment.m_68590_());
                continue;
            }
            if ((float)i < 4.0f * layerSize) {
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_(), 2, -i, pAttachment.m_68590_());
                continue;
            }
            this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_(), 3, -i, pAttachment.m_68590_());
        }
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        float layerSize = (float)(this.height / 5) - 0.001f;
        if ((float)(-pLocalY) < 1.0f * layerSize) {
            return pLocalX == pLocalZ && pLocalX == pRange;
        }
        if ((float)(-pLocalY) < 2.0f * layerSize) {
            return false;
        }
        if ((float)(-pLocalY) < 4.0f * layerSize) {
            return pLocalX == pLocalZ && pLocalX == pRange || pLocalX <= 1 && pLocalZ <= 1;
        }
        return Math.abs(pLocalX) + Math.abs(pLocalZ) >= pRange * 2 - 1 || pLocalX <= 1 && pLocalZ <= 1;
    }
}

