/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;
import org.jetbrains.annotations.Nullable;

public class BracketBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH_UP = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_NORTH_DOWN = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_EAST_UP = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_EAST_DOWN = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)6.0, (double)9.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_SOUTH_UP = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)6.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_SOUTH_DOWN = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)6.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_WEST_UP = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)10.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_WEST_DOWN = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)6.0, (double)9.0), (VoxelShape)Block.m_49796_((double)10.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SUPPORT_SHAPE_UP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SUPPORT_SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty OFFSET = BooleanProperty.m_61465_((String)"offset");
    public static final BooleanProperty IS_UP = BooleanProperty.m_61465_((String)"is_up");

    public BracketBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OFFSET, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean shouldBeUP;
        Direction clickedFace = pContext.m_43719_();
        boolean bl = shouldBeUP = pContext.m_43720_().f_82480_ - (double)pContext.m_8083_().m_123342_() > 0.5;
        if (clickedFace.equals((Object)Direction.DOWN) || clickedFace.equals((Object)Direction.UP)) {
            shouldBeUP = clickedFace.equals((Object)Direction.DOWN);
            clickedFace = pContext.m_8125_().m_122424_();
        }
        BlockState behindState = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(clickedFace.m_122424_()));
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)clickedFace)).m_61124_((Property)OFFSET, (Comparable)Boolean.valueOf(behindState.m_204336_(BlockTags.f_13039_) || behindState.m_204336_(BlockTags.f_13098_)))).m_61124_((Property)IS_UP, (Comparable)Boolean.valueOf(shouldBeUP));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"cluttered.bracket.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        boolean is_up = (Boolean)pState.m_61143_((Property)IS_UP);
        if (((Boolean)pState.m_61143_((Property)OFFSET)).booleanValue()) {
            return switch (facing) {
                case Direction.SOUTH -> {
                    if (is_up) {
                        yield SHAPE_SOUTH_UP;
                    }
                    yield SHAPE_SOUTH_DOWN;
                }
                case Direction.EAST -> {
                    if (is_up) {
                        yield SHAPE_EAST_UP;
                    }
                    yield SHAPE_EAST_DOWN;
                }
                case Direction.WEST -> {
                    if (is_up) {
                        yield SHAPE_WEST_UP;
                    }
                    yield SHAPE_WEST_DOWN;
                }
                default -> is_up ? SHAPE_NORTH_UP : SHAPE_NORTH_DOWN;
            };
        }
        VoxelShape shapeH = switch (facing) {
            case Direction.SOUTH -> SUPPORT_SHAPE_SOUTH;
            case Direction.EAST -> SUPPORT_SHAPE_EAST;
            case Direction.WEST -> SUPPORT_SHAPE_WEST;
            default -> SUPPORT_SHAPE_NORTH;
        };
        VoxelShape shapeV = is_up ? SUPPORT_SHAPE_UP : SUPPORT_SHAPE_DOWN;
        return Shapes.m_83110_((VoxelShape)shapeH, (VoxelShape)shapeV);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OFFSET}).m_61104_(new Property[]{IS_UP});
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        boolean is_up = (Boolean)pState.m_61143_((Property)IS_UP);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (is_up) {
                    yield SHAPE_SOUTH_UP;
                }
                yield SHAPE_SOUTH_DOWN;
            }
            case Direction.EAST -> {
                if (is_up) {
                    yield SHAPE_EAST_UP;
                }
                yield SHAPE_EAST_DOWN;
            }
            case Direction.WEST -> {
                if (is_up) {
                    yield SHAPE_WEST_UP;
                }
                yield SHAPE_WEST_DOWN;
            }
            default -> is_up ? SHAPE_NORTH_UP : SHAPE_NORTH_DOWN;
        };
    }
}

