/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.entity.CustomStorageBlockEntity;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.m_61631_((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}}, new int[][]{{2}}};

    public FridgeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public static void setOpenAndClosed(Level level, BlockPos pos, BlockState state, boolean open) {
        int part = (Integer)state.m_61143_((Property)MULTIBLOCK_PART);
        BlockPos otherHalfPos = part == 1 ? pos.m_7494_() : pos.m_7495_();
        BlockState otherHalfBlock = level.m_8055_(otherHalfPos);
        if (state.m_61138_((Property)OPEN)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 2);
            if (level.m_8055_(otherHalfPos).m_60734_().equals(state.m_60734_()) && (Integer)otherHalfBlock.m_61143_((Property)MULTIBLOCK_PART) != part) {
                level.m_7731_(otherHalfPos, (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open))).m_61124_((Property)MULTIBLOCK_PART, (Comparable)Integer.valueOf(part == 1 ? 2 : 1)), 2);
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_6047_()) {
            BlockPos pos1 = this.findBlockState1(pPos, (LevelAccessor)pLevel);
            BlockEntity blockEntity = pLevel.m_7702_(pos1);
            if (blockEntity instanceof CustomStorageBlockEntity) {
                pPlayer.m_5893_((MenuProvider)((CustomStorageBlockEntity)blockEntity));
                return InteractionResult.CONSUME;
            }
        } else {
            FridgeBlock.setOpenAndClosed(pLevel, pPos, pState, (Boolean)pState.m_61143_((Property)OPEN) == false);
            pLevel.m_247517_(null, pPos, (Boolean)pState.m_61143_((Property)OPEN) != false ? SoundEvents.f_12055_ : SoundEvents.f_12056_, SoundSource.BLOCKS);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return super.getMultiblockPart();
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.m_61143_((Property)MULTIBLOCK_PART) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.RETRO_FRIDGE_BE.get()).m_155264_(blockPos, blockState);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OPEN});
    }
}

