/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class CrabappleFoliagePlacer
extends FoliagePlacer {
    public static final Codec<CrabappleFoliagePlacer> CODEC = RecordCodecBuilder.create(crabappleFoliagePlacerInstance -> CrabappleFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)crabappleFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)crabappleFoliagePlacerInstance, CrabappleFoliagePlacer::new));
    private final int height;

    public CrabappleFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.CRABAPPLE_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        for (int i = 0; i < this.height; ++i) {
            if (i == 0) {
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_7494_(), 1, -i, pAttachment.m_68590_());
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_7494_(), 1, 1, pAttachment.m_68590_());
                continue;
            }
            if (i < 2) {
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_7494_(), 2, -i, pAttachment.m_68590_());
                continue;
            }
            if (i != this.height - 1) continue;
            this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.m_161451_().m_7494_(), 1, -i, pAttachment.m_68590_());
        }
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        double distance = Math.sqrt(Math.pow(pLocalX, 2.0) + Math.pow(pLocalZ, 2.0));
        if (pLocalY == 0) {
            return pLocalX == pLocalZ && pLocalX == pRange && pRandom.m_188499_();
        }
        if (pLocalY == 1) {
            return pLocalX == pLocalZ && pLocalX == pRange || pRandom.m_188501_() < 0.14f;
        }
        return distance > (double)pRange;
    }
}

