/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.jatica;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.item.Tiers;
import thelm.jaopca.api.config.IDynamicSpecConfig;

public class MaterialConfig {
    private IDynamicSpecConfig config;
    private final Supplier<Boolean> materialCraftable = () -> this.config.getDefinedBoolean("jatica.material.craftable", true, "If true, this material is allowed to be crafted in the part builder.");
    private final Supplier<Boolean> materialCastable = () -> this.config.getDefinedBoolean("jatica.material.castable", true, "If true, this material is allowed to be cast in the smeltery.");
    private final Supplier<Boolean> materialMeltable = () -> this.config.getDefinedBoolean("jatica.material.meltable", true, "If true, this material is allowed to be melted in the smeltery.");
    private final Supplier<Integer> materialTier = () -> this.config.getDefinedInt("jatica.material.tier", 1, "Material tier.");
    private final Supplier<Integer> materialSortOrder = () -> this.config.getDefinedInt("jatica.material.sort_order", 0, "Sort order within the tier.");
    private final Supplier<Boolean> materialHidden = () -> this.config.getDefinedBoolean("jatica.material.hidden", false, "If true, this material is not shown in the book or as part of material items, though it may still show in crafting blocks.");
    private final Supplier<List<String>> materialFluid = () -> this.config.getDefinedStringList("jatica.material.fluid", new ArrayList(), "List of fluids for this material. If empty, the default fluid tag will be used.");
    private final Supplier<List<String>> traitsDefault = () -> this.config.getDefinedStringList("jatica.traits.default", new ArrayList(), "List of default traits for this material.");
    private final Supplier<List<String>> traitsMeleeHarvest = () -> this.config.getDefinedStringList("jatica.traits.melee_harvest", new ArrayList(), "List of melee/harvest traits for this material.");
    private final Supplier<List<String>> traitsRanged = () -> this.config.getDefinedStringList("jatica.traits.ranged", new ArrayList(), "List of ranged traits for this material.");
    private final Supplier<List<String>> traitsArmor = () -> this.config.getDefinedStringList("jatica.traits.armor", new ArrayList(), "List of armor traits for this material.");
    private final Supplier<Boolean> headEnabled = () -> this.config.getDefinedBoolean("jatica.head.enabled", false, "If true, add the head parts.");
    private final Supplier<Integer> headDurability = () -> this.config.getDefinedInt("jatica.head.durability", 60, "Durability value.");
    private final Supplier<Float> headMiningSpeed = () -> Float.valueOf(this.config.getDefinedFloat("jatica.head.mining_speed", 2.0f, "Mining speed value."));
    private final Supplier<Tiers> headMiningTier = () -> (Tiers)this.config.getDefinedEnum("jatica.head.mining_tier", Tiers.class, (Enum)Tiers.WOOD, "Mining tier value.");
    private final Supplier<Float> headAttackDamage = () -> Float.valueOf(this.config.getDefinedFloat("jatica.head.attack_damage", 0.0f, "Attack damage value."));
    private final Supplier<List<String>> headTraits = () -> this.config.getDefinedStringList("jatica.head.traits", new ArrayList(), "List of head traits for this material.");
    private final Supplier<Boolean> handleEnabled = () -> this.config.getDefinedBoolean("jatica.handle.enabled", false, "If true, add the handle parts.");
    private final Supplier<Float> handleDurability = () -> Float.valueOf(this.config.getDefinedFloat("jatica.handle.durability", 1.0f, "Durability multiplier."));
    private final Supplier<Float> handleAttackDamage = () -> Float.valueOf(this.config.getDefinedFloat("jatica.handle.attack_damage", 1.0f, "Attack damage multiplier."));
    private final Supplier<Float> handleAttackSpeed = () -> Float.valueOf(this.config.getDefinedFloat("jatica.handle.attack_speed", 1.0f, "Attack speed multiplier."));
    private final Supplier<Float> handleMiningSpeed = () -> Float.valueOf(this.config.getDefinedFloat("jatica.handle.mining_speed", 1.0f, "Mining speed multiplier."));
    private final Supplier<List<String>> handleTraits = () -> this.config.getDefinedStringList("jatica.handle.traits", new ArrayList(), "List of handle traits for this material.");
    private final Supplier<Boolean> bindingEnabled = () -> this.config.getDefinedBoolean("jatica.binding.enabled", false, "If true, add the binding parts.");
    private final Supplier<List<String>> bindingTraits = () -> this.config.getDefinedStringList("jatica.binding.traits", new ArrayList(), "List of binding traits for this material.");
    private final Supplier<Boolean> limbEnabled = () -> this.config.getDefinedBoolean("jatica.limb.enabled", false, "If true, add the limb parts.");
    private final Supplier<Integer> limbDurability = () -> this.config.getDefinedInt("jatica.limb.durability", 60, "Durability value.");
    private final Supplier<Float> limbDrawSpeed = () -> Float.valueOf(this.config.getDefinedFloat("jatica.limb.draw_speed", 0.0f, "Draw speed value."));
    private final Supplier<Float> limbVelocity = () -> Float.valueOf(this.config.getDefinedFloat("jatica.limb.velocity", 0.0f, "Velocity value."));
    private final Supplier<Float> limbAccuracy = () -> Float.valueOf(this.config.getDefinedFloat("jatica.limb.accuracy", 0.0f, "Accuracy value."));
    private final Supplier<List<String>> limbTraits = () -> this.config.getDefinedStringList("jatica.limb.traits", new ArrayList(), "List of limb traits for this material.");
    private final Supplier<Boolean> gripEnabled = () -> this.config.getDefinedBoolean("jatica.grip.enabled", false, "If true, add the grip parts.");
    private final Supplier<Float> gripDurability = () -> Float.valueOf(this.config.getDefinedFloat("jatica.grip.durability", 1.0f, "Durability multiplier."));
    private final Supplier<Float> gripAccuracy = () -> Float.valueOf(this.config.getDefinedFloat("jatica.grip.accuracy", 1.0f, "Accuracy multiplier."));
    private final Supplier<Float> gripAttackDamage = () -> Float.valueOf(this.config.getDefinedFloat("jatica.grip.attack_damage", 1.0f, "Attack damage multiplier."));
    private final Supplier<List<String>> gripTraits = () -> this.config.getDefinedStringList("jatica.grip.traits", new ArrayList(), "List of grip traits for this material.");
    private final Supplier<Boolean> bowstringEnabled = () -> this.config.getDefinedBoolean("jatica.bowstring.enabled", false, "If true, add the bowstring parts.");
    private final Supplier<List<String>> bowstringTraits = () -> this.config.getDefinedStringList("jatica.bowstring.traits", new ArrayList(), "List of bowstring traits for this material.");
    private final Supplier<Boolean> platingHelmetEnabled = () -> this.config.getDefinedBoolean("jatica.plating.helmet_enabled", false, "If true, add the helmet plating.");
    private final Supplier<Boolean> platingChestplateEnabled = () -> this.config.getDefinedBoolean("jatica.plating.chestplate_enabled", false, "If true, add the chestplate plating.");
    private final Supplier<Boolean> platingLeggingsEnabled = () -> this.config.getDefinedBoolean("jatica.plating.leggings_enabled", false, "If true, add the leggings plating.");
    private final Supplier<Boolean> platingBootsEnabled = () -> this.config.getDefinedBoolean("jatica.plating.boots_enabled", false, "If true, add the boots plating.");
    private final Supplier<Boolean> platingShieldEnabled = () -> this.config.getDefinedBoolean("jatica.plating.shield_enabled", false, "If true, add the shield plating.");
    private final Supplier<Float> platingHelmetArmor = () -> Float.valueOf(this.config.getDefinedFloat("jatica.plating.helmet_armor", 0.0f, "Armor value for helmet plating."));
    private final Supplier<Float> platingChestplateArmor = () -> Float.valueOf(this.config.getDefinedFloat("jatica.plating.chestplate_armor", 0.0f, "Armor value for chestplate plating."));
    private final Supplier<Float> platingLeggingsArmor = () -> Float.valueOf(this.config.getDefinedFloat("jatica.plating.leggings_armor", 0.0f, "Armor value for leggings plating."));
    private final Supplier<Float> platingBootsArmor = () -> Float.valueOf(this.config.getDefinedFloat("jatica.plating.boots_armor", 0.0f, "Armor value for boots plating."));
    private final Supplier<Float> platingDurabilityFactor = () -> Float.valueOf(this.config.getDefinedFloat("jatica.plating.durability_factor", 16.0f, "Durability factor for all plating."));
    private final Supplier<Float> platingToughness = () -> Float.valueOf(this.config.getDefinedFloat("jatica.plating.toughness", 0.0f, "Toughness value for all plating."));
    private final Supplier<Float> platingKnockbackResistance = () -> Float.valueOf(this.config.getDefinedFloat("jatica.plating.knockback_resistance", 0.0f, "Knockback resistance value for all plating."));
    private final Supplier<List<String>> platingTraitsHelmet = () -> this.config.getDefinedStringList("jatica.plating.helmet_traits", new ArrayList(), "List of helmet plating traits for this material.");
    private final Supplier<List<String>> platingTraitsChestplate = () -> this.config.getDefinedStringList("jatica.plating.chestplate_traits", new ArrayList(), "List of chestplate plating traits for this material.");
    private final Supplier<List<String>> platingTraitsLeggings = () -> this.config.getDefinedStringList("jatica.plating.leggings_traits", new ArrayList(), "List of leggings plating traits for this material.");
    private final Supplier<List<String>> platingTraitsBoots = () -> this.config.getDefinedStringList("jatica.plating.boots_traits", new ArrayList(), "List of boots plating traits for this material.");
    private final Supplier<List<String>> platingTraitsShield = () -> this.config.getDefinedStringList("jatica.plating.shield_traits", new ArrayList(), "List of shield plating traits for this material.");
    private final Supplier<Boolean> mailleEnabled = () -> this.config.getDefinedBoolean("jatica.maille.enabled", false, "If true, add the maille parts.");
    private final Supplier<List<String>> mailleTraits = () -> this.config.getDefinedStringList("jatica.maille.traits", new ArrayList(), "List of maille traits for this material.");
    private final Supplier<Boolean> repairKitEnabled = () -> this.config.getDefinedBoolean("jatica.repair_kit.enabled", false, "If true, add the repair kit.");

    public MaterialConfig(IDynamicSpecConfig config) {
        this.config = config;
        List<Supplier> allConfigs = List.of(this.materialCraftable, this.materialCastable, this.materialMeltable, this.materialTier, this.materialSortOrder, this.materialHidden, this.materialFluid, this.traitsDefault, this.traitsMeleeHarvest, this.traitsRanged, this.traitsArmor, this.headEnabled, this.headDurability, this.headMiningSpeed, this.headMiningTier, this.headAttackDamage, this.headTraits, this.handleEnabled, this.handleDurability, this.handleAttackDamage, this.handleAttackSpeed, this.handleMiningSpeed, this.handleTraits, this.bindingEnabled, this.bindingTraits, this.limbEnabled, this.limbDurability, this.limbDrawSpeed, this.limbVelocity, this.limbAccuracy, this.limbTraits, this.gripEnabled, this.gripDurability, this.gripAccuracy, this.gripAttackDamage, this.gripTraits, this.bowstringEnabled, this.bowstringTraits, this.platingHelmetEnabled, this.platingChestplateEnabled, this.platingLeggingsEnabled, this.platingBootsEnabled, this.platingShieldEnabled, this.platingHelmetArmor, this.platingChestplateArmor, this.platingLeggingsArmor, this.platingBootsArmor, this.platingDurabilityFactor, this.platingToughness, this.platingKnockbackResistance, this.platingTraitsHelmet, this.platingTraitsChestplate, this.platingTraitsLeggings, this.platingTraitsBoots, this.platingTraitsShield, this.mailleEnabled, this.mailleTraits, this.repairKitEnabled);
        allConfigs.forEach(Supplier::get);
    }

    public List<String> enabledParts() {
        return Stream.of(this.headEnabled.get() != false ? "head" : "", this.handleEnabled.get() != false ? "handle" : "", this.bindingEnabled.get() != false ? "binding" : "", this.limbEnabled.get() != false ? "limb" : "", this.gripEnabled.get() != false ? "grip" : "", this.bowstringEnabled.get() != false ? "bowstring" : "", this.platingHelmetEnabled.get() != false ? "plating_helmet" : "", this.platingChestplateEnabled.get() != false ? "plating_chestplate" : "", this.platingLeggingsEnabled.get() != false ? "plating_leggings" : "", this.platingBootsEnabled.get() != false ? "plating_boots" : "", this.platingShieldEnabled.get() != false ? "plating_shield" : "", this.mailleEnabled.get() != false ? "maille" : "", this.repairKitEnabled.get() != false ? "repair_kit" : "").filter(s -> !s.isEmpty()).map(s -> "tconstruct:" + s).toList();
    }

    public Supplier<Boolean> getMaterialCraftable() {
        return this.materialCraftable;
    }

    public Supplier<Boolean> getMaterialCastable() {
        return this.materialCastable;
    }

    public Supplier<Boolean> getMaterialMeltable() {
        return this.materialMeltable;
    }

    public Supplier<Integer> getMaterialTier() {
        return this.materialTier;
    }

    public Supplier<Integer> getMaterialSortOrder() {
        return this.materialSortOrder;
    }

    public Supplier<Boolean> getMaterialHidden() {
        return this.materialHidden;
    }

    public Supplier<List<String>> getMaterialFluid() {
        return this.materialFluid;
    }

    public Supplier<List<String>> getTraitsDefault() {
        return this.traitsDefault;
    }

    public Supplier<List<String>> getTraitsMeleeHarvest() {
        return this.traitsMeleeHarvest;
    }

    public Supplier<List<String>> getTraitsRanged() {
        return this.traitsRanged;
    }

    public Supplier<List<String>> getTraitsArmor() {
        return this.traitsArmor;
    }

    public Supplier<Boolean> getHeadEnabled() {
        return this.headEnabled;
    }

    public Supplier<Integer> getHeadDurability() {
        return this.headDurability;
    }

    public Supplier<Float> getHeadMiningSpeed() {
        return this.headMiningSpeed;
    }

    public Supplier<Tiers> getHeadMiningTier() {
        return this.headMiningTier;
    }

    public Supplier<Float> getHeadAttackDamage() {
        return this.headAttackDamage;
    }

    public Supplier<List<String>> getHeadTraits() {
        return this.headTraits;
    }

    public Supplier<Boolean> getHandleEnabled() {
        return this.handleEnabled;
    }

    public Supplier<Float> getHandleDurability() {
        return this.handleDurability;
    }

    public Supplier<Float> getHandleAttackDamage() {
        return this.handleAttackDamage;
    }

    public Supplier<Float> getHandleAttackSpeed() {
        return this.handleAttackSpeed;
    }

    public Supplier<Float> getHandleMiningSpeed() {
        return this.handleMiningSpeed;
    }

    public Supplier<List<String>> getHandleTraits() {
        return this.handleTraits;
    }

    public Supplier<Boolean> getBindingEnabled() {
        return this.bindingEnabled;
    }

    public Supplier<List<String>> getBindingTraits() {
        return this.bindingTraits;
    }

    public Supplier<Boolean> getLimbEnabled() {
        return this.limbEnabled;
    }

    public Supplier<Integer> getLimbDurability() {
        return this.limbDurability;
    }

    public Supplier<Float> getLimbDrawSpeed() {
        return this.limbDrawSpeed;
    }

    public Supplier<Float> getLimbVelocity() {
        return this.limbVelocity;
    }

    public Supplier<Float> getLimbAccuracy() {
        return this.limbAccuracy;
    }

    public Supplier<List<String>> getLimbTraits() {
        return this.limbTraits;
    }

    public Supplier<Boolean> getGripEnabled() {
        return this.gripEnabled;
    }

    public Supplier<Float> getGripDurability() {
        return this.gripDurability;
    }

    public Supplier<Float> getGripAccuracy() {
        return this.gripAccuracy;
    }

    public Supplier<Float> getGripAttackDamage() {
        return this.gripAttackDamage;
    }

    public Supplier<List<String>> getGripTraits() {
        return this.gripTraits;
    }

    public Supplier<Boolean> getBowstringEnabled() {
        return this.bowstringEnabled;
    }

    public Supplier<List<String>> getBowstringTraits() {
        return this.bowstringTraits;
    }

    public Supplier<Boolean> getPlatingHelmetEnabled() {
        return this.platingHelmetEnabled;
    }

    public Supplier<Boolean> getPlatingChestplateEnabled() {
        return this.platingChestplateEnabled;
    }

    public Supplier<Boolean> getPlatingLeggingsEnabled() {
        return this.platingLeggingsEnabled;
    }

    public Supplier<Boolean> getPlatingBootsEnabled() {
        return this.platingBootsEnabled;
    }

    public Supplier<Boolean> getPlatingShieldEnabled() {
        return this.platingShieldEnabled;
    }

    public Supplier<Float> getPlatingHelmetArmor() {
        return this.platingHelmetArmor;
    }

    public Supplier<Float> getPlatingChestplateArmor() {
        return this.platingChestplateArmor;
    }

    public Supplier<Float> getPlatingLeggingsArmor() {
        return this.platingLeggingsArmor;
    }

    public Supplier<Float> getPlatingBootsArmor() {
        return this.platingBootsArmor;
    }

    public Supplier<Float> getPlatingDurabilityFactor() {
        return this.platingDurabilityFactor;
    }

    public Supplier<Float> getPlatingToughness() {
        return this.platingToughness;
    }

    public Supplier<Float> getPlatingKnockbackResistance() {
        return this.platingKnockbackResistance;
    }

    public Supplier<List<String>> getPlatingTraitsHelmet() {
        return this.platingTraitsHelmet;
    }

    public Supplier<List<String>> getPlatingTraitsChestplate() {
        return this.platingTraitsChestplate;
    }

    public Supplier<List<String>> getPlatingTraitsLeggings() {
        return this.platingTraitsLeggings;
    }

    public Supplier<List<String>> getPlatingTraitsBoots() {
        return this.platingTraitsBoots;
    }

    public Supplier<List<String>> getPlatingTraitsShield() {
        return this.platingTraitsShield;
    }

    public Supplier<Boolean> getMailleEnabled() {
        return this.mailleEnabled;
    }

    public Supplier<List<String>> getMailleTraits() {
        return this.mailleTraits;
    }

    public Supplier<Boolean> getRepairKitEnabled() {
        return this.repairKitEnabled;
    }
}

