/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.jatica;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.bluesheep.jatica.MaterialConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Tier;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;
import thelm.jaopca.api.materials.IMaterial;

public class TiCMaterialHelper {
    private static final Gson gson = new Gson();

    public static JsonObject materialDefinitionProvider(MaterialConfig config) {
        JsonObject materialDefinition = new JsonObject();
        materialDefinition.addProperty("craftable", config.getMaterialCraftable().get());
        materialDefinition.addProperty("tier", (Number)config.getMaterialTier().get());
        materialDefinition.addProperty("sortOrder", (Number)config.getMaterialSortOrder().get());
        materialDefinition.addProperty("hidden", config.getMaterialHidden().get());
        return materialDefinition;
    }

    public static JsonElement materialStatsProvider(MaterialConfig config) {
        ArrayList<IMaterialStats> stats = new ArrayList<IMaterialStats>();
        if (config.getHeadEnabled().get().booleanValue()) {
            HeadMaterialStats headStats = new HeadMaterialStats(config.getHeadDurability().get().intValue(), config.getHeadMiningSpeed().get().floatValue(), (Tier)config.getHeadMiningTier().get(), config.getHeadAttackDamage().get().floatValue());
            stats.add((IMaterialStats)headStats);
        }
        if (config.getHandleEnabled().get().booleanValue()) {
            HandleMaterialStats handleStats = HandleMaterialStats.multipliers().durability(config.getHandleDurability().get().floatValue()).attackDamage(config.getHandleAttackDamage().get().floatValue()).attackSpeed(config.getHandleAttackSpeed().get().floatValue()).miningSpeed(config.getHandleMiningSpeed().get().floatValue()).build();
            stats.add((IMaterialStats)handleStats);
        }
        if (config.getBindingEnabled().get().booleanValue()) {
            stats.add((IMaterialStats)StatlessMaterialStats.BINDING);
        }
        if (config.getLimbEnabled().get().booleanValue()) {
            LimbMaterialStats limbStats = new LimbMaterialStats(config.getLimbDurability().get().intValue(), config.getLimbDrawSpeed().get().floatValue(), config.getLimbVelocity().get().floatValue(), config.getLimbAccuracy().get().floatValue());
            stats.add((IMaterialStats)limbStats);
        }
        if (config.getGripEnabled().get().booleanValue()) {
            GripMaterialStats gripStats = new GripMaterialStats(config.getGripDurability().get().floatValue(), config.getGripAccuracy().get().floatValue(), config.getGripAttackDamage().get().floatValue());
            stats.add((IMaterialStats)gripStats);
        }
        if (config.getBowstringEnabled().get().booleanValue()) {
            stats.add((IMaterialStats)StatlessMaterialStats.BOWSTRING);
        }
        Map<ArmorItem.Type, Boolean> enabledArmor = Map.of(ArmorItem.Type.HELMET, config.getPlatingHelmetEnabled().get(), ArmorItem.Type.CHESTPLATE, config.getPlatingChestplateEnabled().get(), ArmorItem.Type.LEGGINGS, config.getPlatingLeggingsEnabled().get(), ArmorItem.Type.BOOTS, config.getPlatingBootsEnabled().get());
        PlatingMaterialStats.Builder platingStats = PlatingMaterialStats.builder().durabilityFactor(config.getPlatingDurabilityFactor().get().floatValue()).armor(config.getPlatingBootsArmor().get().floatValue(), config.getPlatingLeggingsArmor().get().floatValue(), config.getPlatingChestplateArmor().get().floatValue(), config.getPlatingHelmetArmor().get().floatValue()).toughness(config.getPlatingToughness().get().floatValue()).knockbackResistance(config.getPlatingKnockbackResistance().get().floatValue());
        for (Map.Entry<ArmorItem.Type, Boolean> armor : enabledArmor.entrySet()) {
            if (!armor.getValue().booleanValue()) continue;
            stats.add((IMaterialStats)platingStats.build(armor.getKey()));
        }
        if (config.getPlatingShieldEnabled().get().booleanValue()) {
            stats.add((IMaterialStats)platingStats.buildShield());
        }
        if (config.getMailleEnabled().get().booleanValue()) {
            stats.add((IMaterialStats)StatlessMaterialStats.MAILLE);
        }
        if (config.getRepairKitEnabled().get().booleanValue()) {
            stats.add((IMaterialStats)StatlessMaterialStats.REPAIR_KIT);
        }
        return gson.toJsonTree((Object)TiCMaterialHelper.convert(stats));
    }

    public static JsonElement materialTraitsProvider(MaterialConfig config) {
        JsonObject root = new JsonObject();
        TiCMaterialHelper.setTraits(root, "default", config.getTraitsDefault().get());
        JsonObject perStat = new JsonObject();
        TiCMaterialHelper.setTraits(perStat, "tconstruct:melee_harvest", config.getTraitsMeleeHarvest().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:head", config.getHeadTraits().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:handle", config.getHandleTraits().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:binding", config.getBindingTraits().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:ranged", config.getTraitsRanged().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:limb", config.getLimbTraits().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:grip", config.getGripTraits().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:bowstring", config.getBowstringTraits().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:armor", config.getTraitsArmor().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:plating_helmet", config.getPlatingTraitsHelmet().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:plating_chestplate", config.getPlatingTraitsChestplate().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:plating_leggings", config.getPlatingTraitsLeggings().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:plating_boots", config.getPlatingTraitsBoots().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:plating_shield", config.getPlatingTraitsShield().get());
        TiCMaterialHelper.setTraits(perStat, "tconstruct:maille", config.getMailleTraits().get());
        root.add("perStat", (JsonElement)perStat);
        return root;
    }

    public static JsonObject materialRenderInfoProvider(IMaterial material, MaterialConfig config) {
        String color = Integer.toHexString(material.getColor());
        JsonArray fallbacks = new JsonArray();
        fallbacks.add("metal");
        JsonArray supported_stats = new JsonArray();
        config.enabledParts().forEach(arg_0 -> ((JsonArray)supported_stats).add(arg_0));
        JsonArray palette = new JsonArray();
        for (int i : new int[]{255, 216, 178, 140, 102, 63, 0}) {
            JsonObject paletteElement = new JsonObject();
            paletteElement.addProperty("color", color);
            paletteElement.addProperty("grey", (Number)i);
            palette.add((JsonElement)paletteElement);
        }
        JsonObject transformer = new JsonObject();
        transformer.addProperty("type", "tconstruct:grey_to_sprite");
        transformer.add("palette", (JsonElement)palette);
        JsonObject generator = new JsonObject();
        generator.add("supported_stats", (JsonElement)supported_stats);
        generator.add("transformer", (JsonElement)transformer);
        JsonObject root = new JsonObject();
        root.addProperty("color", color);
        root.add("fallbacks", (JsonElement)fallbacks);
        root.add("generator", (JsonElement)generator);
        return root;
    }

    public static JsonObject mantleColorsProvider(Map<String, String> materialColors) {
        JsonObject colorsObject = new JsonObject();
        materialColors.forEach((arg_0, arg_1) -> ((JsonObject)colorsObject).addProperty(arg_0, arg_1));
        JsonObject root = new JsonObject();
        root.add("material.jatica", (JsonElement)colorsObject);
        return root;
    }

    private static void setTraits(JsonObject json, String statId, List<String> traits) {
        if (traits.isEmpty()) {
            return;
        }
        JsonArray traitsArray = new JsonArray();
        if (!Objects.equals(traits.get(0), "NONE")) {
            traits.forEach(traitString -> {
                JsonObject trait = new JsonObject();
                String[] traitParts = traitString.split(" ");
                trait.addProperty("name", traitParts[0]);
                if (traitParts.length > 1) {
                    try {
                        int level = Integer.parseInt(traitParts[1]);
                        trait.addProperty("level", (Number)level);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                traitsArray.add((JsonElement)trait);
            });
        }
        json.add(statId, (JsonElement)traitsArray);
    }

    private static MaterialStatJson convert(List<IMaterialStats> stats) {
        return new MaterialStatJson(stats.stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, stat -> TiCMaterialHelper.encodeStats(stat, stat.getType()))));
    }

    private static <T extends IMaterialStats> JsonElement encodeStats(IMaterialStats stats, MaterialStatType<T> type) {
        return type.getLoadable().serialize((Object)stats);
    }
}

