/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.jatica;

import com.google.gson.JsonElement;
import dev.bluesheep.jatica.JATiCA;
import dev.bluesheep.jatica.MaterialConfig;
import dev.bluesheep.jatica.TiCMaterialHelper;
import dev.bluesheep.jatica.recipes.MaterialFluidRecipeSerializer;
import dev.bluesheep.jatica.recipes.MaterialMeltingRecipeSerializer;
import dev.bluesheep.jatica.recipes.MaterialRecipeSerializer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.api.resources.IInMemoryResourcePack;

@JAOPCAModule(modDependencies={"tconstruct"})
public class TiCMaterialModule
implements IModule {
    private final JAOPCAApi api = JAOPCAApi.instance();
    private Map<IMaterial, IDynamicSpecConfig> configs;

    public String getName() {
        return "jatica_materials";
    }

    public boolean isPassive() {
        return true;
    }

    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        IMiscHelper miscHelper = this.api.miscHelper();
        for (IMaterial material : moduleData.getMaterials()) {
            Supplier<Fluid> fluidSupplier;
            MaterialConfig config = new MaterialConfig(this.configs.get(material));
            this.api.registerRecipe(JATiCA.rl("tools/materials/" + material.getName() + "/material"), (IRecipeSerializer)new MaterialRecipeSerializer(material, material.getType().getFormName(), 1, 1));
            this.api.registerRecipe(JATiCA.rl("tools/materials/" + material.getName() + "/block"), (IRecipeSerializer)new MaterialRecipeSerializer(material, "storage_blocks", material.isSmallStorageBlock() ? 4 : 9, 1, new ResourceLocation("forge", material.getType().getFormName() + "/" + material.getName())));
            this.api.registerRecipe(JATiCA.rl("tools/materials/" + material.getName() + "/nugget"), (IRecipeSerializer)new MaterialRecipeSerializer(material, "nuggets", 1, 9));
            int fluidAmount = Arrays.stream(MaterialType.INGOTS).anyMatch(materialType -> material.getType().equals(materialType)) ? 90 : 100;
            List<String> definedFluids = config.getMaterialFluid().get();
            if (config.getMaterialCastable().get().booleanValue()) {
                fluidSupplier = this.getPreferredFluidSupplier(material, definedFluids, miscHelper);
                this.api.registerRecipe(JATiCA.rl("tools/materials/molten/" + material.getName()), (IRecipeSerializer)new MaterialFluidRecipeSerializer(material, fluidAmount, fluidSupplier));
            }
            if (!config.getMaterialMeltable().get().booleanValue()) continue;
            fluidSupplier = this.getPreferredFluidSupplier(material, definedFluids, miscHelper);
            this.api.registerRecipe(JATiCA.rl("tools/materials/melting/" + material.getName()), (IRecipeSerializer)new MaterialMeltingRecipeSerializer(material, fluidAmount, fluidSupplier));
        }
    }

    public void onCreateDataPack(IModuleData moduleData, IInMemoryResourcePack dataPack) {
        for (IMaterial material : moduleData.getMaterials()) {
            MaterialConfig materialConfig = new MaterialConfig(this.configs.get(material));
            dataPack.putJson(PackType.SERVER_DATA, JATiCA.rl("tinkering/materials/definition/" + material.getName() + ".json"), (JsonElement)TiCMaterialHelper.materialDefinitionProvider(materialConfig));
            dataPack.putJson(PackType.SERVER_DATA, JATiCA.rl("tinkering/materials/stats/" + material.getName() + ".json"), TiCMaterialHelper.materialStatsProvider(materialConfig));
            dataPack.putJson(PackType.SERVER_DATA, JATiCA.rl("tinkering/materials/traits/" + material.getName() + ".json"), TiCMaterialHelper.materialTraitsProvider(materialConfig));
        }
    }

    public void onCreateResourcePack(IModuleData moduleData, IInMemoryResourcePack resourcePack) {
        HashMap<String, String> materialColors = new HashMap<String, String>();
        for (IMaterial material : moduleData.getMaterials()) {
            materialColors.put(material.getName(), "#" + Integer.toHexString(material.getColor()).substring(2));
            resourcePack.putJson(PackType.CLIENT_RESOURCES, JATiCA.rl("tinkering/materials/" + material.getName() + ".json"), (JsonElement)TiCMaterialHelper.materialRenderInfoProvider(material, new MaterialConfig(this.configs.get(material))));
        }
        resourcePack.putJson(PackType.CLIENT_RESOURCES, JATiCA.rl("mantle/colors.json"), (JsonElement)TiCMaterialHelper.mantleColorsProvider(materialColors));
    }

    private Supplier<Fluid> getPreferredFluidSupplier(IMaterial material, List<String> definedFluids, IMiscHelper miscHelper) {
        Supplier<List> fluids = definedFluids.isEmpty() ? () -> Stream.concat(miscHelper.getFluidTagValues(miscHelper.getTagLocation("molten", material.getName(), "_")).stream(), miscHelper.getFluidTagValues(new ResourceLocation("tconstruct", "molten_" + material.getName())).stream()).toList() : () -> definedFluids.stream().map(fluidId -> miscHelper.getFluidStack(fluidId, 1).getFluid()).toList();
        return () -> miscHelper.getPreferredFluidStack((Iterable)fluids.get(), 1).getFluid();
    }
}

