/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.jatica.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.recipes.IRecipeSerializer;

public class MaterialMeltingRecipeSerializer
implements IRecipeSerializer {
    private final IMaterial material;
    private final int amount;
    private final Supplier<Fluid> fluidSupplier;

    public MaterialMeltingRecipeSerializer(IMaterial material, int amount, Supplier<Fluid> fluidSupplier) {
        this.material = material;
        this.amount = amount;
        this.fluidSupplier = fluidSupplier;
    }

    public JsonElement get() {
        JsonObject fluidIngredient = new JsonObject();
        fluidIngredient.addProperty("fluid", Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.fluidSupplier.get())).toString());
        fluidIngredient.addProperty("amount", (Number)this.amount);
        JsonObject root = new JsonObject();
        root.addProperty("type", "tconstruct:material_melting");
        root.addProperty("input", "jatica:" + this.material.getName());
        root.addProperty("temperature", (Number)Mth.m_14045_((int)(this.fluidSupplier.get().getFluidType().getTemperature() - 300), (int)0, (int)Integer.MAX_VALUE));
        root.add("result", (JsonElement)fluidIngredient);
        return root;
    }
}

