/*
 * Decompiled with CFR 0.152.
 */
package dev.bluesheep.jatica.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.recipes.IRecipeSerializer;

public class MaterialRecipeSerializer
implements IRecipeSerializer {
    private final IMaterial material;
    private final String type;
    private final int materialValue;
    private final int needed;
    private final ResourceLocation itemTag;

    public MaterialRecipeSerializer(IMaterial material, String type, int materialValue, int needed) {
        this.material = material;
        this.type = type;
        this.materialValue = materialValue;
        this.needed = needed;
        this.itemTag = null;
    }

    public MaterialRecipeSerializer(IMaterial material, String type, int materialValue, int needed, ResourceLocation itemTag) {
        this.material = material;
        this.type = type;
        this.materialValue = materialValue;
        this.needed = needed;
        this.itemTag = itemTag;
    }

    public JsonElement get() {
        IMiscHelper miscHelper = JAOPCAApi.instance().miscHelper();
        JsonObject leftOver = new JsonObject();
        if (this.itemTag != null) {
            leftOver.addProperty("tag", this.itemTag.toString());
            leftOver.addProperty("count", (Number)1);
        }
        JsonObject root = new JsonObject();
        root.addProperty("type", "tconstruct:material");
        root.add("ingredient", miscHelper.getIngredient((Object)miscHelper.getTagLocation(this.type, this.material.getName())).m_43942_());
        root.addProperty("material", "jatica:" + this.material.getName());
        root.addProperty("needed", (Number)this.needed);
        root.addProperty("value", (Number)this.materialValue);
        root.add("leftover", (JsonElement)leftOver);
        return root;
    }
}

