/*
 * Decompiled with CFR 0.152.
 */
package ranger;

import java.io.File;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import ranger.RASounds;
import ranger.RangerCommon;
import ranger.blocks.RABlockLoader;
import ranger.command.CommandClass;
import ranger.command.CommandLevel;
import ranger.command.CommandNation;
import ranger.effects.EffectRegistry;
import ranger.entities.EntityCustomHorse;
import ranger.entities.EntityInitialSpawn;
import ranger.entities.EntityKalkara;
import ranger.entities.EntityMorgarath;
import ranger.entities.EntityNightWarrior;
import ranger.entities.EntityRAStandard;
import ranger.entities.EntityTemujaiGeneral;
import ranger.entities.EntityThrowingKnife;
import ranger.entities.EntityThrowingWeapon;
import ranger.entities.EntityWargal;
import ranger.entities.EntityYusal;
import ranger.items.RAItemLoader;
import ranger.packet.PacketAction;
import ranger.packet.PacketAttackEntity;
import ranger.packet.PacketClimb;
import ranger.packet.PacketCommandHired;
import ranger.packet.PacketCraft;
import ranger.packet.PacketOpenRAGui;
import ranger.packet.PacketResetCooldown;
import ranger.packet.PacketSetInt;
import ranger.packet.PacketSetValue;
import ranger.packet.PacketSyncRpgData;
import ranger.packet.PacketUpdateHired;
import ranger.packet.PacketUseLookSkill;
import ranger.packet.PacketUseSkillPoint;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.RpgDataStorage;
import ranger.structures.RAWorldGen;
import ranger.util.RACrafting;
import ranger.util.RangerKeybinds;

@Mod(modid="ranger", name="Ranger's Apprentice Mod", version="1.5", acceptedMinecraftVersions="[1.12.2]")
public class Ranger {
    public static final String VERSION = "1.5";
    public static final String RESOURCE_LOCATION = "ranger";
    public static SimpleNetworkWrapper RANGER_CHANNEL;
    public static final boolean developerEnvironment;
    public static File mcDir;
    @SidedProxy(clientSide="ranger.RangerClient", serverSide="ranger.RangerCommon")
    public static RangerCommon proxy;
    private int packetID;
    private int entityId = 0;

    public static boolean isServer() {
        return FMLCommonHandler.instance().getSide() == Side.SERVER;
    }

    private int getNextPacketID() {
        return this.packetID++;
    }

    private int getNextEntityId() {
        return this.entityId++;
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new CommandNation());
        manager.func_71560_a((ICommand)new CommandClass());
        manager.func_71560_a((ICommand)new CommandLevel());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        mcDir = event.getModConfigurationDirectory().getParentFile();
        RANGER_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("ranger_channel");
        RANGER_CHANNEL.registerMessage(PacketAction.Handler.class, PacketAction.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketSetValue.Handler.class, PacketSetValue.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketSetInt.Handler.class, PacketSetInt.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketUseSkillPoint.Handler.class, PacketUseSkillPoint.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketUpdateHired.Handler.class, PacketUpdateHired.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketCommandHired.Handler.class, PacketCommandHired.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketCraft.Handler.class, PacketCraft.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketAttackEntity.Handler.class, PacketAttackEntity.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketUseLookSkill.Handler.class, PacketUseLookSkill.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketClimb.Handler.class, PacketClimb.class, this.getNextPacketID(), Side.SERVER);
        RANGER_CHANNEL.registerMessage(PacketSyncRpgData.Handler.class, PacketSyncRpgData.class, this.getNextPacketID(), Side.CLIENT);
        RANGER_CHANNEL.registerMessage(PacketOpenRAGui.Handler.class, PacketOpenRAGui.class, this.getNextPacketID(), Side.CLIENT);
        RANGER_CHANNEL.registerMessage(PacketResetCooldown.Handler.class, PacketResetCooldown.class, this.getNextPacketID(), Side.CLIENT);
        RARpgManager.init();
        RASounds.init();
        EffectRegistry.init();
        RAItemLoader.init();
        RABlockLoader.init();
        RangerKeybinds.init();
        RACrafting.registerRecipes();
        ArrayList<Biome> vanillaBiomes = new ArrayList<Biome>();
        for (ResourceLocation key : Biome.field_185377_q.func_148742_b()) {
            Biome biome;
            if (!"minecraft".equals(key.func_110624_b()) || (biome = (Biome)Biome.field_185377_q.func_82594_a((Object)key)) == null || biome == Biomes.field_76779_k || biome == Biomes.field_76778_j || biome == Biomes.field_185440_P || biome == Biomes.field_76771_b) continue;
            vanillaBiomes.add(biome);
        }
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "ra_humanoid"), EntityRAStandard.class, (String)"ra_humanoid", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.addSpawn(EntityRAStandard.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])vanillaBiomes.toArray(new Biome[0]));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "kalkara"), EntityKalkara.class, (String)"kalkara", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "wargal"), EntityWargal.class, (String)"wargal", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.addSpawn(EntityWargal.class, (int)10, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])vanillaBiomes.toArray(new Biome[0]));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "ra_horse"), EntityCustomHorse.class, (String)"ra_horse", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "throwing_knife"), EntityThrowingKnife.class, (String)"throwing_knife", (int)this.getNextEntityId(), (Object)this, (int)50, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "spear"), EntityThrowingWeapon.class, (String)"throwing_knife", (int)this.getNextEntityId(), (Object)this, (int)50, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "morgarath"), EntityMorgarath.class, (String)"morgarath", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "night_warrior"), EntityNightWarrior.class, (String)"night_warrior", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "yusal"), EntityYusal.class, (String)"yusal", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "temujai_general"), EntityTemujaiGeneral.class, (String)"temujai_general", (int)this.getNextEntityId(), (Object)this, (int)100, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(RESOURCE_LOCATION, "initial_spawn"), EntityInitialSpawn.class, (String)"initial_spawn", (int)999, (Object)this, (int)50, (int)3, (boolean)false);
        EntityRegistry.addSpawn(EntityInitialSpawn.class, (int)50, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])vanillaBiomes.toArray(new Biome[0]));
        proxy.preInit();
        CapabilityManager.INSTANCE.register(IRpgData.class, (Capability.IStorage)new RpgDataStorage(), RpgData::new);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new RAWorldGen(), (int)0);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    static {
        developerEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

