/*
 * Decompiled with CFR 0.152.
 */
package ranger.blocks;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;
import ranger.blocks.BlockAleBarrel;
import ranger.blocks.BlockRACrafting;
import ranger.blocks.BlockRope;
import ranger.rpg.Nation;
import ranger.rpg.RARpgManager;

public class RABlockLoader {
    public static Map<String, Block> blocks = new LinkedHashMap<String, Block>();
    public static final String ROPE = "rope";
    public static final String ALE_BARREL = "ale_barrel";
    public static Map<String, String> craftingTableMap = new HashMap<String, String>();

    public static void init() {
        RABlockLoader.registerBlock(new BlockRope(), ROPE, "Rope");
        RABlockLoader.registerBlock(new BlockAleBarrel(), ALE_BARREL, "Ale Barrel");
        for (Nation nation : RARpgManager.nationMap.values()) {
            for (String classId : nation.classes) {
                if (classId.equalsIgnoreCase(RARpgManager.ClassId.KALKARA.getId()) || classId.equalsIgnoreCase(RARpgManager.ClassId.BANDIT.getId())) continue;
                String blockId = "crafting_table_" + classId;
                RABlockLoader.registerBlock(new BlockRACrafting(classId, Material.field_151575_d), blockId, WordUtils.capitalize((String)classId.replace("_", " ")) + " Crafting Table");
                craftingTableMap.put(classId, blockId);
            }
        }
        for (Block block : blocks.values()) {
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            ItemBlock b = new ItemBlock(block);
            b.setRegistryName(block.getRegistryName());
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)b);
        }
    }

    public static Block getBlock(String id) {
        return blocks.getOrDefault(id, Blocks.field_150350_a);
    }

    public static void registerBlock(Block block, String id, String name) {
        block.setRegistryName(id.toLowerCase());
        block.func_149663_c("ranger." + id);
        blocks.put(id, block);
    }
}

