/*
 * Decompiled with CFR 0.152.
 */
package ranger.entities;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import ranger.entities.EntityCapedMob;
import ranger.entities.EntityRAHumanoid;
import ranger.items.RAItemLoader;
import ranger.rpg.RpgData;

public class EntityNightWarrior
extends EntityCapedMob {
    private static final DataParameter<Integer> CLONE_TIMER = EntityDataManager.func_187226_a(EntityNightWarrior.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CLONE = EntityDataManager.func_187226_a(EntityNightWarrior.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityNightWarrior(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 2.5f);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRAHumanoid.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3500000417232513);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public int getCloneTimer() {
        return (Integer)this.field_70180_af.func_187225_a(CLONE_TIMER);
    }

    public void setCloneTimer(int t) {
        this.field_70180_af.func_187227_b(CLONE_TIMER, (Object)t);
    }

    public boolean isClone() {
        return (Boolean)this.field_70180_af.func_187225_a(CLONE);
    }

    public void setClone(boolean locked) {
        this.field_70180_af.func_187227_b(CLONE, (Object)locked);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLONE_TIMER, (Object)800);
        this.field_70180_af.func_187214_a(CLONE, (Object)false);
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 20) {
            this.func_70106_y();
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        this.func_184185_a(SoundEvents.field_187600_C, 2.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f - 2.0f);
        super.func_70645_a(par1DamageSource);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76346_g() != null && !(par1DamageSource.func_76346_g() instanceof EntityPlayer) && par1DamageSource.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)par1DamageSource.func_76346_g());
        }
        this.func_184185_a(SoundEvents.field_187600_C, 0.25f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f - 2.5f);
        super.func_70097_a(par1DamageSource, par2);
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70636_d() {
        float f;
        if (this.field_70170_p.field_72995_K) {
            this.func_70691_i(0.06f);
        }
        if (this.getCloneTimer() <= 0 && !this.isClone()) {
            this.setCloneTimer(1100);
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    EntityNightWarrior nightWarrior = new EntityNightWarrior(this.field_70170_p);
                    nightWarrior.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, MathHelper.func_76142_g((float)(this.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    nightWarrior.setClone(true);
                    nightWarrior.func_180482_a(this.field_70170_p.func_175649_E(nightWarrior.func_180425_c()), null);
                    this.field_70170_p.func_72838_d((Entity)nightWarrior);
                }
            }
        } else {
            this.setCloneTimer(this.getCloneTimer() - 1);
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)))) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.func_70106_y();
        }
        if (this.isClone() && !this.field_70170_p.field_72995_K && this.field_70173_aa >= 1100) {
            this.func_70106_y();
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        EntityItem entityitem = this.func_145779_a(RAItemLoader.getItem("hero_aura_3"), 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        if (this.isClone()) {
            return;
        }
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            boolean flag;
            double d0;
            ItemStack itemstack = this.func_184582_a(entityequipmentslot);
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    d0 = 5.0;
                    break;
                }
                case ARMOR: {
                    d0 = this.field_184655_bs[entityequipmentslot.func_188454_b()];
                    break;
                }
                default: {
                    d0 = 0.0;
                }
            }
            boolean bl = flag = d0 > 1.0;
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack) || !wasRecentlyHit && !flag || !((double)(this.field_70146_Z.nextFloat() - (float)lootingModifier * 0.01f) < d0)) continue;
            if (!flag && itemstack.func_77984_f()) {
                itemstack.func_77964_b(itemstack.func_77958_k() - this.field_70146_Z.nextInt(1 + this.field_70146_Z.nextInt(Math.max(itemstack.func_77958_k() - 3, 1))));
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        RpgData.getRpgData((Entity)this).setLevel(100);
        float health = this.isClone() ? 15.0f : 1000.0f;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
        this.func_70606_j(health);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(RAItemLoader.getItem("night_warrior_sword")));
        return super.func_180482_a(difficulty, livingdata);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74757_a("isClone", this.isClone());
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.setClone(compound.func_74767_n("isClone"));
    }
}

